/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.other;

import com.hungteen.pvz.common.entity.misc.ZombieHandEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.base.AbstractBossZombieEntity;
import com.hungteen.pvz.common.entity.zombie.other.MournerZombieEntity;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class NobleZombieEntity
extends AbstractBossZombieEntity {
    private static final DataParameter<Integer> TP_TICK = EntityDataManager.func_187226_a(NobleZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int summonTick;
    private final int minSummonTick = 300;
    private final int maxSummonTick = 600;
    private final int minTpCD = 400;
    private final int maxTpCD = 800;
    private final int minSleepAttackCD = 360;
    private final int maxSleepAttackCD = 1000;

    public NobleZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setAttackTime(this.maxSleepAttackCD / 5);
        this.summonTick = this.maxSummonTick / 3;
        this.setTpTick(-this.maxTpCD / 2);
        this.field_70728_aV = 1000;
        this.setIsWholeBody();
        this.canBeFrozen = true;
        this.hasDirectDefence = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TP_TICK, (Object)0);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.17f);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(20.0);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DIRT_RISE.get());
            ZombieHandEntity.spawnRangeZombieHands(this.field_70170_p, this, 6);
            for (int i = 0; i < this.getZombieLevel() / 2 + 5; ++i) {
                MournerZombieEntity zombie = (MournerZombieEntity)((EntityType)EntityRegister.MOURNER_ZOMBIE.get()).func_200721_a(this.field_70170_p);
                this.onBossSummon(zombie, WorldUtil.getSuitableHeightRandomPos(this.field_70170_p, this.func_233580_cy_(), 10, 20));
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (!this.field_70170_p.field_72995_K && !this.canZombieNormalUpdate()) {
            this.setTpTick(-this.maxTpCD);
        }
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.summonTick > 0) {
                --this.summonTick;
            } else {
                this.summonTick = MathUtil.getRandomMinMax(this.func_70681_au(), this.minSummonTick, this.maxSummonTick);
                this.checkAndSummonMournerZombie();
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            } else {
                this.setAttackTime(MathUtil.getRandomMinMax(this.func_70681_au(), this.minSleepAttackCD, this.maxSleepAttackCD));
                this.checkAndSleepPlant();
            }
        } else if (this.getAttackTime() < 20) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_(), this.func_226278_cu_() + 2.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (this.getTpTick() < 0) {
            this.setTpTick(this.getTpTick() + 1);
        } else if (this.getTpTick() == 0) {
            if (this.func_70681_au().nextInt(5) == 0) {
                this.setTpTick(1);
            }
        } else {
            if (this.getTpTick() >= this.getTpCD()) {
                this.checkAndTeleport();
            }
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 9; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (double)(this.func_70681_au().nextInt(5) - 2), this.func_226278_cu_() + (double)this.func_70681_au().nextInt(3), this.func_226281_cx_() + (double)(this.func_70681_au().nextInt(5) - 2), 0.0, 0.0, 0.0);
                }
            }
            this.setTpTick(this.getTpTick() + 1);
        }
    }

    private void checkAndTeleport() {
        BlockPos teleportPos = this.func_70638_az() == null ? this.func_233580_cy_() : this.func_70638_az().func_233580_cy_();
        this.setTpTick(-this.func_70681_au().nextInt(this.maxTpCD - this.minTpCD + 1) - this.minTpCD);
        this.teleportToPos(teleportPos.func_177958_n(), teleportPos.func_177956_o(), teleportPos.func_177952_p());
        ZombieHandEntity.spawnRangeZombieHands(this.field_70170_p, this, 3);
    }

    protected void checkAndSummonMournerZombie() {
        if (this.nearbyZombieCount >= this.maxZombieSurround) {
            this.checkAndSummonZombieHand();
            return;
        }
        int max = Math.min(this.maxZombieSurround - this.nearbyZombieCount, 3);
        for (int i = 0; i < MathUtil.getRandomMinMax(this.func_70681_au(), 1 + max / 2, max + 1); ++i) {
            MournerZombieEntity zombie = (MournerZombieEntity)((EntityType)EntityRegister.MOURNER_ZOMBIE.get()).func_200721_a(this.field_70170_p);
            this.onBossSummon(zombie, this.func_70638_az() == null ? this.func_233580_cy_() : this.func_70638_az().func_233580_cy_());
        }
    }

    private void checkAndSleepPlant() {
        float range = 50.0f;
        List list = this.field_70170_p.func_175647_a(PVZPlantEntity.class, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0), plant -> EntityUtil.canTargetEntity((Entity)this, (Entity)plant));
        if (list.isEmpty()) {
            return;
        }
        int pos = this.func_70681_au().nextInt(list.size());
        PVZPlantEntity plant2 = (PVZPlantEntity)list.get(pos);
        float radius = 3.0f;
        for (PVZPlantEntity target : this.field_70170_p.func_175647_a(PVZPlantEntity.class, EntityUtil.getEntityAABB((Entity)plant2, 3.0, 3.0), p -> EntityUtil.canTargetEntity((Entity)this, (Entity)p))) {
            target.sleepTime = 2400;
        }
    }

    private void checkAndSummonZombieHand() {
        int cnt = this.getHandSummonNum();
        List<LivingEntity> list = EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0));
        for (int i = 0; i < list.size(); ++i) {
            if (i + cnt < list.size() && this.func_70681_au().nextInt(5) != 0) continue;
            ZombieHandEntity hand = (ZombieHandEntity)((EntityType)EntityRegister.ZOMBIE_HAND.get()).func_200721_a(this.field_70170_p);
            hand.summonByOwner((Entity)this);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, hand, WorldUtil.getSuitableHeightPos(this.field_70170_p, list.get(i).func_233580_cy_()));
            if (--cnt <= 0) break;
        }
    }

    @Override
    public void checkAndHeal(float percent) {
        if (percent < 0.5f) {
            this.func_70691_i(0.4f);
        } else if (percent < 0.16666667f) {
            this.func_70691_i(0.8f);
        }
    }

    public void teleportToPos(double x, double y, double z) {
        boolean flag2;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        if (flag && (flag2 = this.func_213373_a(x, y, z, true))) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        amount = amount >= 10.0f ? (amount /= 3.0f) : (amount /= 2.0f);
        return super.func_70097_a(source, amount);
    }

    @Override
    public float getLife() {
        return 1000.0f;
    }

    @Override
    public float getExtraLife() {
        return 1000.0f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)1.9f);
    }

    protected int getTpCD() {
        float percent = this.bossInfo.func_186738_f();
        if (percent < 0.33333334f) {
            return 60;
        }
        if (percent < 0.6666667f) {
            return 80;
        }
        return 100;
    }

    protected int getHandSummonNum() {
        float percent = this.bossInfo.func_186738_f();
        return percent < 0.33333334f ? this.nearbyPlantCount / 5 + 3 : (percent < 0.6666667f ? this.nearbyPlantCount / 8 + 2 : this.nearbyPlantCount / 10 + 1);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("summon_zombie_tick")) {
            this.summonTick = compound.func_74762_e("summon_zombie_tick");
        }
        if (compound.func_74764_b("zombie_tp_tick")) {
            this.setTpTick(compound.func_74762_e("zombie_tp_tick"));
        }
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("summon_zombie_tick", this.summonTick);
        compound.func_74768_a("zombie_tp_tick", this.getTpTick());
    }

    public int getTpTick() {
        return (Integer)this.field_70180_af.func_187225_a(TP_TICK);
    }

    public void setTpTick(int tick) {
        this.field_70180_af.func_187227_b(TP_TICK, (Object)tick);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.NOBLE_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.NOBLE_ZOMBIE;
    }
}

