/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.part;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.common.entity.PVZMultiPartEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class PVZZombiePartEntity
extends PVZMultiPartEntity {
    public PVZZombiePartEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public PVZZombiePartEntity(PVZZombieEntity owner, float sizeX, float sizeY) {
        super((EntityType)EntityRegister.ZOMBIE_PART.get(), (LivingEntity)owner, sizeX, sizeY);
    }

    public void onOwnerBeMini(PVZZombieEntity zombie) {
        float scale = zombie.isMiniZombie() ? 0.4f : 1.0f;
        this.setPartWidth(this.MaxWidth * scale);
        this.setPartHeight(this.MaxHeight * scale);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (EntityUtil.isEntityValid((Entity)this.getOwner())) {
            return this.getOwner().func_70097_a(source, damage);
        }
        return false;
    }

    public Optional<PVZZombieEntity> getZombie() {
        LivingEntity owner = this.getOwner();
        if (!(owner instanceof PVZZombieEntity)) {
            PVZMod.LOGGER.warn("Wrong Owner Entity for Zombie's Part !");
            return null;
        }
        return Optional.ofNullable((PVZZombieEntity)owner);
    }
}

