/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.poolday;

import com.hungteen.pvz.common.entity.PVZMultiPartEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.entity.zombie.part.PVZZombiePartEntity;
import com.hungteen.pvz.common.entity.zombie.poolday.BobsleZombieEntity;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IMultiPartEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BobsleTeamEntity
extends PVZZombieEntity
implements IMultiPartEntity {
    public static final int PART_NUM = 2;
    private static final int MAX_OUT_SNOW_TICK = 100;
    private PVZZombiePartEntity[] parts = new PVZZombiePartEntity[2];
    private int outSnowTick;

    public BobsleTeamEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setIsWholeBody();
        this.resetParts();
        this.setImmuneAllEffects();
        this.canBeMini = false;
        this.maxDeathTime = 1;
    }

    @Override
    public PVZZombieEntity.Type getZombieType() {
        return PVZZombieEntity.Type.NORMAL;
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.275f);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0);
    }

    @Override
    public void resetParts() {
        this.removeParts();
        for (int i = 0; i < 2; ++i) {
            this.parts[i] = new PVZZombiePartEntity(this, 1.0f, 1.5f);
            this.parts[i].setOwner((LivingEntity)this);
        }
    }

    @Override
    public void removeParts() {
        for (int i = 0; i < 2; ++i) {
            if (this.parts[i] == null) continue;
            this.parts[i].func_70106_y();
            this.parts[i] = null;
        }
    }

    @Override
    public void updateParts() {
        for (int i = 0; i < 2; ++i) {
            if (this.parts[i] == null) continue;
            if (!this.parts[i].isAddedToWorld()) {
                this.field_70170_p.func_217376_c((Entity)this.parts[i]);
            }
            float j = 6.28318f * this.field_70759_as / 360.0f;
            float dis = this.getPartOffset(i);
            Vector3d pos = this.func_213303_ch();
            this.parts[i].field_70126_B = this.field_70177_z;
            this.parts[i].field_70127_C = this.field_70125_A;
            this.parts[i].func_70012_b(pos.func_82615_a() - Math.sin(j) * (double)dis, pos.func_82617_b() + (double)0.05f, pos.func_82616_c() + Math.cos(j) * (double)dis, this.field_70177_z, this.field_70125_A);
            this.parts[i].setOwner((LivingEntity)this);
        }
    }

    @Override
    public PVZMultiPartEntity[] getMultiParts() {
        return this.parts;
    }

    public float getPartOffset(int num) {
        if (num == 0) {
            return -1.5f;
        }
        if (num == 1) {
            return -2.5f;
        }
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateParts();
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_203005_aq() || this.func_233570_aj_() && !EntityUtil.isOnSnow((Entity)this) && !EntityUtil.isOnIce((Entity)this)) {
                ++this.outSnowTick;
                if (this.outSnowTick > 100) {
                    this.onFallBody(DamageSource.field_205132_u);
                    this.onZombieRemove();
                    this.func_70106_y();
                }
            } else {
                this.outSnowTick = 0;
            }
        }
    }

    @Override
    protected void onZombieRemove() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                BobsleZombieEntity zombie = (BobsleZombieEntity)((EntityType)EntityRegister.BOBSLE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
                ZombieUtil.copySummonZombieData(this, zombie);
                EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_233580_cy_(), 2);
            }
        }
    }

    @Override
    protected void setBodyStates(ZombieDropBodyEntity body) {
        super.setBodyStates(body);
        body.setFriction(0.95f);
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.25f, (float)1.4f);
    }

    @Override
    public float getLife() {
        return 60.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("out_snow_tick")) {
            this.outSnowTick = compound.func_74762_e("out_snow_tick");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("out_snow_tick", this.outSnowTick);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.BOBSLE_TEAM;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BOBSLE_TEAM;
    }
}

