/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.poolday;

import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.common.entity.ai.goal.attack.PVZZombieAttackGoal;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZHurtByTargetGoal;
import com.hungteen.pvz.common.entity.ai.navigator.ZombieWaterPathNavigator;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.poolday.DolphinRiderZombieEntity;
import com.hungteen.pvz.common.entity.zombie.poolday.ZombieDolphinEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.ICanAttract;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DolphinRiderEntity
extends PVZZombieEntity {
    private static final float UP_SPEED = 0.05f;
    protected final float HorizontalJumpSpeed = 1.5f;
    protected final float VerticalJumpSpeed = 0.7f;
    protected Vector3d jumpDstPoint = Vector3d.field_186680_a;
    protected int dolphin_jump_cnt;

    public DolphinRiderEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.setIsWholeBody();
        this.canBeMini = false;
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.8f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new PVZZombieAttackGoal(this, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new PVZHurtByTargetGoal((CreatureEntity)this, 10));
        this.field_70714_bg.func_75776_a(0, (Goal)new DolphinJumpGoal(this));
        this.registerTargetGoals();
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                if (this.shouldUp()) {
                    Vector3d v = this.func_213322_ci();
                    this.func_213293_j(v.func_82615_a(), 0.05f, v.func_82616_c());
                }
                if (EntityUtil.isEntityValid((Entity)this) && this.dolphin_jump_cnt == this.getMaxJumpCount()) {
                    this.separate();
                    return;
                }
            }
            if (this.func_233570_aj_() && EntityUtil.isEntityValid((Entity)this)) {
                this.separate();
                return;
            }
        }
    }

    public void perfromJump() {
        Optional.ofNullable(this.func_70638_az()).ifPresent(target -> {
            Vector3d vec = MathUtil.getHorizontalNormalizedVec(this.func_213303_ch(), this.jumpDstPoint);
            this.getClass();
            double speedXZ = 1.5 + (this.field_70146_Z.nextDouble() - 0.6) / 3.0;
            this.getClass();
            double speedY = (double)0.7f + (this.field_70146_Z.nextDouble() - 0.3) / 2.0;
            this.func_213293_j(vec.field_72450_a * speedXZ, speedY, vec.field_72449_c * speedXZ);
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DOLPHIN_JUMP.get());
        });
    }

    @Override
    public boolean canBeAttractedBy(ICanAttract defender) {
        if (defender instanceof IPVZPlant) {
            Plants plant = ((IPVZPlant)((Object)defender)).getPlantEnumName();
            return plant == Plants.TALL_NUT || plant == Plants.GIANT_WALL_NUT;
        }
        return true;
    }

    @Override
    public void attractBy(ICanAttract defender) {
        super.attractBy(defender);
        this.separate();
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.WALL_HIT.get());
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || this.isDolphinJumping();
    }

    public void separate() {
        DolphinRiderZombieEntity zombie = (DolphinRiderZombieEntity)((EntityType)EntityRegister.DOLPHIN_RIDER_ZOMBIE.get()).func_200721_a(this.field_70170_p);
        ZombieUtil.copySummonZombieData(this, zombie);
        EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, (MobEntity)zombie, this.func_233580_cy_(), 1);
        zombie.setZombieType(PVZZombieEntity.Type.NORMAL);
        ZombieDolphinEntity dolphin = (ZombieDolphinEntity)((EntityType)EntityRegister.ZOMBIE_DOLPHIN.get()).func_200721_a(this.field_70170_p);
        ZombieUtil.copySummonZombieData(this, dolphin);
        EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, (MobEntity)dolphin, this.func_233580_cy_(), 3);
        this.func_70106_y();
    }

    public int getMaxJumpCount() {
        return 1;
    }

    protected boolean shouldUp() {
        return this.func_233571_b_((ITag)FluidTags.field_206959_a) > (double)(this.func_70047_e() / 2.0f);
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.7f, (float)1.6f);
    }

    @Override
    protected float func_189749_co() {
        return 0.94f;
    }

    @Override
    protected PathNavigator func_175447_b(World worldIn) {
        return new ZombieWaterPathNavigator((MobEntity)this, worldIn);
    }

    @Override
    public float getLife() {
        return 60.0f;
    }

    public boolean isDolphinJumping() {
        return this.getAttackTime() > 0;
    }

    public int getJumpCD() {
        return 20;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.DOLPHIN_RIDER;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("jump_dst_point")) {
            CompoundNBT nbt = compound.func_74775_l("jump_dst_point");
            this.jumpDstPoint = new Vector3d(nbt.func_74769_h("XXX"), nbt.func_74769_h("YYY"), nbt.func_74769_h("ZZZ"));
        }
        if (compound.func_74764_b("dolphin_jump_count")) {
            this.dolphin_jump_cnt = compound.func_74762_e("dolphin_jump_count");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("XXX", this.jumpDstPoint.field_72450_a);
        nbt.func_74780_a("YYY", this.jumpDstPoint.field_72448_b);
        nbt.func_74780_a("ZZZ", this.jumpDstPoint.field_72449_c);
        compound.func_218657_a("jump_dst_point", (INBT)nbt);
        compound.func_74768_a("dolphin_jump_count", this.dolphin_jump_cnt);
    }

    static class DolphinJumpGoal
    extends Goal {
        private final DolphinRiderEntity zombie;
        private int delayCnt = 0;

        public DolphinJumpGoal(DolphinRiderEntity zombie) {
            this.zombie = zombie;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.zombie.getAttackTime() > 0) {
                return true;
            }
            if (this.delayCnt > 0) {
                --this.delayCnt;
                return false;
            }
            LivingEntity target = this.zombie.func_70638_az();
            int left_jump_chance = this.zombie.getMaxJumpCount() - this.zombie.dolphin_jump_cnt;
            if (!EntityUtil.isEntityValid((Entity)target) || !this.zombie.func_70090_H() || left_jump_chance <= 0) {
                return false;
            }
            double dis = this.zombie.func_70068_e((Entity)target);
            if (dis < 64.0 || dis > (double)Math.max(120, 120 * left_jump_chance * left_jump_chance)) {
                return false;
            }
            Vector3d vector3d = MathUtil.getHorizontalNormalizedVec(this.zombie.func_213303_ch(), target.func_213303_ch());
            this.zombie.getClass();
            Vector3d vec = vector3d.func_186678_a(1.5).func_72441_c(0.0, (double)(this.zombie.VerticalJumpSpeed * 2.0f), 0.0);
            if (!EntityUtil.canEntityPass((Entity)this.zombie, vec, 10.0f)) {
                this.delayCnt = this.zombie.field_70146_Z.nextInt(50);
                return false;
            }
            this.zombie.jumpDstPoint = target.func_213303_ch();
            this.zombie.func_70624_b(target);
            return true;
        }

        public void func_75249_e() {
            this.zombie.setAttackTime(this.zombie.getJumpCD());
            this.zombie.func_213395_q(false);
        }

        public boolean func_75253_b() {
            return this.zombie.getAttackTime() > 0;
        }

        public void func_75246_d() {
            int time = this.zombie.getAttackTime();
            int cd = this.zombie.getJumpCD();
            this.zombie.func_70671_ap().func_220674_a(this.zombie.jumpDstPoint);
            if (time == cd * 3 / 4) {
                this.zombie.perfromJump();
            } else if (time == 1) {
                ++this.zombie.dolphin_jump_cnt;
            }
            this.zombie.setAttackTime(Math.max(0, time - 1));
        }
    }
}

