/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.poolday;

import com.hungteen.pvz.common.entity.ai.goal.attack.PVZZombieAttackGoal;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ZombieDolphinEntity
extends PVZZombieEntity {
    public ZombieDolphinEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
        this.canBeMini = false;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 2.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new ZombieDolphinJumpGoal(this, 10));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new PVZZombieAttackGoal(this, true));
        this.registerTargetGoals();
    }

    @Override
    public PVZZombieEntity.Type getZombieType() {
        return PVZZombieEntity.Type.NORMAL;
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)1.2f);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
    }

    @Override
    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ >= this.maxDeathTime) {
            for (int i = 0; i < 10; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
            this.onZombieRemove();
            this.func_70106_y();
        }
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.0f, (float)0.7f);
    }

    @Override
    public float getLife() {
        return 12.0f;
    }

    @Override
    protected float func_189749_co() {
        return 0.88f;
    }

    public double func_70042_X() {
        return -0.5;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_205710_ba() {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public int func_70627_aG() {
        return 200;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return (SoundEvent)SoundRegister.DOLPHIN_SAY.get();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    @Override
    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.ZOMBIE_DOLPHIN;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.ZOMBIE_DOLPHIN;
    }

    static class ZombieDolphinJumpGoal
    extends JumpGoal {
        private static final int[] JUMP_DISTANCES = new int[]{0, 1, 4, 5, 6, 7};
        private final ZombieDolphinEntity dolphin;
        private final int chance;
        private boolean breached;

        public ZombieDolphinJumpGoal(ZombieDolphinEntity zombie, int chance) {
            this.dolphin = zombie;
            this.chance = chance;
        }

        public boolean func_75250_a() {
            if (this.dolphin.func_70681_au().nextInt(this.chance) != 0) {
                return false;
            }
            Direction direction = this.dolphin.func_184172_bi();
            int i = direction.func_82601_c();
            int j = direction.func_82599_e();
            BlockPos blockpos = this.dolphin.func_233580_cy_();
            for (int k : JUMP_DISTANCES) {
                if (this.canJumpTo(blockpos, i, j, k) && this.isAirAbove(blockpos, i, j, k)) continue;
                return false;
            }
            return true;
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.func_177982_a(dx * scale, 0, dz * scale);
            return this.dolphin.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a) && !this.dolphin.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.dolphin.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 1, dz * scale)).func_196958_f() && this.dolphin.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 2, dz * scale)).func_196958_f();
        }

        public boolean func_75253_b() {
            double d0 = this.dolphin.func_213322_ci().field_72448_b;
            return !(d0 * d0 < (double)0.03f && this.dolphin.field_70125_A != 0.0f && Math.abs(this.dolphin.field_70125_A) < 10.0f && this.dolphin.func_70090_H() || this.dolphin.field_70122_E);
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            Direction direction = this.dolphin.func_184172_bi();
            this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 0.6, 0.7, (double)direction.func_82599_e() * 0.6));
            this.dolphin.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.dolphin.field_70125_A = 0.0f;
        }

        public void func_75246_d() {
            boolean flag = this.breached;
            if (!flag) {
                FluidState ifluidstate = this.dolphin.field_70170_p.func_204610_c(this.dolphin.func_233580_cy_());
                this.breached = ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a);
            }
            if (this.breached && !flag) {
                this.dolphin.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
            }
            Vector3d vec3d = this.dolphin.func_213322_ci();
            if (vec3d.field_72448_b * vec3d.field_72448_b < (double)0.03f && this.dolphin.field_70125_A != 0.0f) {
                this.dolphin.field_70125_A = MathHelper.func_226167_j_((float)this.dolphin.field_70125_A, (float)0.0f, (float)0.2f);
            } else {
                double d0 = Math.sqrt(Entity.func_213296_b((Vector3d)vec3d));
                double d1 = Math.signum(-vec3d.field_72448_b) * Math.acos(d0 / vec3d.func_72433_c()) * 57.2957763671875;
                this.dolphin.field_70125_A = (float)d1;
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final ZombieDolphinEntity dolphin;

        public MoveHelperController(ZombieDolphinEntity dolphinIn) {
            super((MobEntity)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void func_75641_c() {
            if (this.dolphin.func_70090_H()) {
                this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.dolphin.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.dolphin.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.dolphin.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.dolphin.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.field_70761_aq = this.dolphin.field_70177_z = this.func_75639_a(this.dolphin.field_70177_z, f, 10.0f);
                    this.dolphin.field_70759_as = this.dolphin.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.dolphin.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                    if (this.dolphin.func_70090_H()) {
                        this.dolphin.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.field_70125_A = this.func_75639_a(this.dolphin.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        this.dolphin.field_191988_bg = f3 * f1;
                        this.dolphin.field_70701_bs = -f4 * f1;
                    } else {
                        this.dolphin.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.func_70659_e(0.0f);
                this.dolphin.func_184646_p(0.0f);
                this.dolphin.func_70657_f(0.0f);
                this.dolphin.func_191989_p(0.0f);
            }
        }
    }
}

