/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.poolday;

import com.hungteen.pvz.api.interfaces.IHasWheel;
import com.hungteen.pvz.common.entity.PVZMultiPartEntity;
import com.hungteen.pvz.common.entity.zombie.base.CarZombieEntity;
import com.hungteen.pvz.common.entity.zombie.part.PVZZombiePartEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IMultiPartEntity;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ZomboniEntity
extends CarZombieEntity
implements IMultiPartEntity,
IHasWheel {
    private PVZZombiePartEntity part;

    public ZomboniEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setImmuneAllEffects();
        this.resetParts();
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.18f);
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (!this.field_70170_p.field_72995_K) {
            FrostWalkerEnchantment.func_185266_a((LivingEntity)this, (World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (int)1);
            BlockPos blockpos = this.func_233580_cy_();
            BlockState state = (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(1));
            if ((this.field_70170_p.func_175623_d(blockpos) || this.field_70170_p.func_180495_p(blockpos).func_177230_c() == Blocks.field_150433_aE) && state.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, state);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateParts();
    }

    @Override
    public void spikeWheelBy(LivingEntity entity) {
        this.func_70097_a(PVZDamageSource.func_92087_a((Entity)entity), EntityUtil.getMaxHealthDamage((LivingEntity)this, 2.0f));
    }

    @Override
    public void resetParts() {
        this.removeParts();
        this.part = new PVZZombiePartEntity(this, 1.2f, 1.5f);
        this.part.setOwner((LivingEntity)this);
    }

    @Override
    public void removeParts() {
        if (this.part != null) {
            this.part.func_70106_y();
            this.part = null;
        }
    }

    @Override
    public void updateParts() {
        if (this.part != null) {
            if (!this.part.isAddedToWorld()) {
                this.field_70170_p.func_217376_c((Entity)this.part);
            }
            float j = 6.28318f * this.field_70177_z / 360.0f;
            float dis = this.getPartOffset();
            Vector3d pos = this.func_213303_ch();
            this.part.field_70126_B = this.field_70177_z;
            this.part.field_70127_C = this.field_70125_A;
            this.part.func_70012_b(pos.func_82615_a() - Math.sin(j) * (double)dis, pos.func_82617_b() + (double)0.2f, pos.func_82616_c() + Math.cos(j) * (double)dis, this.field_70177_z, this.field_70125_A);
            this.part.setOwner((LivingEntity)this);
        }
    }

    @Override
    public PVZMultiPartEntity[] getMultiParts() {
        return new PVZMultiPartEntity[]{this.part};
    }

    public void func_70106_y() {
        this.removeParts();
        super.func_70106_y();
    }

    public float getPartOffset() {
        return 1.2f;
    }

    @Override
    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SoundRegister.METAL_HIT.get();
    }

    @Override
    protected Optional<SoundEvent> getSpawnSound() {
        return Optional.ofNullable(SoundRegister.CAR_SPAWN.get());
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)2.3f);
    }

    @Override
    public float getLife() {
        return 130.0f;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.ZOMBONI;
    }
}

