/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.poolnight;

import com.hungteen.pvz.common.entity.ai.navigator.ZombiePathNavigator;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.ICanAttract;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class BalloonZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Boolean> HAS_BALLOON = EntityDataManager.func_187226_a(BalloonZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final MovementController FlyController = new FlyingMovementController((MobEntity)this, 360, true);
    private final MovementController GroundController = new MovementController((MobEntity)this);
    private PathNavigator FlyNavigator;
    private PathNavigator GroundNavigator;

    public BalloonZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.updateBalloonState(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_BALLOON, (Object)true);
    }

    @Override
    protected void func_184651_r() {
        this.FlyNavigator = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
        this.GroundNavigator = new ZombiePathNavigator((MobEntity)this, this.field_70170_p);
        super.func_184651_r();
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.19f);
        this.func_110148_a(Attributes.field_233822_e_).func_111128_a(0.5);
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (data.equals(HAS_BALLOON)) {
            this.updateBalloonState(this.hasBalloon());
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.hasBalloon() && this.canHitBalloon(source)) {
            this.onBalloonExplode();
            amount = 0.0f;
        }
        return super.func_70097_a(source, amount);
    }

    private boolean canHitBalloon(DamageSource source) {
        if (source.func_76364_f() instanceof ArrowEntity) {
            return true;
        }
        if (source instanceof PVZDamageSource) {
            return ((PVZDamageSource)source).isThornDamage();
        }
        return false;
    }

    public void onBalloonExplode() {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BALLOON_POP.get());
        }
        this.setBalloon(false);
        this.updateBalloonState(false);
    }

    private void updateBalloonState(boolean has) {
        this.func_189654_d(has);
        this.field_70765_h = has ? this.FlyController : this.GroundController;
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || this.hasBalloon();
    }

    @Override
    public boolean canBeTargetBy(LivingEntity living) {
        return super.canBeTargetBy(living) && !this.hasBalloon();
    }

    @Override
    public boolean canClimbWalls() {
        return super.canClimbWalls() && !this.hasBalloon();
    }

    @Override
    public boolean canBeAttractedBy(ICanAttract defender) {
        return !this.hasBalloon();
    }

    @Override
    public float getLife() {
        return 23.0f;
    }

    @Override
    public boolean canBeButter() {
        return !this.hasBalloon();
    }

    @Override
    public boolean canBeFrozen() {
        return !this.hasBalloon();
    }

    @Override
    public boolean canBeCold() {
        return !this.hasBalloon();
    }

    public PathNavigator func_70661_as() {
        if (this.hasBalloon()) {
            if (!(this.field_70699_by instanceof FlyingPathNavigator)) {
                this.field_70699_by = this.FlyNavigator;
            }
        } else if (!(this.field_70699_by instanceof GroundPathNavigator)) {
            this.field_70699_by = this.GroundNavigator;
        }
        return super.func_70661_as();
    }

    @Override
    protected Optional<SoundEvent> getSpawnSound() {
        return Optional.ofNullable(SoundRegister.BALLOON_FULL.get());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("has_balloon")) {
            this.setBalloon(compound.func_74767_n("has_balloon"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("has_balloon", this.hasBalloon());
    }

    public void setBalloon(boolean has) {
        this.field_70180_af.func_187227_b(HAS_BALLOON, (Object)has);
    }

    public boolean hasBalloon() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BALLOON);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.BALLOON_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BALLOON_ZOMBIE;
    }
}

