/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.poolnight;

import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class JackInBoxZombieEntity
extends PVZZombieEntity
implements IHasMetal {
    private static final DataParameter<Boolean> HAS_BOX = EntityDataManager.func_187226_a(JackInBoxZombieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final int JACK_EXPLODE_CD = 30;
    private final int MinExplodeTime = 300;
    private final int MaxExplodeTime = 3000;

    public JackInBoxZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setExplosionTime();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_BOX, (Object)true);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new PlayJackBoxGoal(this));
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.updateSpeed(true);
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K && this.hasBox()) {
            int tick = this.getAttackTime();
            if (tick < 0) {
                if (tick == -1 && this.canJackExplode()) {
                    this.setAttackTime(30);
                    EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.JACK_SURPRISE.get());
                } else {
                    this.setAttackTime(Math.min(tick + 1, -1));
                }
            } else {
                if (tick == 1) {
                    this.doJackExplode();
                }
                this.setAttackTime(Math.max(tick - 1, 0));
            }
        }
        if (this.field_70170_p.field_72995_K && this.hasBox() && this.getAttackTime() == 3) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void doJackExplode() {
        Explosion.Mode mode;
        float range = 5.0f;
        float damageMultiple = 1.5f;
        EntityUtil.getWholeTargetableEntities((Entity)this, EntityUtil.getEntityAABB((Entity)this, 5.0, 5.0)).forEach(target -> {
            PVZDamageSource source = PVZDamageSource.explode((Entity)this);
            if (target instanceof LivingEntity) {
                target.func_70097_a((DamageSource)source, EntityUtil.getMaxHealthDamage((LivingEntity)target, 1.5f));
            } else {
                target.func_70097_a((DamageSource)source, 100.0f);
            }
        });
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.CAR_EXPLOSION.get());
        Explosion.Mode mode2 = mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
        float strenth = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 3.0f : (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL ? 2.5f : 2.0f);
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), strenth, mode);
        this.func_70106_y();
    }

    public void func_184206_a(DataParameter<?> data) {
        super.func_184206_a(data);
        if (data.equals(HAS_BOX)) {
            this.updateSpeed(this.hasBox());
        }
    }

    @Override
    public boolean canBeTargetBy(LivingEntity living) {
        return super.canBeTargetBy(living) && !this.isInExplosion();
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || this.isInExplosion();
    }

    protected void playJackBoxSound() {
        this.field_70170_p.func_217369_A().stream().filter(player -> this.func_70068_e((Entity)player) <= 150.0).forEach(player -> player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            if (l.getPlayerData().getOtherStats().playSoundTick == 0) {
                PlayerUtil.playClientSound(player, 10);
                l.getPlayerData().getOtherStats().playSoundTick = 300;
            }
        }));
    }

    private void updateSpeed(boolean is) {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(is ? 0.25 : (double)0.225f);
    }

    @Override
    public boolean canLostHand() {
        return super.canLostHand() && !this.hasBox();
    }

    @Override
    protected void setBodyStates(ZombieDropBodyEntity body) {
        super.setBodyStates(body);
        body.setHandDefence(this.hasBox());
    }

    private boolean canJackExplode() {
        if (this.func_70638_az() == null) {
            return false;
        }
        return this.func_70068_e((Entity)this.func_70638_az()) <= 100.0;
    }

    public int func_70627_aG() {
        return 200;
    }

    private void setExplosionTime() {
        this.setAttackTime(-MathUtil.getRandomMinMax(this.func_70681_au(), 300, 3000));
    }

    @Override
    public float getLife() {
        return 40.0f;
    }

    public boolean isInExplosion() {
        return this.getAttackTime() > 0;
    }

    @Override
    public boolean hasMetal() {
        return this.hasBox();
    }

    @Override
    public void decreaseMetal() {
        this.setBox(false);
    }

    @Override
    public void increaseMetal() {
        this.setBox(true);
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.JACK_BOX;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("has_jack_box")) {
            this.setBox(compound.func_74767_n("has_jack_box"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("has_jack_box", this.hasBox());
    }

    public void setBox(boolean has) {
        this.field_70180_af.func_187227_b(HAS_BOX, (Object)has);
    }

    public boolean hasBox() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BOX);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.JACK_IN_BOX_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.JACK_IN_BOX_ZOMBIE;
    }

    static class PlayJackBoxGoal
    extends Goal {
        private final JackInBoxZombieEntity zombie;
        private final int PlayCD = 50;
        private int delayTick = 20;

        public PlayJackBoxGoal(JackInBoxZombieEntity zombie) {
            this.zombie = zombie;
        }

        public boolean func_75250_a() {
            if (--this.delayTick > 0 || !this.zombie.hasBox()) {
                return false;
            }
            return this.zombie.func_70681_au().nextFloat() < 0.2f;
        }

        public void func_75249_e() {
        }

        public boolean func_75253_b() {
            return this.zombie.hasBox();
        }

        public void func_75246_d() {
            if (this.zombie.field_70173_aa % this.PlayCD == 0) {
                this.zombie.playJackBoxSound();
            }
        }

        public void func_75251_c() {
            this.delayTick = 20;
        }
    }
}

