/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.roof;

import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.api.interfaces.IPVZZombie;
import com.hungteen.pvz.common.cache.InvasionCache;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZRandomTargetGoal;
import com.hungteen.pvz.common.entity.bullet.TargetArrowEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.ICanAttract;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BungeeZombieEntity
extends PVZZombieEntity {
    private static final DataParameter<Integer> BUNGEE_STATE = EntityDataManager.func_187226_a(BungeeZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BUNGEE_TYPE = EntityDataManager.func_187226_a(BungeeZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> ORIGIN_POS = EntityDataManager.func_187226_a(BungeeZombieEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private LivingEntity stealTarget;

    public BungeeZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.canBeMini = false;
        this.canBeStealByBungee = false;
        this.setImmuneAllEffects();
        this.setIsWholeBody();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BUNGEE_STATE, (Object)BungeeStates.WAIT.ordinal());
        this.field_70180_af.func_187214_a(BUNGEE_TYPE, (Object)BungeeTypes.STEAL.ordinal());
        this.field_70180_af.func_187214_a(ORIGIN_POS, (Object)BlockPos.field_177992_a);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setOriginPos(this.func_233580_cy_());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
    }

    @Override
    protected void func_184651_r() {
        this.registerTargetGoals();
    }

    @Override
    protected void registerTargetGoals() {
        this.field_70715_bh.func_75776_a(0, (Goal)new BungeeRandomTargetGoal(this, true, true, 40.0f, 50.0f));
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getBungeeState() == BungeeStates.PUSH_BACK) {
                this.setAttackTime(this.getAttackTime() - 1);
                this.func_213317_d(new Vector3d(0.0, 1.2, 0.0));
                if (this.getAttackTime() <= -60) {
                    this.func_70106_y();
                    if (this.getBungeeType() == BungeeTypes.SUMMON && EntityUtil.isEntityValid((Entity)this.getStealTarget())) {
                        this.getStealTarget().func_70106_y();
                    }
                }
                return;
            }
            if (this.getBungeeType() == BungeeTypes.STEAL) {
                this.tickSteal();
            } else if (this.getBungeeType() == BungeeTypes.HELP) {
                this.tickHelp();
            } else if (this.getBungeeType() == BungeeTypes.SUMMON) {
                this.tickSummon();
            }
        }
    }

    protected void tickHelp() {
        if (!this.isSuitableTarget(this.getStealTarget())) {
            if (this.getAttackTime() >= 0) {
                this.setAttackTime(-1);
            }
            this.setBungeeState(BungeeStates.UP);
        }
        if (this.getBungeeState() == BungeeStates.WAIT) {
            if (this.isSuitableTarget(this.getStealTarget())) {
                this.setBungeeState(BungeeStates.DOWN);
                EntityUtil.playSound((Entity)this.getStealTarget(), (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            }
        } else if (this.getBungeeState() == BungeeStates.DOWN) {
            if (this.isNearToTarget()) {
                this.setAttackTime(this.getStayTime());
                this.getStealTarget().func_184220_m((Entity)this);
                this.setBungeeState(BungeeStates.CATCH);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
            } else {
                this.moveToTarget();
            }
        } else if (this.getBungeeState() == BungeeStates.CATCH) {
            this.func_213317_d(Vector3d.field_186680_a);
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            if (this.getAttackTime() == 0) {
                this.setBungeeState(BungeeStates.UP);
            }
        } else if (this.getBungeeState() == BungeeStates.UP) {
            this.setAttackTime(this.getAttackTime() - 1);
            this.moveBackToOrigin();
            if (this.getAttackTime() < -60) {
                this.dealDamageAndRemove();
                return;
            }
        }
    }

    protected void tickSteal() {
        if (this.getBungeeState() != BungeeStates.WAIT && !this.isSuitableTarget(this.getStealTarget())) {
            this.setBungeeState(BungeeStates.BACK_WAIT);
            this.setStealTarget(null);
        }
        if (this.getBungeeState() == BungeeStates.WAIT) {
            if (this.isSuitableTarget(this.func_70638_az())) {
                if ((double)this.getOriginPos().func_177956_o() - this.func_70638_az().func_226278_cu_() <= 15.0) {
                    this.setOriginPos(this.func_70638_az().func_233580_cy_().func_177981_b(20));
                    this.setBungeeState(BungeeStates.BACK_WAIT);
                    return;
                }
                this.setBungeeState(BungeeStates.DOWN);
                this.setStealTarget(this.func_70638_az());
                this.shootArrowToTarget();
                EntityUtil.playSound((Entity)this.getStealTarget(), (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            }
        } else if (this.getBungeeState() == BungeeStates.BACK_WAIT) {
            this.moveBackToOrigin();
            if (this.func_70092_e(this.getOriginPos().func_177958_n(), this.getOriginPos().func_177956_o(), this.getOriginPos().func_177952_p()) <= 2.0) {
                this.setBungeeState(BungeeStates.WAIT);
                this.func_213317_d(Vector3d.field_186680_a);
            }
        } else if (this.getBungeeState() == BungeeStates.DOWN) {
            if (this.isNearToTarget()) {
                this.setAttackTime(this.getStayTime());
                this.getStealTarget().func_184220_m((Entity)this);
                this.setBungeeState(BungeeStates.CATCH);
                EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
            } else {
                this.moveToTarget();
            }
        } else if (this.getBungeeState() == BungeeStates.CATCH) {
            this.func_213317_d(Vector3d.field_186680_a);
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            this.getStealTarget().func_184220_m((Entity)this);
            if (this.getAttackTime() == 0) {
                this.setBungeeState(BungeeStates.UP);
            }
        } else if (this.getBungeeState() == BungeeStates.UP) {
            this.setAttackTime(this.getAttackTime() - 1);
            this.moveBackToOrigin();
            this.getStealTarget().func_184220_m((Entity)this);
            if (this.getAttackTime() < -60) {
                this.dealDamageAndRemove();
                return;
            }
        }
    }

    protected void tickSummon() {
        if (this.getBungeeState() != BungeeStates.WAIT && !EntityUtil.isEntityValid((Entity)this.getStealTarget())) {
            this.setBungeeState(BungeeStates.UP);
        }
        if (this.getBungeeState() == BungeeStates.WAIT) {
            if (this.func_184188_bt().isEmpty()) {
                this.summonZombie();
                this.setBungeeState(BungeeStates.DOWN);
                EntityUtil.playSound((Entity)this.getStealTarget(), (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            }
        } else if (this.getBungeeState() == BungeeStates.DOWN) {
            if (this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c() != Blocks.field_150350_a) {
                this.getStealTarget().func_184210_p();
                this.setAttackTime(0);
                this.setBungeeState(BungeeStates.UP);
            } else {
                this.getStealTarget().func_184220_m((Entity)this);
                this.func_213317_d(new Vector3d(0.0, -0.5, 0.0));
            }
        } else if (this.getBungeeState() == BungeeStates.UP) {
            this.moveBackToOrigin();
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.getAttackTime() < -60) {
                this.func_70106_y();
                return;
            }
        }
    }

    public void pushBack() {
        this.setBungeeState(BungeeStates.PUSH_BACK);
    }

    @Override
    public boolean canZombieTarget(Entity target) {
        return BungeeZombieEntity.canBungeeSteal(target);
    }

    @Override
    public boolean canBeTargetBy(LivingEntity living) {
        return super.canBeTargetBy(living) && this.getBungeeState() == BungeeStates.CATCH;
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || this.getBungeeState() != BungeeStates.CATCH;
    }

    public void summonZombie() {
        List<Zombies> list = InvasionCache.getOrDefaultZombieList(Zombies.DEFAULT_ZOMBIES);
        Zombies zombieType = list.get(this.field_70146_Z.nextInt(list.size()));
        Optional.ofNullable(ZombieUtil.getZombieEntity(this.field_70170_p, zombieType)).ifPresent(zombie -> {
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)zombie, this.func_233580_cy_());
            zombie.func_184220_m((Entity)this);
            this.setStealTarget((LivingEntity)zombie);
        });
    }

    public double func_70042_X() {
        return 0.0;
    }

    private void dealDamageAndRemove() {
        this.getStealTarget().func_70097_a((DamageSource)PVZDamageSource.causeDeadlyDamage((Entity)this, (Entity)this), EntityUtil.getMaxHealthDamage(this.getStealTarget()));
        this.func_70106_y();
    }

    public int getStayTime() {
        return 80;
    }

    @Override
    public boolean canBeAttractedBy(ICanAttract defender) {
        return false;
    }

    private void moveToTarget() {
        if (!EntityUtil.isEntityValid((Entity)this.getStealTarget())) {
            return;
        }
        Vector3d vec = this.getStealTarget().func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b();
        double speed = 0.55;
        this.func_213317_d(vec.func_216372_d(0.55, 0.55, 0.55));
    }

    private void moveBackToOrigin() {
        Vector3d vec = new Vector3d((double)this.getOriginPos().func_177958_n() - this.func_226277_ct_(), (double)this.getOriginPos().func_177956_o() - this.func_226278_cu_(), (double)this.getOriginPos().func_177952_p() - this.func_226281_cx_()).func_72432_b();
        double speed = 0.4;
        this.func_213317_d(vec.func_216372_d(0.4, 0.4, 0.4));
    }

    private boolean isNearToTarget() {
        return EntityUtil.isEntityValid((Entity)this.getStealTarget()) && this.func_70068_e((Entity)this.getStealTarget()) <= 2.0;
    }

    private void shootArrowToTarget() {
        TargetArrowEntity arrow = new TargetArrowEntity(this.field_70170_p, (LivingEntity)this);
        arrow.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        arrow.shoot(this.getStealTarget());
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    public static boolean canBungeeSteal(Entity target) {
        if (!(target instanceof LivingEntity) || EntityUtil.isEntityBoss((LivingEntity)target) || BungeeZombieEntity.isHoldingZombieDoll((LivingEntity)target)) {
            return false;
        }
        if (target instanceof IPVZZombie) {
            return ((IPVZZombie)target).canBeStealByBungee();
        }
        if (target instanceof IPVZPlant) {
            return true;
        }
        return EntityUtil.getCurrentMaxHealth((LivingEntity)target) < 80.0f;
    }

    protected boolean isSuitableTarget(LivingEntity target) {
        if (!EntityUtil.isEntityValid((Entity)target) || BungeeZombieEntity.isHoldingZombieDoll(target)) {
            return false;
        }
        if (target.func_184187_bx() instanceof BungeeZombieEntity) {
            return target.func_184187_bx().func_70028_i((Entity)this);
        }
        return true;
    }

    private static boolean isHoldingZombieDoll(LivingEntity target) {
        return target.func_184614_ca().func_77973_b().equals(ItemRegister.ZOMBIE_DOLL.get()) || target.func_184592_cb().func_77973_b().equals(ItemRegister.ZOMBIE_DOLL.get());
    }

    @Override
    public float getLife() {
        return 45.0f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)1.2f, (float)2.0f);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.BUNGEE_ZOMBIE;
    }

    public boolean func_205710_ba() {
        return true;
    }

    public boolean func_189652_ae() {
        return true;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("bungee_state")) {
            this.setBungeeState(BungeeStates.values()[compound.func_74762_e("bungee_state")]);
        }
        if (compound.func_74764_b("bungee_type")) {
            this.setBungeeType(BungeeTypes.values()[compound.func_74762_e("bungee_type")]);
        }
        if (compound.func_74764_b("steal_target")) {
            this.stealTarget = (LivingEntity)this.field_70170_p.func_73045_a(compound.func_74762_e("steal_target"));
        }
        if (compound.func_74764_b("origin_pos")) {
            CompoundNBT nbt = compound.func_74775_l("origin_pos");
            this.setOriginPos(new BlockPos(nbt.func_74762_e("origin_pos_x"), nbt.func_74762_e("origin_pos_y"), nbt.func_74762_e("origin_pos_z")));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("bungee_state", this.getBungeeState().ordinal());
        compound.func_74768_a("bungee_type", this.getBungeeType().ordinal());
        if (this.stealTarget != null) {
            compound.func_74768_a("steal_target", this.stealTarget.func_145782_y());
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("origin_pos_x", this.getOriginPos().func_177958_n());
        nbt.func_74768_a("origin_pos_y", this.getOriginPos().func_177956_o());
        nbt.func_74768_a("origin_pos_z", this.getOriginPos().func_177952_p());
        compound.func_218657_a("origin_pos", (INBT)nbt);
    }

    public void setBungeeState(BungeeStates state) {
        this.field_70180_af.func_187227_b(BUNGEE_STATE, (Object)state.ordinal());
    }

    public void setBungeeType(BungeeTypes type) {
        this.field_70180_af.func_187227_b(BUNGEE_TYPE, (Object)type.ordinal());
    }

    public BungeeStates getBungeeState() {
        return BungeeStates.values()[(Integer)this.field_70180_af.func_187225_a(BUNGEE_STATE)];
    }

    public BungeeTypes getBungeeType() {
        return BungeeTypes.values()[(Integer)this.field_70180_af.func_187225_a(BUNGEE_TYPE)];
    }

    public BlockPos getOriginPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN_POS);
    }

    public void setOriginPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN_POS, (Object)pos);
    }

    public LivingEntity getStealTarget() {
        return this.stealTarget;
    }

    public void setStealTarget(LivingEntity target) {
        this.stealTarget = target;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.BUNGEE_ZOMBIE;
    }

    static class BungeeRandomTargetGoal
    extends PVZRandomTargetGoal {
        private final BungeeZombieEntity zombie;

        public BungeeRandomTargetGoal(BungeeZombieEntity mobIn, boolean checkSight, boolean mustReach, float w, float h) {
            super((MobEntity)mobIn, checkSight, mustReach, w, h);
            this.zombie = mobIn;
        }

        @Override
        public boolean func_75253_b() {
            return this.zombie.isSuitableTarget(this.zombie.func_70638_az());
        }
    }

    public static enum BungeeTypes {
        STEAL,
        HELP,
        SUMMON;

    }

    public static enum BungeeStates {
        WAIT,
        BACK_WAIT,
        DOWN,
        CATCH,
        UP,
        PUSH_BACK;

    }
}

