/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.roof;

import com.hungteen.pvz.api.interfaces.IHasWheel;
import com.hungteen.pvz.common.entity.ai.goal.attack.PultAttackGoal;
import com.hungteen.pvz.common.entity.ai.goal.target.PVZRandomTargetGoal;
import com.hungteen.pvz.common.entity.bullet.BallEntity;
import com.hungteen.pvz.common.entity.zombie.base.CarZombieEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IPult;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class CatapultZombieEntity
extends CarZombieEntity
implements IPult,
IHasWheel {
    private static final DataParameter<Integer> BALL_COUNT = EntityDataManager.func_187226_a(CatapultZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final float PULT_DISTANCE = 2000.0f;

    public CatapultZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.19f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BALL_COUNT, (Object)0);
    }

    @Override
    protected void registerAttackGoals() {
        super.registerAttackGoals();
        this.field_70714_bg.func_75776_a(2, (Goal)new CataPultAttackGoal(this));
    }

    @Override
    protected void registerTargetGoals() {
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZRandomTargetGoal((MobEntity)this, true, true, 60.0f, 30.0f));
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K && this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
            if (this.getAttackTime() == this.getPultAnimTime() / 2) {
                this.pultBullet();
            }
        }
    }

    @Override
    public void spikeWheelBy(LivingEntity entity) {
        this.func_70097_a(PVZDamageSource.func_92087_a((Entity)entity), EntityUtil.getMaxHealthDamage((LivingEntity)this, 2.0f));
    }

    @Override
    public void startPultAttack() {
        this.setAttackTime(this.getPultAnimTime());
    }

    @Override
    public int getPultCD() {
        return 60;
    }

    public int getPultAnimTime() {
        return 20;
    }

    @Override
    public float getPultRange() {
        return 40.0f;
    }

    @Override
    public boolean shouldPult() {
        return this.canZombieNormalUpdate() && this.getBallCount() < this.getMaxBallUse();
    }

    public boolean checkY(LivingEntity target) {
        return this.func_226278_cu_() + 12.0 >= target.func_226278_cu_() + (double)target.func_213302_cg();
    }

    @Override
    public void pultBullet() {
        Optional.ofNullable(this.func_70638_az()).ifPresent(target -> {
            BallEntity ball = (BallEntity)((EntityType)EntityRegister.BALL.get()).func_200721_a(this.field_70170_p);
            ball.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.7f, this.func_226281_cx_());
            ball.shootPultBullet((LivingEntity)target);
            ball.summonByOwner((Entity)this);
            ball.setAttackDamage(this.getAttackDamage());
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.BASKETBALL.get());
            this.field_70170_p.func_217376_c((Entity)ball);
            this.setBallCount(this.getBallCount() + 1);
        });
    }

    public int getMaxBallUse() {
        return 20;
    }

    public float getAttackDamage() {
        return (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b();
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)0.8f, (float)2.0f);
    }

    @Override
    public float getLife() {
        return 105.0f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ball_count")) {
            this.setBallCount(compound.func_74762_e("ball_count"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ball_count", this.getBallCount());
    }

    public void setBallCount(int cnt) {
        this.field_70180_af.func_187227_b(BALL_COUNT, (Object)cnt);
    }

    public int getBallCount() {
        return (Integer)this.field_70180_af.func_187225_a(BALL_COUNT);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.CATAPULT_ZOMBIE;
    }

    private static final class CataPultAttackGoal
    extends PultAttackGoal {
        private final CatapultZombieEntity zombie;

        public CataPultAttackGoal(CatapultZombieEntity zombie) {
            super(zombie);
            this.zombie = zombie;
        }

        @Override
        public void func_75251_c() {
            this.target = null;
        }

        @Override
        protected boolean checkTarget(LivingEntity target) {
            return super.checkTarget(target) && this.attacker.func_70068_e((Entity)target) <= 2000.0 && this.zombie.checkY(target);
        }
    }
}

