/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.roof;

import com.hungteen.pvz.common.entity.ai.goal.attack.PVZZombieAttackGoal;
import com.hungteen.pvz.common.entity.plant.spear.SpikeRockEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.entity.zombie.roof.ImpEntity;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GargantuarEntity
extends PVZZombieEntity {
    private static final DataParameter<Boolean> HAS_IMP = EntityDataManager.func_187226_a(GargantuarEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TOOL_TYPE = EntityDataManager.func_187226_a(GargantuarEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int DEATH_ANIM_CD = 100;
    public boolean isSad = false;

    public GargantuarEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.maxDeathTime = 40;
        this.setIsWholeBody();
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            this.setToolType(GargantuarType.values()[this.func_70681_au().nextInt(GargantuarType.values().length)]);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_IMP, (Object)true);
        this.field_70180_af.func_187214_a(TOOL_TYPE, (Object)GargantuarType.DOLL.ordinal());
    }

    @Override
    protected void registerAttackGoals() {
        this.field_70714_bg.func_75776_a(3, (Goal)new GargantuarMoveToTargetGoal(this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new CrushAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowImpGoal(this));
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.18f);
    }

    public void throwImp(LivingEntity target) {
        EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.THROW_IMP.get());
        ImpEntity imp = (ImpEntity)((EntityType)EntityRegister.IMP.get()).func_200721_a(this.field_70170_p);
        imp.throwByGargantuar(this, target);
        EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)imp, this.func_233580_cy_().func_177963_a(0.0, (double)this.func_213302_cg(), 0.0));
        this.setHasImp(false);
    }

    @Override
    protected void setBodyStates(ZombieDropBodyEntity body) {
        super.setBodyStates(body);
        body.setMaxLiveTick(100);
        body.setHandDefence(this.isSad);
    }

    @Override
    public boolean canZombieTarget(Entity target) {
        if (target instanceof SpikeRockEntity) {
            return true;
        }
        return super.canZombieTarget(target);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.GROUND_SHAKE.get());
        }
        if (!EntityUtil.isEntityValid(entityIn)) {
            return false;
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    protected PVZDamageSource getZombieAttackDamageSource() {
        return PVZDamageSource.causeCrushDamage((Entity)this);
    }

    @Override
    protected float getModifyAttackDamage(Entity entity, float f) {
        if (entity instanceof LivingEntity) {
            return EntityUtil.getMaxHealthDamage((LivingEntity)entity, 2.0f);
        }
        return f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.6f, (float)1.8f);
        }
        return EntitySize.func_220314_b((float)0.8f, (float)4.0f);
    }

    public boolean canThrowImp() {
        return this.canZombieNormalUpdate() && this.func_110143_aJ() / this.func_110138_aP() < 0.5f;
    }

    @Override
    public boolean canBreakPlantBlock() {
        return false;
    }

    public int getCrushCD() {
        return 40;
    }

    public int getThrowCD() {
        return 30;
    }

    @Override
    public float getLife() {
        return 300.0f;
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundRegister.GARGANTUAR_DEATH.get();
    }

    @Override
    protected SoundEvent func_184639_G() {
        return (SoundEvent)SoundRegister.GARGANTUAR_SAY.get();
    }

    public int func_70627_aG() {
        return 200;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.GARGANTUAR;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("has_imp")) {
            this.setHasImp(compound.func_74767_n("has_imp"));
        }
        if (compound.func_74764_b("weapon_type")) {
            this.setToolType(GargantuarType.values()[compound.func_74762_e("weapon_type")]);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("has_imp", this.hasImp());
        compound.func_74768_a("weapon_type", this.getToolType().ordinal());
    }

    public void setHasImp(boolean has) {
        this.field_70180_af.func_187227_b(HAS_IMP, (Object)has);
    }

    public boolean hasImp() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_IMP);
    }

    public void setToolType(GargantuarType type) {
        this.field_70180_af.func_187227_b(TOOL_TYPE, (Object)type.ordinal());
    }

    public GargantuarType getToolType() {
        return GargantuarType.values()[(Integer)this.field_70180_af.func_187225_a(TOOL_TYPE)];
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.GARGANTUAR;
    }

    private final class ThrowImpGoal
    extends Goal {
        protected final GargantuarEntity attacker;

        public ThrowImpGoal(GargantuarEntity creature) {
            this.attacker = creature;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.attacker.hasImp() && this.attacker.canThrowImp();
        }

        public void func_75249_e() {
            this.attacker.setAttackTime(-this.attacker.getThrowCD());
        }

        public boolean func_75253_b() {
            return this.attacker.getAttackTime() < 0;
        }

        public void func_75251_c() {
            this.attacker.setAttackTime(0);
        }

        public void func_75246_d() {
            if (this.attacker.canZombieNormalUpdate() && this.attacker.getAttackTime() < 0) {
                this.attacker.setAttackTime(this.attacker.getAttackTime() + 1);
                if (this.attacker.hasImp() && -this.attacker.getAttackTime() == this.attacker.getThrowCD() * 1 / 4) {
                    this.attacker.throwImp(this.attacker.func_70638_az());
                }
            }
        }
    }

    private final class CrushAttackGoal
    extends Goal {
        protected final GargantuarEntity attacker;

        public CrushAttackGoal(GargantuarEntity creature) {
            this.attacker = creature;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.attacker.getAttackTime() > 0;
        }

        public boolean func_75253_b() {
            return this.attacker.getAttackTime() > 0;
        }

        public void func_75246_d() {
            if (this.attacker.canZombieNormalUpdate() && this.attacker.getAttackTime() > 0) {
                this.attacker.setAttackTime(this.attacker.getAttackTime() - 1);
                if (this.attacker.getAttackTime() == this.attacker.getCrushCD() * 1 / 3) {
                    this.attacker.func_70652_k((Entity)this.attacker.func_70638_az());
                }
            }
        }
    }

    private final class GargantuarMoveToTargetGoal
    extends PVZZombieAttackGoal {
        public GargantuarMoveToTargetGoal(GargantuarEntity creature, boolean useLongMemory) {
            super(creature, useLongMemory);
        }

        @Override
        public boolean func_75250_a() {
            return this.zombie.getAttackTime() == 0 && super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            return this.zombie.getAttackTime() == 0 && super.func_75253_b();
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity target) {
            double dis = EntityUtil.getNearestDistance((Entity)this.attacker, (Entity)target);
            double range = this.getAttackReachSqr(target);
            if (range >= dis && this.attackTick <= 0) {
                this.attackTick = this.zombie.getAttackCD();
                this.attacker.func_184609_a(Hand.MAIN_HAND);
                this.zombie.setAttackTime(GargantuarEntity.this.getCrushCD());
            }
        }
    }

    public static enum GargantuarType {
        POLE,
        SIGN,
        DOLL;

    }
}

