/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.roof;

import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.roof.GargantuarEntity;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.ICanAttract;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ImpEntity
extends PVZZombieEntity {
    protected boolean isFalling = false;
    protected int protectTick = 0;

    public ImpEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.field_70170_p.field_72995_K) {
            int now = this.func_70681_au().nextInt(10);
            if (now == 0) {
                this.func_195064_c(new EffectInstance(Effects.field_76424_c, 600, 1));
            } else if (now == 1) {
                this.func_195064_c(new EffectInstance(Effects.field_76420_g, 600, 1));
            } else if (now == 2) {
                this.func_195064_c(new EffectInstance(Effects.field_76430_j, 600, 1));
            } else if (now == 3) {
                this.func_195064_c(new EffectInstance(Effects.field_180152_w, 600, 1));
            } else if (now == 3) {
                this.func_195064_c(new EffectInstance(Effects.field_76444_x, 600, 1));
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70122_E && this.isFalling) {
                this.isFalling = false;
            }
            if (this.protectTick > 0) {
                --this.protectTick;
            }
        }
    }

    @Override
    public boolean canZombieNormalUpdate() {
        return super.canZombieNormalUpdate() && !this.isFalling;
    }

    @Override
    protected boolean isZombieInvulnerableTo(DamageSource source) {
        return super.isZombieInvulnerableTo(source) || this.protectTick > 0;
    }

    public void throwByGargantuar(GargantuarEntity entity, LivingEntity target) {
        Vector3d vec = new Vector3d((double)entity.func_70681_au().nextFloat() - 0.5, (double)(entity.func_70681_au().nextFloat() / 4.0f), (double)entity.func_70681_au().nextFloat() - 0.5).func_72432_b();
        if (target != null) {
            double speed = 2.0;
            vec = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_186678_a(speed);
        } else {
            double speed = 0.5;
            vec = vec.func_186678_a(speed);
        }
        this.func_213317_d(vec);
        ZombieUtil.copySummonZombieData(entity, this);
        this.isFalling = true;
        this.protectTick = 60;
    }

    @Override
    public boolean canBeAttractedBy(ICanAttract defender) {
        return !this.isFalling && super.canBeAttractedBy(defender);
    }

    @Override
    public float getLife() {
        return 10.0f;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        if (this.isMiniZombie()) {
            return EntitySize.func_220314_b((float)0.2f, (float)0.45f);
        }
        return EntitySize.func_220314_b((float)0.6f, (float)1.2f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("protect_tick")) {
            this.protectTick = compound.func_74762_e("protect_tick");
        }
        if (compound.func_74764_b("fall_from_throw")) {
            this.isFalling = compound.func_74767_n("fall_from_throw");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("protect_tick", this.protectTick);
        compound.func_74757_a("fall_from_throw", this.isFalling);
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.IMP;
    }
}

