/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.roof;

import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantDefenderEntity;
import com.hungteen.pvz.common.entity.zombie.base.DefenceZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.entity.zombie.part.PVZHealthPartEntity;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.enums.MetalTypes;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IHasMetal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class LadderZombieEntity
extends DefenceZombieEntity
implements IHasMetal {
    public LadderZombieEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
    }

    @Override
    public void resetParts() {
        this.removeParts();
        this.part = new PVZHealthPartEntity(this, 1.0f, 1.7f);
        this.part.setOwner((LivingEntity)this);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.hasMetal() && LadderZombieEntity.canTargetPutLadder(entityIn)) {
            this.putLadderOn(entityIn);
        }
        return super.func_70652_k(entityIn);
    }

    public void putLadderOn(Entity entity) {
        if (entity instanceof IPVZPlant) {
            ((IPVZPlant)entity).increaseMetal();
        }
        this.decreaseMetal();
    }

    public static boolean canTargetPutLadder(Entity target) {
        if (!(target instanceof IPVZPlant) || LadderZombieEntity.hasLadderOnEntity(target)) {
            return false;
        }
        if (target instanceof PlantDefenderEntity) {
            return true;
        }
        PVZPlantEntity plant = (PVZPlantEntity)target;
        return plant.getOuterPlantType().isPresent() && plant.getOuterPlantType().get() == Plants.PUMPKIN;
    }

    private static boolean hasLadderOnEntity(Entity target) {
        if (!(target instanceof IPVZPlant)) {
            return false;
        }
        return ((IPVZPlant)target).hasMetal();
    }

    @Override
    public boolean hasMetal() {
        return this.getDefenceLife() > 0.0f;
    }

    @Override
    public boolean canLostHand() {
        return super.canLostHand() && !this.hasMetal();
    }

    @Override
    protected void setBodyStates(ZombieDropBodyEntity body) {
        super.setBodyStates(body);
        body.setHandDefence(this.hasMetal());
    }

    @Override
    public void decreaseMetal() {
        this.setDefenceLife(0.0f);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.2f);
    }

    @Override
    public void increaseMetal() {
        this.setDefenceLife(this.getPartLife());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
        this.resetParts();
    }

    @Override
    public MetalTypes getMetalType() {
        return MetalTypes.LADDER;
    }

    @Override
    public SoundEvent getPartHurtSound() {
        return (SoundEvent)SoundRegister.METAL_HIT.get();
    }

    @Override
    public float getLife() {
        return 65.0f;
    }

    @Override
    public float getPartLife() {
        return 250.0f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.LADDER_ZOMBIE;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.LADDER_ZOMBIE;
    }
}

