/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.entity.zombie.roof;

import com.hungteen.pvz.common.entity.ai.goal.target.PVZNearestTargetGoal;
import com.hungteen.pvz.common.entity.drop.JewelEntity;
import com.hungteen.pvz.common.entity.misc.DestroyCarEntity;
import com.hungteen.pvz.common.entity.misc.ElementBallEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.base.AbstractBossZombieEntity;
import com.hungteen.pvz.common.entity.zombie.body.ZombieDropBodyEntity;
import com.hungteen.pvz.common.entity.zombie.roof.BungeeZombieEntity;
import com.hungteen.pvz.common.world.data.PVZFlagData;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ZomBossEntity
extends AbstractBossZombieEntity {
    private static final DataParameter<Integer> STATES = EntityDataManager.func_187226_a(ZomBossEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> ORIGIN_POS = EntityDataManager.func_187226_a(ZomBossEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final List<Zombies> ZOMBIES_1 = Arrays.asList(Zombies.NORMAL_ZOMBIE, Zombies.NEWSPAPER_ZOMBIE, Zombies.SCREENDOOR_ZOMBIE, Zombies.SNORKEL_ZOMBIE, Zombies.BALLOON_ZOMBIE);
    private static final List<Zombies> ZOMBIES_2 = Arrays.asList(Zombies.CONEHEAD_ZOMBIE, Zombies.POLE_ZOMBIE, Zombies.DANCING_ZOMBIE, Zombies.OLD_ZOMBIE, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.BALLOON_ZOMBIE, Zombies.POGO_ZOMBIE);
    private static final List<Zombies> ZOMBIES_3 = Arrays.asList(Zombies.BUCKETHEAD_ZOMBIE, Zombies.FOOTBALL_ZOMBIE, Zombies.ZOMBONI, Zombies.JACK_IN_BOX_ZOMBIE, Zombies.DIGGER_ZOMBIE, Zombies.LADDER_ZOMBIE, Zombies.CATAPULT_ZOMBIE);
    private static final List<Zombies> ZOMBIES_4 = Arrays.asList(Zombies.FOOTBALL_ZOMBIE, Zombies.GIGA_FOOTBALL_ZOMBIE, Zombies.ZOMBONI, Zombies.LAVA_ZOMBIE, Zombies.CATAPULT_ZOMBIE, Zombies.GARGANTUAR);
    private static final List<Zombies> ZOMBIES_5 = Arrays.asList(Zombies.GIGA_FOOTBALL_ZOMBIE, Zombies.SUNDAY_EDITION_ZOMBIE, Zombies.LAVA_ZOMBIE, Zombies.CATAPULT_ZOMBIE, Zombies.GARGANTUAR, Zombies.SAD_GARGANTUAR);
    private int summonZombieTick = 0;
    public int shootBallCD = 100;
    public int stealPlantCD = 100;

    public ZomBossEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.maxDeathTime = 60;
        this.refreshCountCD = 10;
        this.hasDirectDefence = true;
        this.maxZombieSurround = 60;
        this.maxPlantSurround = 60;
        this.kickRange = 6.0f;
        this.setIsWholeBody();
        this.resetShootBallCD();
        this.resetStealCD();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATES, (Object)ZomBossStates.NORMAL.ordinal());
        this.field_70180_af.func_187214_a(ORIGIN_POS, (Object)BlockPos.field_177992_a);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 40.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new PVZNearestTargetGoal((MobEntity)this, false, true, 70.0f, 50.0f));
    }

    @Override
    protected void updateAttributes() {
        super.updateAttributes();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(20.0);
    }

    @Override
    public void zombieTick() {
        super.zombieTick();
        if (this.shootBallCD > 0) {
            --this.shootBallCD;
            --this.stealPlantCD;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOriginPos() == BlockPos.field_177992_a) {
                this.setOriginPos(this.func_233580_cy_());
            } else if (MathUtil.getPosDisToVec(this.getOriginPos(), this.func_213303_ch()) >= 10.0) {
                int range = 4;
                for (int i = -4; i <= 4; ++i) {
                    for (int j = -4; j <= 4; ++j) {
                        BlockPos tmp = this.getOriginPos().func_177982_a(i, -1, j);
                        if (this.field_70170_p.func_180495_p(tmp).func_196958_f()) {
                            this.field_70170_p.func_175656_a(tmp, Blocks.field_196658_i.func_176223_P());
                        }
                        for (int k = 0; k <= 10; ++k) {
                            this.field_70170_p.func_175656_a(this.getOriginPos().func_177982_a(i, k, j), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                this.func_70107_b(this.getOriginPos().func_177958_n(), this.getOriginPos().func_177956_o() + 1, this.getOriginPos().func_177952_p());
            }
        }
    }

    @Override
    public void normalZombieTick() {
        super.normalZombieTick();
        if (!this.field_70170_p.field_72995_K) {
            ++this.summonZombieTick;
            if (this.summonZombieTick >= this.getSummonZombieCD()) {
                this.summonZombieTick = 0;
                this.summonZombieByBungee();
            }
            if (this.getZomBossState() == ZomBossStates.NORMAL) {
                int flag = this.func_70681_au().nextInt(10);
                if (this.field_70173_aa % 100 == 0 && this.nearbyPlantCount >= this.maxPlantSurround && this.field_70146_Z.nextInt(2) == 0) {
                    this.setZomBossState(ZomBossStates.CAR);
                } else if (flag < 4 && this.stealPlantCD <= 0) {
                    this.setZomBossState(ZomBossStates.STEAL);
                    EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.DRAG.get());
                    this.resetStealCD();
                } else if (this.shootBallCD <= 0) {
                    this.setZomBossState(this.func_70681_au().nextInt(2) == 0 ? ZomBossStates.FLAME : ZomBossStates.ICE);
                    EntityUtil.playSound((Entity)this, (SoundEvent)SoundRegister.ZOMBOSS_SHOOT.get());
                    this.resetShootBallCD();
                }
            } else if (this.getZomBossState() == ZomBossStates.FLAME || this.getZomBossState() == ZomBossStates.ICE) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAnimShootCD()) {
                    this.shootElementBall();
                }
            } else if (this.getZomBossState() == ZomBossStates.CAR) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAnimThrowCD()) {
                    this.throwDestroyCar();
                }
            } else if (this.getZomBossState() == ZomBossStates.STEAL) {
                this.setAttackTime(this.getAttackTime() + 1);
                if (this.getAttackTime() >= this.getAnimThrowCD()) {
                    this.stealRandomTargets();
                }
            }
        }
    }

    public void summonZombieByBungee() {
        if (this.nearbyZombieCount >= this.maxZombieSurround) {
            return;
        }
        for (int i = 0; i < this.bossInfo.func_186757_c().size() / 2 + this.func_70681_au().nextInt(2) + 1; ++i) {
            this.getSummonZombie().ifPresent(zombie -> {
                this.onBossSummon((PVZZombieEntity)zombie, this.func_233580_cy_().func_177981_b(10));
                BungeeZombieEntity bungee = (BungeeZombieEntity)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
                bungee.setBungeeType(BungeeZombieEntity.BungeeTypes.SUMMON);
                bungee.setBungeeState(BungeeZombieEntity.BungeeStates.DOWN);
                bungee.setStealTarget((LivingEntity)zombie);
                BlockPos pos = this.func_70681_au().nextInt(5) == 0 ? WorldUtil.getSuitableHeightRandomPos(this.field_70170_p, this.func_233580_cy_(), 20, 40) : WorldUtil.getSuitableHeightRandomPos(this.field_70170_p, this.func_233580_cy_(), 3, 8);
                this.onBossSummon(bungee, pos.func_177981_b(20));
                EntityUtil.playSound((Entity)bungee, (SoundEvent)SoundRegister.BUNGEE_SCREAM.get());
            });
        }
    }

    public void shootElementBall() {
        int now = this.getBossStage();
        float speed = now < 2 ? 0.16f : (now < 4 ? 0.2f : 0.25f);
        ElementBallEntity ball = (ElementBallEntity)((EntityType)EntityRegister.ELEMENT_BALL.get()).func_200721_a(this.field_70170_p);
        ball.summonByOwner((Entity)this);
        ball.speed = speed;
        ball.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
        ball.setElementBallType(this.getZomBossState() == ZomBossStates.ICE ? ElementBallEntity.ElementTypes.ICE : ElementBallEntity.ElementTypes.FLAME);
        this.field_70170_p.func_217376_c((Entity)ball);
        this.setAttackTime(0);
        this.setZomBossState(ZomBossStates.NORMAL);
    }

    public void throwDestroyCar() {
        this.setZomBossState(ZomBossStates.NORMAL);
        int max = Math.max(1, (this.nearbyPlantCount - this.maxPlantSurround) / 5);
        int throwNum = MathUtil.getRandomMinMax(this.func_70681_au(), max / 2 + 1, max + 1);
        float range = 50.0f;
        List<LivingEntity> list = EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0));
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < throwNum; ++i) {
            int pos = this.func_70681_au().nextInt(list.size());
            DestroyCarEntity car = new DestroyCarEntity(this.field_70170_p, this);
            car.summonByOwner((Entity)this);
            car.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
            car.shootPultBullet(list.get(pos));
            this.field_70170_p.func_217376_c((Entity)car);
        }
    }

    @Override
    public void checkAndHeal(float percent) {
        if (this.func_70638_az() == null) {
            this.func_70691_i(10.0f);
        }
    }

    public void stealRandomTargets() {
        this.setZomBossState(ZomBossStates.NORMAL);
        if (this.nearbyPlantCount <= 5) {
            return;
        }
        int now = this.getBossStage();
        int minCnt = 3 + now / 2;
        int maxCnt = 3 + now;
        int cnt = MathUtil.getRandomMinMax(this.func_70681_au(), minCnt, maxCnt);
        float range = 50.0f;
        List<LivingEntity> list = EntityUtil.getTargetableLivings((Entity)this, EntityUtil.getEntityAABB((Entity)this, 50.0, 50.0));
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < cnt; ++i) {
            LivingEntity target = list.get(this.func_70681_au().nextInt(list.size()));
            BungeeZombieEntity zombie = (BungeeZombieEntity)((EntityType)EntityRegister.BUNGEE_ZOMBIE.get()).func_200721_a(this.field_70170_p);
            zombie.setBungeeType(BungeeZombieEntity.BungeeTypes.STEAL);
            zombie.setStealTarget(target);
            zombie.setBungeeState(BungeeZombieEntity.BungeeStates.DOWN);
            ZombieUtil.copySummonZombieData(this, zombie);
            EntityUtil.onEntitySpawn((IWorld)this.field_70170_p, (Entity)zombie, this.func_233580_cy_().func_177981_b(18));
        }
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ % 20 == 1 && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_() + 5.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.bossInfo.func_186757_c().forEach(player -> CriteriaTriggers.field_192122_b.func_192211_a(player, (Entity)this, cause));
            PVZFlagData data = PVZFlagData.getGlobalFlagData(this.field_70170_p);
            data.addAdgarDefeatedCount();
        }
    }

    @Override
    protected void onFallBody(DamageSource source) {
        Arrays.asList(ZombieDropBodyEntity.BodyType.HEAD, ZombieDropBodyEntity.BodyType.BODY, ZombieDropBodyEntity.BodyType.LEFT_HAND, ZombieDropBodyEntity.BodyType.RIGHT_HAND, ZombieDropBodyEntity.BodyType.LEFT_LEG, ZombieDropBodyEntity.BodyType.RIGHT_LEG).forEach(type -> {
            ZombieDropBodyEntity body = (ZombieDropBodyEntity)((EntityType)EntityRegister.ZOMBIE_DROP_BODY.get()).func_200721_a(this.field_70170_p);
            body.updateInfo(this, (ZombieDropBodyEntity.BodyType)((Object)type));
            body.setMaxLiveTick(60);
            this.setBodyStates(body);
            float dx = MathUtil.getRandomFloat(this.func_70681_au());
            float dy = this.func_70681_au().nextFloat();
            float dz = MathUtil.getRandomFloat(this.func_70681_au());
            body.func_213293_j(dx, dy, dz);
            body.func_70107_b(this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + (double)(this.func_213302_cg() / 2.0f), this.func_213303_ch().field_72449_c);
            this.field_70170_p.func_217376_c((Entity)body);
        });
    }

    @Override
    protected void spawnSpecialDrops() {
        float range = 50.0f;
        int playerCnt = this.field_70170_p.func_175647_a(PlayerEntity.class, EntityUtil.getEntityAABB((Entity)this, range, range), player -> PlayerUtil.isPlayerSurvival(player)).size();
        for (int i = 0; i < 3 + 2 * playerCnt; ++i) {
            JewelEntity jewel = (JewelEntity)((EntityType)EntityRegister.JEWEL.get()).func_200721_a(this.field_70170_p);
            EntityUtil.onMobEntityRandomPosSpawn((IWorld)this.field_70170_p, jewel, this.func_233580_cy_().func_177981_b(5), 4);
        }
    }

    private Optional<PVZZombieEntity> getSummonZombie() {
        int stage = this.getBossStage();
        List<Object> summon_zombie_list = new ArrayList();
        if (stage == 1) {
            summon_zombie_list = ZOMBIES_1;
        } else if (stage == 2) {
            summon_zombie_list = ZOMBIES_2;
        } else if (stage == 3) {
            summon_zombie_list = ZOMBIES_3;
        } else if (stage == 4) {
            summon_zombie_list = ZOMBIES_4;
        } else if (stage == 5) {
            summon_zombie_list = ZOMBIES_5;
        }
        if (summon_zombie_list.isEmpty()) {
            System.out.println("Error : Wrong Boss Stage !");
            return Optional.empty();
        }
        int pos = this.func_70681_au().nextInt(summon_zombie_list.size());
        return Optional.of(ZombieUtil.getZombieEntity(this.field_70170_p, (Zombies)((Object)summon_zombie_list.get(pos))));
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)2.0f, (float)9.0f);
    }

    private void resetShootBallCD() {
        int minCD = 600;
        int maxCD = 1000;
        if (this.getBossStage() > 4) {
            minCD -= 300;
            maxCD -= 400;
        } else if (this.getBossStage() > 2) {
            minCD -= 200;
            maxCD -= 200;
        }
        this.shootBallCD = this.func_70681_au().nextInt(maxCD - minCD + 1) + minCD;
    }

    private void resetStealCD() {
        int now = this.getBossStage();
        int maxCD = now <= 3 ? 800 : 600;
        int minCD = now <= 3 ? 500 : 400;
        this.stealPlantCD = this.func_70681_au().nextInt(maxCD - minCD + 1) + minCD;
    }

    public int getBossStage() {
        float percent = this.bossInfo.func_186738_f();
        return percent > 0.8f ? 1 : (percent > 0.6f ? 2 : (percent > 0.4f ? 3 : (percent > 0.2f ? 4 : 5)));
    }

    @Override
    public float getLife() {
        return 1000.0f;
    }

    @Override
    public float getExtraLife() {
        return 10000.0f;
    }

    protected int getSummonZombieCD() {
        return 100;
    }

    public int getAnimShootCD() {
        return 40;
    }

    public int getAnimThrowCD() {
        return 30;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("zomboss_state")) {
            this.setZomBossState(ZomBossStates.values()[compound.func_74762_e("zomboss_state")]);
        }
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        if (compound.func_74764_b("zomboss_summon_tick")) {
            this.summonZombieTick = compound.func_74762_e("zomboss_summon_tick");
        }
        if (compound.func_74764_b("zomboss_shoot_ball_cd")) {
            this.shootBallCD = compound.func_74762_e("zomboss_shoot_ball_cd");
        }
        if (compound.func_74764_b("zomboss_steal_cd")) {
            this.stealPlantCD = compound.func_74762_e("zomboss_steal_cd");
        }
        if (compound.func_74764_b("origin_pos")) {
            CompoundNBT nbt = compound.func_74775_l("origin_pos");
            this.setOriginPos(new BlockPos(nbt.func_74762_e("origin_pos_x"), nbt.func_74762_e("origin_pos_y"), nbt.func_74762_e("origin_pos_z")));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("zomboss_state", this.getZomBossState().ordinal());
        compound.func_74768_a("zomboss_summon_tick", this.summonZombieTick);
        compound.func_74768_a("zomboss_shoot_ball_cd", this.shootBallCD);
        compound.func_74768_a("zomboss_steal_cd", this.stealPlantCD);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("origin_pos_x", this.getOriginPos().func_177958_n());
        nbt.func_74768_a("origin_pos_y", this.getOriginPos().func_177956_o());
        nbt.func_74768_a("origin_pos_z", this.getOriginPos().func_177952_p());
        compound.func_218657_a("origin_pos", (INBT)nbt);
    }

    public void setZomBossState(ZomBossStates state) {
        this.field_70180_af.func_187227_b(STATES, (Object)state.ordinal());
    }

    public ZomBossStates getZomBossState() {
        return ZomBossStates.values()[(Integer)this.field_70180_af.func_187225_a(STATES)];
    }

    public BlockPos getOriginPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN_POS);
    }

    public void setOriginPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN_POS, (Object)pos);
    }

    @Override
    protected Optional<SoundEvent> getSpawnSound() {
        return Optional.ofNullable(SoundRegister.ZOMBOSS_LAUGH.get());
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundRegister.ZOMBOSS_DEATH.get();
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return PVZLoot.ZOMBOSS;
    }

    @Override
    public Zombies getZombieEnumName() {
        return Zombies.ZOMBOSS;
    }

    public static enum ZomBossStates {
        NORMAL,
        FLAME,
        ICE,
        STEAL,
        CAR;

    }
}

