/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.event.handler;

import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.api.interfaces.IPVZZombie;
import com.hungteen.pvz.common.misc.damage.PVZDamageSource;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LivingEventHandler {
    public static void handleHurtEffects(LivingEntity target, PVZDamageSource source) {
        if (!source.isDefended()) {
            if (source.isFlameDamage()) {
                if (target.func_70644_a((Effect)EffectRegister.COLD_EFFECT.get())) {
                    target.func_195063_d((Effect)EffectRegister.COLD_EFFECT.get());
                }
                if (target.func_70644_a((Effect)EffectRegister.FROZEN_EFFECT.get())) {
                    target.func_195063_d((Effect)EffectRegister.FROZEN_EFFECT.get());
                }
            }
            source.getEffects().forEach(effect -> EntityUtil.addPotionEffect((Entity)target, effect));
        }
    }

    public static void handleHurtSounds(LivingEntity target, PVZDamageSource source) {
        if (source.isEatDamage()) {
            EntityUtil.playSound((Entity)target, (SoundEvent)SoundRegister.EAT.get());
        }
        if (source.isFlameDamage() && source.isAppease()) {
            EntityUtil.playSound((Entity)target, (SoundEvent)SoundRegister.FLAME_HIT.get());
        }
    }

    public static void handleHurtDamage(LivingHurtEvent ev) {
        if (ev.getSource() == null || !(ev.getSource().func_76346_g() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)ev.getSource().func_76346_g();
        if (attacker instanceof IPVZZombie && ev.getEntityLiving() instanceof IPVZZombie) {
            if (!EntityUtil.isEntityBoss(attacker)) {
                ev.setAmount(Math.min(100.0f, ev.getAmount()));
            }
            return;
        }
        if (attacker instanceof IPVZPlant && !(ev.getEntityLiving() instanceof IPVZZombie)) {
            if (ev.getEntityLiving() instanceof EnderDragonEntity) {
                ev.setAmount(Math.min(400.0f, ev.getAmount()));
            } else {
                ev.setAmount(Math.min(100.0f, ev.getAmount()));
            }
            return;
        }
        if (attacker instanceof IPVZZombie && !(ev.getEntityLiving() instanceof IPVZPlant)) {
            ev.setAmount(Math.min(100.0f, ev.getAmount()));
        }
    }
}

