/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.event.handler;

import com.hungteen.pvz.client.gui.search.SearchOption;
import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.capability.player.PlayerDataManager;
import com.hungteen.pvz.common.enchantment.EnchantmentUtil;
import com.hungteen.pvz.common.entity.drop.SunEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.world.invasion.WaveManager;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import com.hungteen.pvz.utils.enums.Zombies;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;

public class PlayerEventHandler {
    public static void onPlantShovelByPlayer(PlayerEntity player, PVZPlantEntity plant, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d || player.func_110124_au().equals(plant.getOwnerUUID().get()) || !EntityUtil.checkCanEntityBeAttack((Entity)plant, (Entity)player)) {
            if (plant.getOuterPlantType().isPresent()) {
                SunEntity.spawnSunsByAmount(player.field_70170_p, plant.func_233580_cy_(), EnchantmentUtil.getSunShovelAmount(stack, plant.outerSunCost));
                plant.removeOuterPlant();
            } else {
                SunEntity.spawnSunsByAmount(player.field_70170_p, plant.func_233580_cy_(), EnchantmentUtil.getSunShovelAmount(stack, plant.plantSunCost));
                plant.func_70106_y();
            }
            EntityUtil.playSound((Entity)plant, (SoundEvent)SoundRegister.PLANT_ON_GROUND.get());
            stack.func_222118_a(3, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
        }
    }

    public static void onPlayerKillEntity(PlayerEntity player, DamageSource source, LivingEntity living) {
        if (living instanceof PVZZombieEntity) {
            PVZZombieEntity zombie = (PVZZombieEntity)living;
            int xp = ZombieUtil.getZombieXp(zombie.getZombieEnumName());
            PlayerUtil.addPlayerStats(player, Resources.TREE_XP, xp);
            PlayerEventHandler.onPlayerKillZombie(player, zombie.getZombieEnumName());
        }
        CriteriaTriggers.field_192122_b.func_192211_a((ServerPlayerEntity)player, (Entity)living, source);
    }

    public static void onPlayerKillZombie(PlayerEntity player, Zombies zombie) {
        PlayerUtil.addPlayerStats(player, Resources.KILL_COUNT, 1);
    }

    public static void onPlayerLogin(PlayerEntity player) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            PlayerDataManager plData = l.getPlayerData();
            PlayerDataManager.PlayerStats playerStats = plData.getPlayerStats();
            for (Resources res : Resources.values()) {
                playerStats.sendPacket(player, res);
            }
            PlayerDataManager.PlantStats plantStats = plData.getPlantStats();
            for (Plants plant : Plants.values()) {
                plantStats.sendPlantPacket(player, plant);
            }
            SearchOption.OPTION.forEach(a -> {
                ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
                if (PlayerUtil.isAlmanacUnlocked(serverplayer, a)) {
                    PlayerUtil.unLockAlmanac((PlayerEntity)serverplayer, a);
                }
            });
            PlayerDataManager.ItemCDStats itemCDStats = plData.getItemCDStats();
            for (Plants p : Plants.values()) {
                player.func_184811_cZ().func_185145_a((Item)PlantUtil.getPlantSummonCard(p), itemCDStats.getPlantCardCD(p));
            }
        });
        WaveManager.syncWaveTime(player);
    }
}

