/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.item.armor;

import com.hungteen.pvz.client.model.armor.FootballArmorModel;
import com.hungteen.pvz.register.GroupRegister;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FootballArmorItem
extends ArmorItem {
    private static final Map<EquipmentSlotType, BipedModel> modelMap = new EnumMap<EquipmentSlotType, BipedModel>(EquipmentSlotType.class);

    public FootballArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot) {
        super(materialIn, slot, new Item.Properties().func_200916_a(GroupRegister.PVZ_MISC));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (slot == EquipmentSlotType.HEAD) {
            return "pvz:textures/models/armor/football_helmet.png";
        }
        if (slot == EquipmentSlotType.CHEST) {
            return "pvz:textures/models/armor/football_chestplate.png";
        }
        if (slot == EquipmentSlotType.LEGS) {
            return "pvz:textures/models/armor/football_layer_2.png";
        }
        return "pvz:textures/models/armor/football_layer_1.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)modelMap.get(armorSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initArmorModel() {
        modelMap.put(EquipmentSlotType.HEAD, new FootballArmorModel(EquipmentSlotType.HEAD, 1.0f));
        modelMap.put(EquipmentSlotType.CHEST, new FootballArmorModel(EquipmentSlotType.CHEST, 1.0f));
    }
}

