/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.item.card;

import com.hungteen.pvz.client.render.itemstack.ImitaterCardISTER;
import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.container.ImitaterContainer;
import com.hungteen.pvz.common.container.inventory.ItemInventory;
import com.hungteen.pvz.common.enchantment.EnchantmentUtil;
import com.hungteen.pvz.common.entity.plant.magic.ImitaterEntity;
import com.hungteen.pvz.common.item.card.PlantCardItem;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.register.GroupRegister;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ImitaterCardItem
extends PlantCardItem {
    public static final String IMITATE_STRING = "imitate_plant_type";

    public ImitaterCardItem() {
        super(new Item.Properties().func_200916_a(GroupRegister.PVZ_CARD).func_200917_a(1).setISTER(() -> ImitaterCardISTER::new), Plants.IMITATER, false);
    }

    public ImitaterCardItem(boolean isFragment) {
        super(new Item.Properties().func_200916_a(GroupRegister.PVZ_CARD).func_200917_a(16), Plants.IMITATER, true);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (handIn == Hand.OFF_HAND) {
            this.openImitateGui(player);
            return ActionResult.func_226248_a_((Object)stack);
        }
        BlockRayTraceResult raytraceresult = ImitaterCardItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (world.field_72995_K) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
        if (!opt.isPresent() || !opt.get().isWaterPlant) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (opt.get() == Plants.FLOWER_POT) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos pos = blockraytraceresult.func_216350_a();
        if (!(world.func_180495_p(pos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, blockraytraceresult.func_216354_b(), stack)) {
            ImitaterCardItem.checkSunAndSummonImitater(player, stack, this, pos, l -> {});
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = context.func_195995_a();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (hand == Hand.OFF_HAND) {
            this.openImitateGui(player);
            return ActionResultType.SUCCESS;
        }
        Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
        if (!opt.isPresent() || opt.get() != Plants.CAT_TAIL && opt.get().isUpgradePlant) {
            return ActionResultType.FAIL;
        }
        if (opt.get() == Plants.LILY_PAD) {
            return ActionResultType.PASS;
        }
        if (opt.get() == Plants.CAT_TAIL) {
            if (world.func_180495_p(pos).func_177230_c() == BlockRegister.LILY_PAD.get()) {
                ImitaterCardItem.checkSunAndSummonImitater(player, stack, this, pos, imitater -> {
                    imitater.targetPos = Optional.of(pos);
                });
            } else {
                return ActionResultType.FAIL;
            }
        }
        BlockPos spawnPos = pos;
        if (!world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b()) {
            spawnPos = pos.func_177972_a(context.func_196000_l());
        }
        if (context.func_196000_l() == Direction.UP && world.func_175623_d(pos.func_177984_a())) {
            ImitaterCardItem.checkSunAndSummonImitater(player, stack, this, spawnPos, l -> {});
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static void checkSunAndSummonImitater(PlayerEntity player, ItemStack stack, PlantCardItem item, BlockPos pos, Consumer<ImitaterEntity> consumer) {
        ImitaterCardItem.checkSunAndSummonPlant(player, stack, item, pos, l -> {
            if (l instanceof ImitaterEntity) {
                ((ImitaterEntity)l).setImitateCard(stack.func_77946_l());
                ((ImitaterEntity)l).placeDirection = player.func_174811_aO().func_176734_d();
                Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
                if (opt.isPresent()) {
                    player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(data -> l.setPlantLvl(data.getPlayerData().getPlantStats().getPlantLevel((Plants)((Object)((Object)((Object)opt.get()))))));
                }
                consumer.accept((ImitaterEntity)l);
            }
        });
    }

    public boolean isPlantTypeEqual(ItemStack stack, Plants tmp) {
        Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
        return opt.isPresent() && opt.get() == tmp;
    }

    public int getImitateSunCost(ItemStack stack) {
        Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
        if (!opt.isPresent() || opt.get() == Plants.IMITATER) {
            return -1;
        }
        int cost = PlantUtil.getPlantSunCost(opt.get());
        return Math.max(cost - EnchantmentUtil.getSunReduceNum(stack), 0);
    }

    @Override
    public int getPlantCardCD(PlayerEntity player, ItemStack stack, Plants plant, int lvl) {
        Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
        if (!opt.isPresent() || opt.get() == Plants.IMITATER) {
            System.out.println("ERROR : Wrong Use of Imitater Card !");
            return 100;
        }
        return super.getPlantCardCD(player, stack, opt.get(), lvl);
    }

    public static Optional<Plants> getImitatePlantType(ItemStack stack) {
        ItemStack inv = ImitaterCardItem.getInventory(stack).func_70301_a(0);
        if (!(inv.func_77973_b() instanceof PlantCardItem)) {
            return Optional.empty();
        }
        PlantCardItem item = (PlantCardItem)inv.func_77973_b();
        return item.isEnjoyCard ? Optional.empty() : Optional.ofNullable(item.plantType);
    }

    private void openImitateGui(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
                    return new ImitaterContainer(id, player);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("gui.pvz.imitater.show");
                }
            });
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isEnjoyCard) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.imitater_card.no").func_240699_a_(TextFormatting.RED));
            return;
        }
        Optional<Plants> opt = ImitaterCardItem.getImitatePlantType(stack);
        if (!opt.isPresent() || opt.get() == Plants.IMITATER) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.imitater_card.empty").func_240699_a_(TextFormatting.RED));
            return;
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.imitater_card.yes").func_240702_b_(":").func_230529_a_((ITextComponent)new TranslationTextComponent("entity.pvz." + opt.get().toString().toLowerCase())).func_240699_a_(TextFormatting.LIGHT_PURPLE));
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT oldCapNbt) {
        return new InvProvider(stack);
    }

    public static Inventory getInventory(ItemStack stack) {
        return new ItemInventory(stack, 1){

            public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
                return ImitaterCardItem.isValidImitateSlot(stack);
            }
        };
    }

    public static boolean isValidImitateSlot(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof PlantCardItem)) {
            return false;
        }
        PlantCardItem item = (PlantCardItem)stack.func_77973_b();
        return !item.isEnjoyCard && !(item instanceof ImitaterCardItem);
    }

    private static class InvProvider
    implements ICapabilityProvider {
        private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> new InvWrapper((IInventory)ImitaterCardItem.getInventory(stack)));

        private InvProvider(ItemStack stack) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.opt);
        }
    }
}

