/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.item.card;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.common.advancement.trigger.PlayerPlacePlantTrigger;
import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.capability.player.PlayerDataManager;
import com.hungteen.pvz.common.enchantment.EnchantmentUtil;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.plant.base.PlantDefenderEntity;
import com.hungteen.pvz.common.event.events.SummonCardUseEvent;
import com.hungteen.pvz.common.item.card.BlockPlantCardItem;
import com.hungteen.pvz.common.item.card.SummonCardItem;
import com.hungteen.pvz.register.BlockRegister;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.register.EnchantmentRegister;
import com.hungteen.pvz.register.SoundRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Ranks;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.potion.Effect;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PlantCardItem
extends SummonCardItem {
    public final Plants plantType;

    public PlantCardItem(Plants plant, boolean isFragment) {
        super(isFragment);
        this.plantType = plant;
    }

    public PlantCardItem(Item.Properties properties, Plants plant, boolean isFragment) {
        super(properties, isFragment);
        this.plantType = plant;
    }

    @Override
    public int func_77619_b() {
        Ranks rank = PlantUtil.getPlantRankByName(this.plantType);
        return 18 - rank.ordinal();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!this.plantType.isWaterPlant || this.plantType == Plants.CAT_TAIL) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        BlockRayTraceResult raytraceresult = PlantCardItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (world.field_72995_K) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos pos = blockraytraceresult.func_216350_a();
        if (!(world.func_180495_p(pos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, blockraytraceresult.func_216354_b(), stack)) {
            PlantCardItem.checkSunAndSummonPlant(player, stack, this, pos, l -> {});
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = context.func_195995_a();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (this.plantType.isOuterPlant || this.plantType.isUpgradePlant) {
            if (this.plantType == Plants.CAT_TAIL && world.func_180495_p(pos).func_177230_c() == BlockRegister.LILY_PAD.get()) {
                PlantCardItem.checkSunAndSummonPlant(player, stack, this, pos.func_177977_b(), l -> world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P()));
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        if (this.plantType.isWaterPlant) {
            return ActionResultType.PASS;
        }
        BlockPos spawnPos = pos;
        if (!world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b()) {
            spawnPos = pos.func_177972_a(context.func_196000_l());
        }
        if (context.func_196000_l() == Direction.UP && world.func_175623_d(pos.func_177984_a())) {
            PlantCardItem.checkSunAndSummonPlant(player, stack, this, spawnPos, l -> {});
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static void checkSunAndSummonPlant(PlayerEntity player, ItemStack stack, PlantCardItem cardItem, BlockPos pos, Consumer<PVZPlantEntity> consumer) {
        if (player.func_184811_cZ().func_185141_a((Item)cardItem)) {
            return;
        }
        Plants plantType = cardItem.plantType;
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int sunCost;
            PlayerDataManager manager = l.getPlayerData();
            int num = manager.getPlayerStats().getPlayerStats(Resources.SUN_NUM);
            if (num >= (sunCost = SummonCardItem.getItemStackSunCost(stack))) {
                EntityType<? extends PVZPlantEntity> entityType = PlantUtil.getPlantEntityType(plantType);
                PVZPlantEntity plantEntity = (PVZPlantEntity)entityType.func_220331_a((ServerWorld)player.field_70170_p, stack, player, pos, SpawnReason.SPAWN_EGG, true, true);
                if (plantEntity == null) {
                    PVZMod.LOGGER.debug("no such plant");
                    return;
                }
                l.getPlayerData().getPlayerStats().addPlayerStats(Resources.SUN_NUM, -sunCost);
                int lvl = manager.getPlantStats().getPlantLevel(plantType);
                plantEntity.onSpawnedByPlayer(player, lvl);
                plantEntity.plantSunCost = sunCost;
                PlantCardItem.onUsePlantCard(player, stack, cardItem, lvl);
                PlantCardItem.summonPlantEntityByCard(plantEntity, stack);
                consumer.accept(plantEntity);
            }
        });
    }

    public static void summonPlantEntityByCard(PVZPlantEntity plantEntity, ItemStack stack) {
        if (PlantCardItem.canPlantBreakOut(stack) && plantEntity.canStartSuperMode()) {
            plantEntity.startSuperMode(false);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentRegister.CHARM.get()), (ItemStack)stack) > 0) {
            plantEntity.onCharmedBy(null);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentRegister.SOILLESS_PLANT.get()), (ItemStack)stack) > 0) {
            plantEntity.setImmunneToWeak(true);
        }
    }

    public static void checkSunAndPlaceBlock(PlayerEntity player, BlockPlantCardItem cardItem, ItemStack stack, BlockPos pos) {
        if (player.func_184811_cZ().func_185141_a((Item)cardItem)) {
            return;
        }
        Plants plantType = cardItem.plantType;
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int sunCost;
            PlayerDataManager manager = l.getPlayerData();
            int num = manager.getPlayerStats().getPlayerStats(Resources.SUN_NUM);
            if (num >= (sunCost = SummonCardItem.getItemStackSunCost(stack))) {
                l.getPlayerData().getPlayerStats().addPlayerStats(Resources.SUN_NUM, -sunCost);
                PlantCardItem.onUsePlantCard(player, stack, cardItem, manager.getPlantStats().getPlantLevel(plantType));
                BlockState state = BlockPlantCardItem.getBlockState(player, plantType);
                if (state == null) {
                    return;
                }
                player.field_70170_p.func_180501_a(pos, state, 11);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
                }
                player.field_70170_p.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), plantType.isWaterPlant ? (SoundEvent)SoundRegister.PLANT_IN_WATER.get() : (SoundEvent)SoundRegister.PLANT_ON_GROUND.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        });
    }

    public static void checkSunAndOuterPlant(PlayerEntity player, PVZPlantEntity plantEntity, PlantCardItem cardItem, ItemStack stack) {
        if (player.func_184811_cZ().func_185141_a((Item)cardItem)) {
            return;
        }
        Plants plantType = cardItem.plantType;
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int sunCost;
            PlayerDataManager manager = l.getPlayerData();
            int num = manager.getPlayerStats().getPlayerStats(Resources.SUN_NUM);
            if (num >= (sunCost = SummonCardItem.getItemStackSunCost(stack))) {
                l.getPlayerData().getPlayerStats().addPlayerStats(Resources.SUN_NUM, -sunCost);
                PlantCardItem.onUsePlantCard(player, stack, cardItem, manager.getPlantStats().getPlantLevel(plantType));
                plantEntity.outerSunCost = sunCost;
                PlantCardItem.placeOuterPlant(plantEntity, plantType, stack);
            }
        });
    }

    public static void placeOuterPlant(PVZPlantEntity plantEntity, Plants plantType, ItemStack stack) {
        if (plantType == Plants.PUMPKIN) {
            float life = 400.0f;
            if (PlantCardItem.canPlantBreakOut(stack)) {
                life += 400.0f;
            }
            plantEntity.setPumpkinLife(life);
        }
        plantEntity.setOuterPlantType(plantType);
        EntityUtil.playSound((Entity)plantEntity, (SoundEvent)SoundRegister.PLANT_ON_GROUND.get());
    }

    public static void checkSunAndHealPlant(PlayerEntity player, PVZPlantEntity plantEntity, PlantCardItem cardItem, ItemStack stack) {
        if (player.func_184811_cZ().func_185141_a((Item)cardItem)) {
            return;
        }
        Plants plantType = cardItem.plantType;
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int sunCost;
            PlayerDataManager manager = l.getPlayerData();
            int num = manager.getPlayerStats().getPlayerStats(Resources.SUN_NUM);
            if (num >= (sunCost = SummonCardItem.getItemStackSunCost(stack))) {
                l.getPlayerData().getPlayerStats().addPlayerStats(Resources.SUN_NUM, -sunCost);
                PlantCardItem.onUsePlantCard(player, stack, cardItem, manager.getPlantStats().getPlantLevel(plantType));
                if (cardItem.plantType == Plants.PUMPKIN) {
                    float life = 400.0f;
                    if (PlantCardItem.canPlantBreakOut(stack)) {
                        life += 400.0f;
                    }
                    plantEntity.setPumpkinLife(life);
                } else {
                    plantEntity.func_70691_i(plantEntity.func_110138_aP());
                    if (plantEntity instanceof PlantDefenderEntity && PlantCardItem.canPlantBreakOut(stack)) {
                        ((PlantDefenderEntity)plantEntity).setDefenceLife(((PlantDefenderEntity)plantEntity).getSuperLife());
                    }
                }
                EntityUtil.playSound((Entity)plantEntity, (SoundEvent)SoundRegister.PLANT_ON_GROUND.get());
            }
        });
    }

    public static void onUsePlantCard(PlayerEntity player, ItemStack stack, PlantCardItem item, int plantLvl) {
        MinecraftForge.EVENT_BUS.post((Event)new SummonCardUseEvent(player, stack));
        if (item.isEnjoyCard) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else {
            PlantCardItem.handlePlantCardCoolDown(player, stack, item, plantLvl);
        }
        if (player instanceof ServerPlayerEntity) {
            PlayerPlacePlantTrigger.INSTANCE.trigger((ServerPlayerEntity)player, item.plantType.ordinal());
        }
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
    }

    public static void handlePlantCardCoolDown(PlayerEntity player, ItemStack stack, PlantCardItem item, int plantLvl) {
        int cd = PlantCardItem.getPlantCardCD(player, stack, item, plantLvl);
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> l.getPlayerData().getItemCDStats().setPlantCardCD(item.plantType, cd));
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), cd);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.plant_card").func_240699_a_(TextFormatting.GREEN));
        PlantCardItem item = (PlantCardItem)stack.func_77973_b();
        if (item == null) {
            System.out.println("ERROR : Wrong Plant Card Item !");
            return;
        }
        Plants plant = item.plantType;
        if (plant.isUpgradePlant) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz." + plant.toString().toLowerCase() + "_card").func_240699_a_(TextFormatting.RED));
        } else if (plant == Plants.DOOM_SHROOM) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz." + plant.toString().toLowerCase() + "_card").func_240699_a_(TextFormatting.DARK_RED));
        }
    }

    public static int getPlantCardCD(PlayerEntity player, ItemStack stack, PlantCardItem item, int plantLvl) {
        int cd = item.getPlantCardCD(player, stack, item.plantType, plantLvl);
        if (player.func_70644_a((Effect)EffectRegister.EXCITE_EFFECT.get())) {
            int lvl = player.func_70660_b((Effect)EffectRegister.EXCITE_EFFECT.get()).func_76458_c();
            float mult = Math.max(0.0f, 0.9f - 0.1f * (float)lvl);
            cd = (int)Math.floor((float)cd * mult);
        }
        return cd;
    }

    public int getPlantCardCD(PlayerEntity player, ItemStack stack, Plants plant, int lvl) {
        return PlantUtil.getPlantCoolDownTime(plant, lvl);
    }

    public static boolean canPlantBreakOut(ItemStack stack) {
        return field_77697_d.nextInt(100) < EnchantmentUtil.getPlantBreakOutChance(stack);
    }
}

