/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.item.tool;

import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.container.PeaGunContainer;
import com.hungteen.pvz.common.container.inventory.ItemInventory;
import com.hungteen.pvz.common.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.common.item.card.PlantCardItem;
import com.hungteen.pvz.common.network.PVZPacketHandler;
import com.hungteen.pvz.common.network.PlaySoundPacket;
import com.hungteen.pvz.register.GroupRegister;
import com.hungteen.pvz.register.ItemRegister;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Resources;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.InfinityEnchantment;
import net.minecraft.enchantment.PowerEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class PeaGunItem
extends Item {
    public static final int PEA_GUN_SLOT_NUM = 28;
    public static final float PEA_SPEED = 2.1f;
    public static final double SHOOT_OFFSET = 0.5;
    public static final Plants[] PEA_PLANTS = new Plants[]{Plants.PEA_SHOOTER, Plants.SNOW_PEA, Plants.REPEATER, Plants.THREE_PEATER};

    public PeaGunItem() {
        super(new Item.Properties().func_200916_a(GroupRegister.PVZ_MISC).func_200917_a(1));
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT oldCapNbt) {
        return new InvProvider(stack);
    }

    public static Inventory getInventory(ItemStack stack) {
        return new ItemInventory(stack, 28){

            public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return true;
                }
                return stack.func_77973_b() == ItemRegister.PEA.get() || stack.func_77973_b() == ItemRegister.SNOW_PEA.get() || stack.func_77973_b() == ItemRegister.FLAME_PEA.get();
            }
        };
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof PowerEnchantment || enchantment instanceof InfinityEnchantment) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            if (handIn == Hand.MAIN_HAND) {
                if (!this.checkAndShootPea(worldIn, playerIn, playerIn.func_184614_ca())) {
                    return ActionResult.func_226251_d_((Object)playerIn.func_184586_b(handIn));
                }
            } else if (playerIn instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                        return new PeaGunContainer(p_createMenu_1_, p_createMenu_3_);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("gui.pvz.pea_gun.show");
                    }
                });
            }
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public boolean checkAndShootPea(World world, PlayerEntity player, ItemStack itemStack) {
        Inventory backpack = PeaGunItem.getInventory(itemStack);
        ItemStack special = backpack.func_70301_a(0);
        if (special.func_77973_b() instanceof PlantCardItem) {
            Plants plant = ((PlantCardItem)special.func_77973_b()).plantType;
            for (int i = 1; i < 28; ++i) {
                ItemStack stack = backpack.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (!this.canShoot(player, plant, stack, itemStack)) break;
                if (PlayerUtil.isPlayerSurvival(player)) {
                    this.shrinkItemStack(player, backpack, i, itemStack);
                }
                PVZPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlaySoundPacket(1));
                this.setPlayerCoolDownTick(player);
                return true;
            }
        }
        return false;
    }

    private void shrinkItemStack(PlayerEntity player, Inventory backpack, int i, ItemStack stack) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            boolean flag = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            int lvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
            int cnt = (lvl - 1) / 10 * 5 + 5;
            if (!flag || field_77697_d.nextInt(100) >= cnt) {
                backpack.func_70298_a(i, 1);
            }
        });
    }

    protected boolean canShoot(PlayerEntity player, Plants plant, ItemStack stack, ItemStack peaGun) {
        switch (plant) {
            case PEA_SHOOTER: 
            case SNOW_PEA: {
                this.performShoot(player, plant, stack, peaGun, 0);
                return true;
            }
            case REPEATER: {
                this.performShoot(player, plant, stack, peaGun, 0);
                this.performShoot(player, plant, stack, peaGun, 1);
                return true;
            }
            case THREE_PEATER: {
                this.performShoot(player, plant, stack, peaGun, 0);
                this.performShoot(player, plant, stack, peaGun, 1);
                this.performShoot(player, plant, stack, peaGun, 2);
                return true;
            }
            case SPLIT_PEA: {
                this.performShoot(player, plant, stack, peaGun, 0);
                this.performShoot(player, plant, stack, peaGun, 1);
                this.performShoot(player, plant, stack, peaGun, 2);
                return true;
            }
            case GATLING_PEA: {
                this.performShoot(player, plant, stack, peaGun, 0);
                this.performShoot(player, plant, stack, peaGun, 1);
                this.performShoot(player, plant, stack, peaGun, 2);
                this.performShoot(player, plant, stack, peaGun, 3);
                return true;
            }
        }
        return false;
    }

    private void performShoot(PlayerEntity player, Plants plant, ItemStack stack, ItemStack peaGun, int type) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int plantLvl = l.getPlayerData().getPlantStats().getPlantLevel(plant);
            int lvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
            PeaEntity.Type peaType = PeaEntity.Type.NORMAL;
            if (plantLvl > 6) {
                int now = (lvl + 19) / 20;
                int bigChance = now * 5;
                int hugeChance = bigChance + (plantLvl > 13 ? now : 0);
                int tmp = field_77697_d.nextInt(100);
                if (tmp < bigChance) {
                    peaType = PeaEntity.Type.BIG;
                } else if (tmp < hugeChance) {
                    peaType = PeaEntity.Type.HUGE;
                }
            }
            PeaEntity pea = new PeaEntity(player.field_70170_p, (LivingEntity)player, peaType, this.getPeaState(plant, stack.func_77973_b()));
            pea.setPower(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)peaGun));
            Vector3d vec = player.func_70040_Z();
            Vector3d offset = vec.func_186678_a(0.5);
            pea.func_70107_b(player.func_226277_ct_() + offset.field_72450_a, player.func_226278_cu_() + (double)player.func_70047_e() + offset.field_72448_b, player.func_226281_cx_() + offset.field_72449_c);
            float speed = 2.1f;
            if (plant == Plants.REPEATER || plant == Plants.GATLING_PEA) {
                speed = (float)((double)speed - 0.2 * (double)type);
            } else if (plant == Plants.THREE_PEATER) {
                offset = offset.func_186678_a(2.0);
                if (type == 1) {
                    pea.func_70107_b(player.func_226277_ct_() + offset.field_72450_a + offset.field_72449_c, player.func_226278_cu_() + (double)player.func_70047_e() + offset.field_72448_b, player.func_226281_cx_() + offset.field_72449_c - offset.field_72450_a);
                } else if (type == 2) {
                    pea.func_70107_b(player.func_226277_ct_() + offset.field_72450_a - offset.field_72449_c, player.func_226278_cu_() + (double)player.func_70047_e() + offset.field_72448_b, player.func_226281_cx_() + offset.field_72449_c + offset.field_72450_a);
                }
            } else if (plant == Plants.SPLIT_PEA && type > 0) {
                speed *= -1.0f;
                if (type == 2) {
                    speed = (float)((double)speed + 0.2);
                }
            }
            pea.summonByOwner((Entity)player);
            pea.setAttackDamage(2.0f);
            pea.func_213317_d(vec.func_186678_a((double)speed));
            player.field_70170_p.func_217376_c((Entity)pea);
        });
    }

    private PeaEntity.State getPeaState(Plants plant, Item item) {
        if (plant == Plants.SNOW_PEA) {
            return PeaEntity.State.ICE;
        }
        if (item == ItemRegister.SNOW_PEA.get()) {
            return PeaEntity.State.ICE;
        }
        if (item == ItemRegister.FLAME_PEA.get()) {
            return PeaEntity.State.FIRE;
        }
        if (item == ItemRegister.BLUE_FLAME_PEA.get()) {
            return PeaEntity.State.BLUE_FIRE;
        }
        return PeaEntity.State.NORMAL;
    }

    protected void setPlayerCoolDownTick(PlayerEntity player) {
        player.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
            int lvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
            int now = (lvl - 1) / 10;
            int CD = 30 - 2 * now;
            if (lvl > 90) {
                CD -= 2;
            }
            player.func_184811_cZ().func_185145_a((Item)this, CD);
        });
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.pea_gun").func_240699_a_(TextFormatting.GREEN));
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.HEAD;
    }

    private static class InvProvider
    implements ICapabilityProvider {
        private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> new InvWrapper((IInventory)PeaGunItem.getInventory(stack)));

        private InvProvider(ItemStack stack) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.opt);
        }
    }
}

