/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.item.tool;

import com.hungteen.pvz.common.capability.CapabilityHandler;
import com.hungteen.pvz.common.entity.drop.SunEntity;
import com.hungteen.pvz.register.GroupRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.enums.Resources;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SunCollectorItem
extends Item {
    public static final int SINGLE_COLLET_COOL_DOWN = 10;
    public static final int RANGE_COLLECT_COOL_DOWN = 200;

    public SunCollectorItem() {
        super(new Item.Properties().func_200916_a(GroupRegister.PVZ_MISC).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            if (playerIn.func_225608_bj_()) {
                playerIn.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                    int lvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
                    int treeLvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
                    double range = SunCollectorItem.getRangeCollectRange(lvl);
                    boolean has = false;
                    for (SunEntity sun2 : worldIn.func_175647_a(SunEntity.class, EntityUtil.getEntityAABB((Entity)playerIn, range, range), sun -> sun.func_70089_S())) {
                        if (l.getPlayerData().getPlayerStats().getPlayerStats(Resources.SUN_NUM) == PlayerUtil.getPlayerMaxSunNum(treeLvl)) break;
                        sun2.onCollectedByPlayer(playerIn);
                        has = true;
                    }
                    playerIn.func_184811_cZ().func_185145_a((Item)this, has ? 200 : 10);
                    if (has) {
                        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    }
                });
            } else {
                playerIn.getCapability(CapabilityHandler.PLAYER_DATA_CAPABILITY).ifPresent(l -> {
                    EntityRayTraceResult entityRay;
                    Vector3d look = playerIn.func_70040_Z();
                    Vector3d start = playerIn.func_213303_ch().func_72441_c(0.0, (double)playerIn.func_70047_e(), 0.0);
                    int lvl = l.getPlayerData().getPlayerStats().getPlayerStats(Resources.TREE_LVL);
                    double range = SunCollectorItem.getSingleCollectRange(lvl);
                    Vector3d end = start.func_178787_e(look.func_72432_b().func_216372_d(range, range, range));
                    RayTraceContext ray = new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)playerIn);
                    BlockRayTraceResult result = worldIn.func_217299_a(ray);
                    if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                        end = result.func_216347_e();
                    }
                    if ((entityRay = this.rayTraceEntities(worldIn, playerIn, range, start, end)) != null && entityRay.func_216346_c() == RayTraceResult.Type.ENTITY && entityRay.func_216348_a() instanceof SunEntity) {
                        SunEntity sun = (SunEntity)entityRay.func_216348_a();
                        sun.onCollectedByPlayer(playerIn);
                        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                        playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                    }
                });
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static float getSingleCollectRange(int lvl) {
        int now = (lvl - 1) / 20;
        return 20 + 5 * now;
    }

    public static float getRangeCollectRange(int lvl) {
        if (lvl <= 60) {
            int now = (lvl - 1) / 20;
            return 8 + 2 * now;
        }
        if (lvl <= 100) {
            int now = (lvl - 1) / 20 - 3;
            return 15 + 3 * now;
        }
        return 18.0f;
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(World world, PlayerEntity player, double range, Vector3d startVec, Vector3d endVec) {
        return ProjectileHelper.func_221269_a((World)world, (Entity)player, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)player.func_174813_aQ().func_186662_g(range), entity -> entity instanceof SunEntity && entity.func_70089_S());
    }
}

