/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.misc;

import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.common.cache.InvasionCache;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.utils.ZombieUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpawnChecker {
    public static boolean canZombieSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return SpawnChecker.checkSpawn(zombieType, worldIn, reason, pos, rand);
    }

    public static boolean canGroundInvasionZombieSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return SpawnChecker.checkInvasionList(zombieType, worldIn, reason) && SpawnChecker.checkSpawn(zombieType, worldIn, reason, pos, rand);
    }

    public static boolean canNightZombieSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return worldIn instanceof ServerWorld && !((ServerWorld)worldIn).func_72935_r() && SpawnChecker.checkSpawn(zombieType, worldIn, reason, pos, rand);
    }

    public static boolean canWaterInvasionZombieSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return SpawnChecker.checkInvasionList(zombieType, worldIn, reason) && SpawnChecker.checkLightAndDifficulty(worldIn, pos) && (reason == SpawnReason.SPAWNER || SpawnChecker.isInWater(worldIn, pos));
    }

    public static boolean canSkyInvasionZombieSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return SpawnChecker.checkInvasionList(zombieType, worldIn, reason) && SpawnChecker.checkLightAndDifficulty(worldIn, pos) && (reason == SpawnReason.SPAWNER || SpawnChecker.canSeeSky(worldIn, pos));
    }

    public static boolean canYetiSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        if (worldIn instanceof ServerWorld && SpawnChecker.canZombieSpawn(zombieType, worldIn, reason, pos, rand)) {
            return ((ServerWorld)worldIn).func_72911_I() && !((ServerWorld)worldIn).func_72935_r() && rand.nextInt(3) == 0;
        }
        return false;
    }

    private static boolean checkInvasionList(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason) {
        if (reason != SpawnReason.NATURAL) {
            return true;
        }
        Optional<Zombies> opt = ZombieUtil.getZombieNameByType(zombieType);
        if (worldIn instanceof World) {
            if (opt.isPresent()) {
                return InvasionCache.ZOMBIE_INVADE_SET.contains((Object)opt.get());
            }
            PVZMod.LOGGER.error("SpawnChecker : No Such Zombie Type !");
            return false;
        }
        return false;
    }

    private static boolean checkSpawn(EntityType<? extends PVZZombieEntity> zombieType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        return SpawnChecker.isDarkEnough(worldIn, pos) && MonsterEntity.func_223324_d(zombieType, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }

    private static boolean isInWater(IWorld world, BlockPos pos) {
        return world.func_204610_c(pos.func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private static boolean canSeeSky(IWorld world, BlockPos pos) {
        return world.func_226660_f_(pos);
    }

    private static boolean checkLightAndDifficulty(IWorld worldIn, BlockPos pos) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && SpawnChecker.isDarkEnough(worldIn, pos);
    }

    private static boolean isDarkEnough(IWorld worldIn, BlockPos pos) {
        return worldIn.func_226658_a_(LightType.BLOCK, pos) < 7;
    }
}

