/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.misc.damage;

import com.hungteen.pvz.common.entity.bullet.BallEntity;
import com.hungteen.pvz.common.entity.bullet.ButterEntity;
import com.hungteen.pvz.common.entity.bullet.CornEntity;
import com.hungteen.pvz.common.entity.bullet.FumeEntity;
import com.hungteen.pvz.common.entity.bullet.KernelEntity;
import com.hungteen.pvz.common.entity.bullet.MelonEntity;
import com.hungteen.pvz.common.entity.bullet.StarEntity;
import com.hungteen.pvz.common.entity.bullet.itembullet.CabbageEntity;
import com.hungteen.pvz.common.entity.bullet.itembullet.MetalItemEntity;
import com.hungteen.pvz.common.entity.bullet.itembullet.PeaEntity;
import com.hungteen.pvz.common.entity.bullet.itembullet.SporeEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PVZDamageSource
extends DamageSource {
    private final List<EffectInstance> effects = new ArrayList<EffectInstance>();
    private Entity attackOwner = null;
    private Entity attacker = null;
    private boolean isAppease = false;
    private boolean isParabola = false;
    private boolean isIceDamage = false;
    private boolean isFlameDamage = false;
    private boolean isEatDamage = false;
    private boolean isCrushDamage = false;
    private boolean isThroughDamage = false;
    private boolean isThornDamage = false;
    private boolean isDefended = false;
    private boolean mustHurt = false;
    private int damageCount = 0;
    public static final PVZDamageSource PLANT_WILT = new PVZDamageSource("plant_wilt");
    public static final PVZDamageSource CHOMPER_PLANT = new PVZDamageSource("chomper_plant").setEatDamage();

    public PVZDamageSource(String name) {
        this(name, null);
    }

    public PVZDamageSource(String name, Entity attacker) {
        this(name, attacker, attacker);
    }

    public PVZDamageSource(String name, Entity damagingEntity, Entity attacker) {
        super(name);
        this.attacker = damagingEntity;
        this.attackOwner = attacker;
    }

    public static PVZDamageSource pea(PeaEntity pea, Entity shooter) {
        return new PVZDamageSource("pea", pea, shooter).setAppease();
    }

    public static PVZDamageSource snowPea(PeaEntity pea, Entity shooter) {
        return new PVZDamageSource("snow_pea", pea, shooter).setAppease().setIceDamage();
    }

    public static PVZDamageSource flamePea(PeaEntity pea, Entity shooter) {
        return new PVZDamageSource("flame_pea", pea, shooter).setAppease().setFlameDamage();
    }

    public static PVZDamageSource spore(SporeEntity pea, Entity shooter) {
        return new PVZDamageSource("spore", pea, shooter).setAppease();
    }

    public static PVZDamageSource fume(FumeEntity pea, Entity shooter) {
        return new PVZDamageSource("fume", pea, shooter).setAppease().setThroughDamage();
    }

    public static PVZDamageSource star(StarEntity pea, Entity shooter) {
        return new PVZDamageSource("star", pea, shooter).setAppease();
    }

    public static PVZDamageSource metal(MetalItemEntity pea, Entity shooter) {
        return new PVZDamageSource("metal", pea, shooter).setAppease();
    }

    public static PVZDamageSource cabbage(CabbageEntity pea, Entity shooter) {
        return new PVZDamageSource("cabbage", pea, shooter).setParabola();
    }

    public static PVZDamageSource kernel(KernelEntity pea, Entity shooter) {
        return new PVZDamageSource("kernel", pea, shooter).setParabola();
    }

    public static PVZDamageSource corn(CornEntity pea, Entity shooter) {
        return (PVZDamageSource)new PVZDamageSource("corn", pea, shooter).setParabola().func_94540_d();
    }

    public static PVZDamageSource butter(ButterEntity pea, Entity shooter) {
        return new PVZDamageSource("butter", pea, shooter).setParabola();
    }

    public static PVZDamageSource melon(MelonEntity pea, Entity shooter) {
        return new PVZDamageSource("melon", pea, shooter).setParabola();
    }

    public static PVZDamageSource winterMelon(MelonEntity pea, Entity shooter) {
        return new PVZDamageSource("winter_melon", pea, shooter).setParabola().setIceDamage();
    }

    public static PVZDamageSource ball(BallEntity pea, Entity shooter) {
        return new PVZDamageSource("ball", pea, shooter).setParabola();
    }

    public static PVZDamageSource normal(Entity projectile, Entity attacker) {
        return new PVZDamageSource("normal", projectile, attacker);
    }

    public static PVZDamageSource normal(Entity attacker) {
        return PVZDamageSource.normal(attacker, attacker);
    }

    public static PVZDamageSource eat(Entity projectile, Entity attacker) {
        return new PVZDamageSource("eat", projectile, attacker).setEatDamage();
    }

    public static PVZDamageSource eat(Entity attacker) {
        return PVZDamageSource.eat(attacker, attacker);
    }

    public static PVZDamageSource explode(Entity projectile, Entity shooter) {
        return (PVZDamageSource)new PVZDamageSource("explosion", projectile, shooter).setMustHurt().func_94540_d();
    }

    public static PVZDamageSource explode(Entity attacker) {
        return PVZDamageSource.explode(attacker, attacker);
    }

    public static PVZDamageSource causeDeadlyDamage(Entity projectile, Entity shooter) {
        return new PVZDamageSource("deadly", projectile, shooter).setMustHurt();
    }

    public static PVZDamageSource causeDeadlyDamage(Entity attacker) {
        return PVZDamageSource.causeDeadlyDamage(attacker, attacker);
    }

    public static PVZDamageSource causeCrushDamage(Entity attacker) {
        return new PVZDamageSource("crush", attacker).setCrushDamage();
    }

    public static PVZDamageSource causeThornDamage(Entity projectile, Entity shooter) {
        return new PVZDamageSource("thorn", projectile, shooter).setThornDamage();
    }

    public static PVZDamageSource causeThornDamage(Entity attacker) {
        return PVZDamageSource.causeThornDamage(attacker, attacker);
    }

    public static PVZDamageSource causeIceDamage(Entity projectile, Entity shooter) {
        return new PVZDamageSource("ice", projectile, shooter).setIceDamage();
    }

    public static PVZDamageSource causeIceDamage(Entity attacker) {
        return PVZDamageSource.causeIceDamage(attacker, attacker);
    }

    public static PVZDamageSource causeFlameDamage(Entity projectile, Entity shooter) {
        return new PVZDamageSource("flame", projectile, shooter).setFlameDamage();
    }

    public static PVZDamageSource causeFlameDamage(Entity attacker) {
        return PVZDamageSource.causeFlameDamage(attacker, attacker);
    }

    public static boolean isEnforceDamage(DamageSource source) {
        return !source.func_76352_a() && !source.func_82725_o() && !source.func_94541_c() && !source.func_76347_k();
    }

    public ITextComponent func_151519_b(LivingEntity entityLivingBaseIn) {
        String s = "death.attack.pvz." + this.func_76355_l();
        return new TranslationTextComponent(s, new Object[]{entityLivingBaseIn.func_145748_c_()});
    }

    public Entity func_76346_g() {
        return this.attackOwner;
    }

    public Entity func_76364_f() {
        return this.attacker;
    }

    @Nullable
    public Vector3d func_188404_v() {
        return this.attacker != null ? this.attacker.func_213303_ch() : null;
    }

    public PVZDamageSource setCount(int cnt) {
        this.damageCount = cnt;
        return this;
    }

    public int getDamageCount() {
        return this.damageCount;
    }

    public void addEffect(EffectInstance instance) {
        this.effects.add(instance);
    }

    public List<EffectInstance> getEffects() {
        return this.effects;
    }

    public void setDefended(boolean is) {
        this.isDefended = is;
    }

    public boolean isDefended() {
        return this.isDefended;
    }

    public boolean isAppease() {
        return this.isAppease;
    }

    public PVZDamageSource setAppease() {
        this.isAppease = true;
        this.func_76349_b();
        return this;
    }

    public boolean isParabola() {
        return this.isParabola;
    }

    public PVZDamageSource setParabola() {
        this.isParabola = true;
        this.func_76349_b();
        return this;
    }

    public boolean isIceDamage() {
        return this.isIceDamage;
    }

    public PVZDamageSource setIceDamage() {
        this.isIceDamage = true;
        return this;
    }

    public boolean isFlameDamage() {
        return this.isFlameDamage;
    }

    public PVZDamageSource setFlameDamage() {
        this.isFlameDamage = true;
        this.func_76361_j();
        return this;
    }

    public boolean isEatDamage() {
        return this.isEatDamage;
    }

    public PVZDamageSource setEatDamage() {
        this.isEatDamage = true;
        return this;
    }

    public boolean isCrushDamage() {
        return this.isCrushDamage;
    }

    public PVZDamageSource setCrushDamage() {
        this.isCrushDamage = true;
        this.func_76348_h();
        return this;
    }

    public boolean isThroughDamage() {
        return this.isThroughDamage;
    }

    public PVZDamageSource setThroughDamage() {
        this.isThroughDamage = true;
        this.func_76348_h();
        return this;
    }

    public boolean isThornDamage() {
        return this.isThornDamage;
    }

    public PVZDamageSource setThornDamage() {
        this.isThornDamage = true;
        return this;
    }

    public boolean isMustHurt() {
        return this.mustHurt;
    }

    public PVZDamageSource setMustHurt() {
        this.mustHurt = true;
        return this;
    }
}

