/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.network;

import com.hungteen.pvz.register.SoundRegister;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlaySoundPacket {
    private int type;

    public PlaySoundPacket(int x) {
        this.type = x;
    }

    public PlaySoundPacket(PacketBuffer buffer) {
        this.type = buffer.readInt();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.type);
    }

    public static class Handler {
        public static void onMessage(PlaySoundPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                int id = message.type;
                SoundEvent sound = null;
                if (id == 0) {
                    sound = (SoundEvent)SoundRegister.SUN_PICK.get();
                } else if (id == 1) {
                    sound = SoundEvents.field_187805_fE;
                } else if (id == 2) {
                    sound = (SoundEvent)SoundRegister.HUGE_WAVE.get();
                } else if (id == 3) {
                    sound = (SoundEvent)SoundRegister.WARN.get();
                } else if (id == 4) {
                    sound = (SoundEvent)SoundRegister.WIN_MUSIC.get();
                } else if (id == 5) {
                    sound = (SoundEvent)SoundRegister.LOSE_MUSIC.get();
                } else if (id == 6) {
                    sound = (SoundEvent)SoundRegister.COIN_PICK.get();
                } else if (id == 7) {
                    sound = (SoundEvent)SoundRegister.JEWEL_PICK.get();
                } else if (id == 8) {
                    sound = (SoundEvent)SoundRegister.SLOT_MACHINE.get();
                } else if (id == 9) {
                    sound = (SoundEvent)SoundRegister.PLANT_GROW.get();
                } else if (id == 10) {
                    sound = (SoundEvent)SoundRegister.JACK_SAY.get();
                }
                if (sound != null) {
                    Minecraft.func_71410_x().field_71439_g.func_184185_a(sound, 1.0f, 1.0f);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

