/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.network;

import com.hungteen.pvz.client.cache.ClientPlayerResources;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerStatsPacket {
    private int type;
    private int data;

    public PlayerStatsPacket(int x, int y) {
        this.type = x;
        this.data = y;
    }

    public PlayerStatsPacket(PacketBuffer buffer) {
        this.type = buffer.readInt();
        this.data = buffer.readInt();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.type);
        buffer.writeInt(this.data);
    }

    public static class Handler {
        public static void onMessage(PlayerStatsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> ClientPlayerResources.setPlayerData(message.type, message.data));
            ctx.get().setPacketHandled(true);
        }
    }
}

