/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.structure.shop;

import com.hungteen.pvz.common.entity.npc.CrazyDaveEntity;
import com.hungteen.pvz.common.entity.npc.PennyEntity;
import com.hungteen.pvz.common.entity.plant.appease.PeaShooterEntity;
import com.hungteen.pvz.common.entity.plant.defence.WallNutEntity;
import com.hungteen.pvz.common.entity.plant.light.SunFlowerEntity;
import com.hungteen.pvz.common.structure.PVZTemplateComponent;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.StructureRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.StringUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class DaveVillaComponents {
    public static final BlockState BASE_BLOCK = Blocks.field_150346_d.func_176223_P();
    public static final ResourceLocation res1 = StringUtil.prefix("dave_villa/davevilla1");
    public static final ResourceLocation res2 = StringUtil.prefix("dave_villa/davevilla2");
    public static final ResourceLocation res3 = StringUtil.prefix("dave_villa/davevilla3");
    public static final ResourceLocation res4 = StringUtil.prefix("dave_villa/davevilla4");

    public static void generate(TemplateManager manager, BlockPos pos1, Rotation rotation, List<StructurePiece> list, Random rand) {
        BlockPos pos4;
        BlockPos pos3;
        BlockPos pos2;
        switch (rotation) {
            case CLOCKWISE_90: {
                pos2 = pos1.func_177982_a(0, 0, 32);
                pos3 = pos1.func_177982_a(-32, 0, 0);
                pos4 = pos2.func_177982_a(-32, 0, 0);
                break;
            }
            case CLOCKWISE_180: {
                pos2 = pos1.func_177982_a(-32, 0, 0);
                pos3 = pos1.func_177982_a(0, 0, -32);
                pos4 = pos2.func_177982_a(0, 0, -32);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                pos2 = pos1.func_177982_a(0, 0, -32);
                pos3 = pos1.func_177982_a(32, 0, 0);
                pos4 = pos2.func_177982_a(32, 0, 0);
                break;
            }
            default: {
                pos2 = pos1.func_177982_a(32, 0, 0);
                pos3 = pos1.func_177982_a(0, 0, 32);
                pos4 = pos2.func_177982_a(0, 0, 32);
            }
        }
        list.add((StructurePiece)new DaveVillaComponent(manager, res1, pos1, rotation));
        list.add((StructurePiece)new DaveVillaComponent(manager, res2, pos2, rotation));
        list.add((StructurePiece)new DaveVillaComponent(manager, res3, pos3, rotation));
        list.add((StructurePiece)new DaveVillaComponent(manager, res4, pos4, rotation));
    }

    public static class DaveVillaComponent
    extends PVZTemplateComponent {
        private static final IStructurePieceType type = StructureRegister.DAVE_VILLA_PIECE;

        public DaveVillaComponent(TemplateManager manager, CompoundNBT nbt) {
            super(type, manager, nbt);
        }

        public DaveVillaComponent(TemplateManager manager, ResourceLocation res, BlockPos pos, Rotation rotation) {
            super(type, manager, res, pos, rotation);
        }

        public BlockPos getBlockPos() {
            return this.field_186178_c;
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.res.toString());
            tagCompound.func_74778_a("Rot", this.field_186169_c.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("dave")) {
                CrazyDaveEntity dave = (CrazyDaveEntity)((EntityType)EntityRegister.CRAZY_DAVE.get()).func_200721_a((World)worldIn.func_201672_e());
                EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)dave, pos);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("panney")) {
                PennyEntity panney = (PennyEntity)((EntityType)EntityRegister.PANNEY.get()).func_200721_a((World)worldIn.func_201672_e());
                EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)panney, pos);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("plant_pos1")) {
                if (rand.nextInt(3) == 0) {
                    PeaShooterEntity nut = (PeaShooterEntity)((EntityType)EntityRegister.PEA_SHOOTER.get()).func_200721_a((World)worldIn.func_201672_e());
                    EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)nut, pos);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("plant_pos2")) {
                if (rand.nextInt(3) == 0) {
                    SunFlowerEntity nut = (SunFlowerEntity)((EntityType)EntityRegister.SUN_FLOWER.get()).func_200721_a((World)worldIn.func_201672_e());
                    EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)nut, pos);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("plant_pos3")) {
                if (rand.nextInt(3) == 0) {
                    PeaShooterEntity nut = (PeaShooterEntity)((EntityType)EntityRegister.PEA_SHOOTER.get()).func_200721_a((World)worldIn.func_201672_e());
                    EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)nut, pos);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("plant_pos4")) {
                if (rand.nextInt(2) == 0) {
                    WallNutEntity nut = (WallNutEntity)((EntityType)EntityRegister.WALL_NUT.get()).func_200721_a((World)worldIn.func_201672_e());
                    EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)nut, pos);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("plant_pos5")) {
                SunFlowerEntity nut = (SunFlowerEntity)((EntityType)EntityRegister.SUN_FLOWER.get()).func_200721_a((World)worldIn.func_201672_e());
                EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)nut, pos);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("plant_pos6")) {
                if (rand.nextInt(2) == 0) {
                    PeaShooterEntity nut = (PeaShooterEntity)((EntityType)EntityRegister.PEA_SHOOTER.get()).func_200721_a((World)worldIn.func_201672_e());
                    EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)nut, pos);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("bonus_chest1")) {
                this.func_191080_a(worldIn, sbb, rand, pos, PVZLoot.DAVE_VILLA_CHEST, null);
            } else if (function.equals("bonus_chest2")) {
                this.func_191080_a(worldIn, sbb, rand, pos, PVZLoot.DAVE_VILLA_CHEST, null);
            }
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager manager, ChunkGenerator chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn, BlockPos blockPos) {
            BlockPos pos = this.field_186178_c;
            BlockPos size = this.field_186176_a.func_186259_a();
            BlockPos ab = new BlockPos(0, size.func_177956_o(), 0);
            switch (this.field_186169_c) {
                case CLOCKWISE_90: {
                    ab = ab.func_177982_a(-size.func_177952_p(), 0, size.func_177958_n());
                    break;
                }
                case CLOCKWISE_180: {
                    ab = ab.func_177982_a(-size.func_177958_n(), 0, -size.func_177952_p());
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    ab = ab.func_177982_a(size.func_177952_p(), 0, -size.func_177958_n());
                    break;
                }
                default: {
                    ab = ab.func_177982_a(size.func_177958_n(), 0, size.func_177952_p());
                }
            }
            BlockPos to = pos.func_177982_a(ab.func_177958_n(), ab.func_177956_o(), ab.func_177952_p());
            BlockPos min = new BlockPos(Math.min(pos.func_177958_n(), to.func_177958_n()), Math.min(pos.func_177956_o(), to.func_177956_o()), Math.min(pos.func_177952_p(), to.func_177952_p()));
            BlockPos max = new BlockPos(Math.max(pos.func_177958_n(), to.func_177958_n()), Math.max(pos.func_177956_o(), to.func_177956_o()), Math.max(pos.func_177952_p(), to.func_177952_p()));
            super.func_230383_a_(worldIn, manager, chunkGeneratorIn, randomIn, mutableBoundingBoxIn, chunkPosIn, blockPos);
            for (int i = min.func_177958_n(); i <= max.func_177958_n(); ++i) {
                for (int j = min.func_177952_p(); j <= max.func_177952_p(); ++j) {
                    BlockPos tmp;
                    for (int y = min.func_177956_o() - 1; y >= 50 && !worldIn.func_180495_p(tmp = new BlockPos(i, y, j)).func_200132_m(); --y) {
                        worldIn.func_180501_a(tmp, BASE_BLOCK, 3);
                    }
                }
            }
            return true;
        }
    }
}

