/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.structure.zombie;

import com.hungteen.pvz.common.entity.zombie.grassnight.TombStoneEntity;
import com.hungteen.pvz.common.structure.PVZTemplateComponent;
import com.hungteen.pvz.data.loot.PVZLoot;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.register.StructureRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.StringUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class GraveHouseComponents {
    public static final ResourceLocation res = StringUtil.prefix("zombie_house/graveyard");

    public static void generate(TemplateManager manager, BlockPos pos1, Rotation rotation, List<StructurePiece> list, Random rand) {
        list.add((StructurePiece)new GraveHouseComponent(manager, res, pos1, rotation));
    }

    public static class GraveHouseComponent
    extends PVZTemplateComponent {
        private static final IStructurePieceType type = StructureRegister.GRAVE_HOUSE_PIECE;

        public GraveHouseComponent(TemplateManager manager, CompoundNBT nbt) {
            super(type, manager, nbt);
        }

        public GraveHouseComponent(TemplateManager manager, ResourceLocation res, BlockPos pos, Rotation rotation) {
            super(type, manager, res, pos, rotation);
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn, BlockPos blockPos) {
            int dx = 15;
            int dz = 15;
            switch (this.field_186169_c) {
                case CLOCKWISE_90: {
                    dx = -15;
                    break;
                }
                case CLOCKWISE_180: {
                    dz = -15;
                    dx = -15;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    dz = -15;
                    break;
                }
            }
            int x = this.field_186178_c.func_177958_n();
            int z = this.field_186178_c.func_177952_p();
            int h1 = chunkGeneratorIn.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            int h2 = chunkGeneratorIn.func_222531_c(x + dx, z, Heightmap.Type.WORLD_SURFACE_WG);
            int h3 = chunkGeneratorIn.func_222531_c(x, z + dz, Heightmap.Type.WORLD_SURFACE_WG);
            int h4 = chunkGeneratorIn.func_222531_c(x + dx, z + dz, Heightmap.Type.WORLD_SURFACE_WG);
            int height = Math.min(Math.min(h1, h2), Math.min(h3, h4));
            this.field_186178_c = new BlockPos(x, height, z);
            return super.func_230383_a_(worldIn, p_230383_2_, chunkGeneratorIn, randomIn, mutableBoundingBoxIn, chunkPosIn, blockPos);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("bonus_chest1")) {
                this.func_191080_a(worldIn, sbb, rand, pos, PVZLoot.GRAVE_YARD_CHEST, null);
            } else if (function.equals("bonus_chest2")) {
                this.func_191080_a(worldIn, sbb, rand, pos, PVZLoot.GRAVE_YARD_CHEST, null);
            } else if (function.equals("spawner")) {
                worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)te).func_145881_a().func_200876_a(this.getRandomEntityType(rand));
                }
            } else if (function.startsWith("tomb") && rand.nextInt(3) == 0) {
                TombStoneEntity tomb = (TombStoneEntity)((EntityType)EntityRegister.TOMB_STONE.get()).func_200721_a((World)worldIn.func_201672_e());
                EntityUtil.onEntitySpawn((IWorld)worldIn, (Entity)tomb, pos);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }

        protected EntityType<?> getRandomEntityType(Random rand) {
            int num = rand.nextInt(2);
            if (num == 0) {
                return (EntityType)EntityRegister.GIGA_FOOTBALL_ZOMBIE.get();
            }
            if (num == 1) {
                return (EntityType)EntityRegister.FOOTBALL_ZOMBIE.get();
            }
            return null;
        }
    }
}

