/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.tileentity;

import com.hungteen.pvz.common.container.FragmentSpliceContainer;
import com.hungteen.pvz.common.item.card.PlantCardItem;
import com.hungteen.pvz.common.item.tool.SunStorageSaplingItem;
import com.hungteen.pvz.register.TileEntityRegister;
import com.hungteen.pvz.utils.PlantUtil;
import com.hungteen.pvz.utils.enums.Essences;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Ranks;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemStackHandler;

public class FragmentSpliceTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int MAX_SUN_AMOUNT = 1000;
    public static final int CRAFT_COST = 1000;
    private static final int[] FRAGMENT_ARRAY = new int[]{8, 9, 10, 13, 15, 18, 19, 20};
    public final ItemStackHandler handler = new ItemStackHandler(27);
    public IIntArray array = new IntArray(2);
    public int sunAmount = 0;

    public FragmentSpliceTileEntity() {
        super((TileEntityType)TileEntityRegister.FRAGMENT_SPLICE.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.absorbSunAmount();
            this.array.func_221477_a(0, this.sunAmount);
            this.array.func_221477_a(1, this.getResultPlantId());
        }
    }

    public void setResult(int id) {
        this.sunAmount -= 1000;
        for (int i = 2; i < 27; ++i) {
            this.handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.handler.setStackInSlot(1, new ItemStack((IItemProvider)PlantUtil.getPlantSummonCard(Plants.values()[id])));
    }

    private int getResultPlantId() {
        HashSet<PlantCardItem> set = new HashSet<PlantCardItem>();
        for (int i = 0; i < FRAGMENT_ARRAY.length; ++i) {
            int pos = FRAGMENT_ARRAY[i];
            ItemStack stack = this.handler.getStackInSlot(pos);
            if (!(stack.func_77973_b() instanceof PlantCardItem) || !((PlantCardItem)stack.func_77973_b()).isEnjoyCard) {
                return -1;
            }
            set.add((PlantCardItem)stack.func_77973_b());
        }
        if (set.size() != 1) {
            return -1;
        }
        Plants plant = ((PlantCardItem)((Object)set.iterator().next())).plantType;
        Essences essence = PlantUtil.getPlantEssenceType(plant);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                int now;
                ItemStack stack;
                if (i != 0 && i != 4 && j != 0 && j != 4 || (stack = this.handler.getStackInSlot(now = 2 + i * 5 + j)).func_77973_b().equals(Essences.getEssenceItem(essence).get())) continue;
                return -1;
            }
        }
        Ranks rank = PlantUtil.getPlantRankByName(plant);
        ItemStack stack = this.handler.getStackInSlot(14);
        if (!stack.func_77973_b().equals(Ranks.getRankCardItem(rank))) {
            return -1;
        }
        return plant.ordinal();
    }

    private void absorbSunAmount() {
        ItemStack stack = this.handler.getStackInSlot(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof SunStorageSaplingItem) {
            int amount = SunStorageSaplingItem.getStorageSunAmount(stack);
            int decAmount = Math.min(1000 - this.sunAmount, Math.min(25, amount));
            this.sunAmount += decAmount;
            SunStorageSaplingItem.setStorageSunAmount(stack, amount -= decAmount);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.handler.deserializeNBT(compound.func_74775_l("itemstack_list"));
        this.sunAmount = compound.func_74762_e("sun_amount");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("itemstack_list", (INBT)this.handler.serializeNBT());
        compound.func_74768_a("sun_amount", this.sunAmount);
        return super.func_189515_b(compound);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new FragmentSpliceContainer(id, player, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.pvz.fragment_splice");
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }
}

