/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.common.world.data;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.common.cache.InvasionCache;
import com.hungteen.pvz.utils.enums.InvasionEvents;
import com.hungteen.pvz.utils.enums.Plants;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.HashSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class PVZInvasionData
extends WorldSavedData {
    private static final String DATA_NAME = "WorldEventData";
    private HashSet<InvasionEvents> events = new HashSet(InvasionEvents.values().length);
    private HashSet<Zombies> zombies = new HashSet(Zombies.values().length);
    private HashSet<Plants> plants = new HashSet(Plants.values().length);
    private boolean changed = false;
    private int countDownDay = 0;
    private int currentDifficulty = 0;

    public PVZInvasionData() {
        super(DATA_NAME);
    }

    public PVZInvasionData(String name) {
        super(name);
    }

    public boolean hasZombieSpawnEntry(Zombies zombie) {
        return this.zombies.contains((Object)zombie);
    }

    public void addZombieSpawnEntry(Zombies zombie) {
        this.zombies.add(zombie);
        this.func_76185_a();
    }

    public void removeZombieSpawnEntry(Zombies zombie) {
        this.zombies.remove((Object)zombie);
        this.func_76185_a();
    }

    public boolean hasPlantSpawnEntry(Plants plant) {
        return this.plants.contains((Object)plant);
    }

    public void addPlantSpawnEntry(Plants plant) {
        this.plants.add(plant);
        this.func_76185_a();
    }

    public void removePlantSpawnEntry(Plants plant) {
        this.plants.remove((Object)plant);
        this.func_76185_a();
    }

    public boolean hasEvent(InvasionEvents ev) {
        return this.events.contains((Object)ev);
    }

    public void addEvent(InvasionEvents ev) {
        this.events.add(ev);
        this.func_76185_a();
    }

    public void removeEvent(InvasionEvents ev) {
        this.events.remove((Object)ev);
        this.func_76185_a();
    }

    public void setChanged(boolean is) {
        this.changed = is;
        this.func_76185_a();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setCountDownDay(int day) {
        this.countDownDay = day;
        this.func_76185_a();
    }

    public void decCountDownDay() {
        this.countDownDay = this.countDownDay <= 0 ? (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.WorldInvasionSettings.InvasionIntervalLength.get() : --this.countDownDay;
        this.func_76185_a();
    }

    public int getCountDownDay() {
        return this.countDownDay;
    }

    public boolean hasCountDownDay() {
        return this.getCountDownDay() > 0;
    }

    public void setCurrentDifficulty(int dif) {
        InvasionCache.InvasionDifficulty = this.currentDifficulty = Math.max(0, dif);
        this.func_76185_a();
    }

    public void addCurrentDifficulty(int dif) {
        InvasionCache.InvasionDifficulty = this.currentDifficulty = Math.max(0, this.currentDifficulty + dif);
        this.func_76185_a();
    }

    public int getCurrentDifficulty() {
        return this.currentDifficulty;
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT list2;
        this.events.clear();
        ListNBT list = (ListNBT)nbt.func_74781_a("event");
        if (list != null) {
            for (INBT tmp : list) {
                CompoundNBT tag = (CompoundNBT)tmp;
                this.events.add(InvasionEvents.values()[tag.func_74762_e("id")]);
            }
        }
        this.zombies.clear();
        if (nbt.func_74764_b("zombie_spawn_entries")) {
            list2 = nbt.func_74775_l("zombie_spawn_entries");
            for (Enum enum_ : Zombies.values()) {
                if (!list2.func_74764_b("type_" + enum_.toString()) || !list2.func_74767_n("type_" + enum_.toString())) continue;
                this.addZombieSpawnEntry((Zombies)enum_);
            }
        }
        this.plants.clear();
        if (nbt.func_74764_b("plant_spawn_entries")) {
            list2 = nbt.func_74775_l("plant_spawn_entries");
            for (Enum enum_ : Plants.values()) {
                if (!list2.func_74764_b("type_" + enum_.toString()) || !list2.func_74767_n("type_" + enum_.toString())) continue;
                this.addPlantSpawnEntry((Plants)enum_);
            }
        }
        this.changed = nbt.func_74767_n("changed");
        this.countDownDay = nbt.func_74762_e("count_down_day");
        this.currentDifficulty = nbt.func_74762_e("pvz_current_difficulty");
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        this.events.stream().forEach(event -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("id", event.ordinal());
            list.add((Object)tag);
        });
        nbt.func_218657_a("event", (INBT)list);
        CompoundNBT list2 = new CompoundNBT();
        for (Zombies zombie : Zombies.values()) {
            list2.func_74757_a("type_" + zombie.toString(), this.hasZombieSpawnEntry(zombie));
        }
        nbt.func_218657_a("zombie_spawn_entries", (INBT)list2);
        CompoundNBT list3 = new CompoundNBT();
        for (Plants plant : Plants.values()) {
            list3.func_74757_a("type_" + plant.toString(), this.hasPlantSpawnEntry(plant));
        }
        nbt.func_218657_a("plant_spawn_entries", (INBT)list3);
        nbt.func_74757_a("changed", this.changed);
        nbt.func_74768_a("count_down_day", this.countDownDay);
        nbt.func_74768_a("pvz_current_difficulty", this.currentDifficulty);
        return nbt;
    }

    public static PVZInvasionData getOverWorldInvasionData(World worldIn) {
        if (!(worldIn instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerWorld world = worldIn.func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = world.func_217481_x();
        return (PVZInvasionData)storage.func_215752_a(PVZInvasionData::new, DATA_NAME);
    }
}

