/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.compat.jade.provider;

import com.hungteen.pvz.api.interfaces.IHasOwner;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.compat.jade.JadeRegister;
import com.hungteen.pvz.utils.EntityUtil;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import snownee.jade.Jade;

public class PVZEntityProvider
implements IEntityComponentProvider {
    public static final PVZEntityProvider INSTANCE = new PVZEntityProvider();

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get(JadeRegister.CONFIG_SHOW_DEFENCE_HEALTH)) {
            this.appendDefenceHealth(accessor.getEntity(), tooltip);
        }
        if (accessor.getPlayer().func_213283_Z() == Pose.CROUCHING) {
            if (config.get(JadeRegister.CONFIG_SHOW_OWNER)) {
                this.appendOwner(accessor.getWorld(), accessor.getEntity(), tooltip);
            }
            if (config.get(JadeRegister.CONFIG_SHOW_LEVEL)) {
                this.appendLevel(accessor.getEntity(), tooltip);
            }
            if (config.get(JadeRegister.CONFIG_SHOW_ZOMBIE_REDUCTION)) {
                this.appendZombieHurtReduction(accessor.getEntity(), tooltip);
            }
        }
    }

    private void appendOwner(World world, Entity entity, List<ITextComponent> tooltip) {
        if (!(entity instanceof IHasOwner)) {
            return;
        }
        ((IHasOwner)entity).getOwnerUUID().ifPresent(uuid -> Optional.ofNullable(world.func_217371_b(uuid)).ifPresent(player -> tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.owner").func_240702_b_(" : " + player.func_200200_C_().getString()).func_240699_a_(TextFormatting.GREEN))));
    }

    private void appendLevel(Entity entity, List<ITextComponent> tooltip) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        int lvl = EntityUtil.getEntityLevel((LivingEntity)entity);
        if (lvl == 0) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.level").func_240702_b_(" : " + lvl).func_240699_a_(TextFormatting.YELLOW));
    }

    private void appendDefenceHealth(Entity entity, List<ITextComponent> tooltip) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        float health = EntityUtil.getCurrentDefenceHealth((LivingEntity)entity);
        if (health == 0.0f) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.defence").func_240702_b_(" : " + String.format("%s", Jade.dfCommas.format(health))).func_240699_a_(TextFormatting.RED));
    }

    private void appendZombieHurtReduction(Entity entity, List<ITextComponent> tooltip) {
        if (!(entity instanceof PVZZombieEntity)) {
            return;
        }
        float percent = ((PVZZombieEntity)entity).getHurtReduction();
        if (percent == 1.0f) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pvz.reduction").func_240702_b_(" : " + Math.floor(100.0f * (1.0f - percent)) + "%").func_240699_a_(TextFormatting.GRAY));
    }
}

