/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.register;

import com.google.common.collect.ImmutableMap;
import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.common.structure.shop.DaveVillaComponents;
import com.hungteen.pvz.common.structure.shop.DaveVillaStructure;
import com.hungteen.pvz.common.structure.shop.SunTempleComponents;
import com.hungteen.pvz.common.structure.shop.SunTempleStructure;
import com.hungteen.pvz.common.structure.zombie.BucketHouseComponents;
import com.hungteen.pvz.common.structure.zombie.BucketHouseStructure;
import com.hungteen.pvz.common.structure.zombie.DolphinHouseComponents;
import com.hungteen.pvz.common.structure.zombie.DolphinHouseStructure;
import com.hungteen.pvz.common.structure.zombie.GraveHouseComponents;
import com.hungteen.pvz.common.structure.zombie.GraveHouseStructure;
import com.hungteen.pvz.common.structure.zombie.YetiHouseComponents;
import com.hungteen.pvz.common.structure.zombie.YetiHouseStructure;
import com.hungteen.pvz.register.BiomeRegister;
import com.hungteen.pvz.utils.BiomeUtil;
import com.hungteen.pvz.utils.StringUtil;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegister {
    public static final DeferredRegister<Structure<?>> STRUCTURE_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"pvz");
    public static final RegistryObject<Structure<NoFeatureConfig>> BUCKET_HOUSE = STRUCTURE_FEATURES.register("bucket_house", () -> new BucketHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static StructureFeature<?, ?> CONFIGURED_BUCKET_HOUSE;
    public static final RegistryObject<Structure<NoFeatureConfig>> DOLPHIN_HOUSE;
    public static StructureFeature<?, ?> CONFIGURED_DOLPHIN_HOUSE;
    public static final RegistryObject<Structure<NoFeatureConfig>> GRAVE_HOUSE;
    public static StructureFeature<?, ?> CONFIGURED_GRAVE_HOUSE;
    public static final RegistryObject<Structure<NoFeatureConfig>> YETI_HOUSE;
    public static StructureFeature<?, ?> CONFIGURED_YETI_HOUSE;
    public static final RegistryObject<Structure<NoFeatureConfig>> DAVE_VILLA;
    public static StructureFeature<?, ?> CONFIGURED_DAVE_VILLA;
    public static final RegistryObject<Structure<NoFeatureConfig>> SUN_TEMPLE;
    public static StructureFeature<?, ?> CONFIGURED_SUN_TEMPLE;
    public static IStructurePieceType DAVE_VILLA_PIECE;
    public static IStructurePieceType BUCKET_HOUSE_PIECE;
    public static IStructurePieceType DOLPHIN_HOUSE_PIECE;
    public static IStructurePieceType GRAVE_HOUSE_PIECE;
    public static IStructurePieceType SUN_TEMPLE_PIECE;
    public static IStructurePieceType YETI_HOUSE_PIECE;

    public static void addStructureToBiome(BiomeLoadingEvent event) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        if (biome == null || biome == BiomeRegister.ZEN_GARDEN.get()) {
            return;
        }
        RegistryKey<Biome> biomeKey = BiomeUtil.getKey(biome);
        if (BiomeUtil.isOverworld(biomeKey)) {
            if (BiomeUtil.isLand(biomeKey)) {
                event.getGeneration().func_242516_a(CONFIGURED_BUCKET_HOUSE);
                if (BiomeUtil.isSnowy(biomeKey)) {
                    event.getGeneration().func_242516_a(CONFIGURED_YETI_HOUSE);
                }
            }
            if (BiomeUtil.isDesert(biomeKey)) {
                event.getGeneration().func_242516_a(CONFIGURED_SUN_TEMPLE);
            }
            if (BiomeUtil.isOcean(biomeKey)) {
                event.getGeneration().func_242516_a(CONFIGURED_DOLPHIN_HOUSE);
            }
            if (BiomeUtil.isPlain(biomeKey)) {
                event.getGeneration().func_242516_a(CONFIGURED_DAVE_VILLA);
            }
            if (BiomeUtil.isConiferous(biomeKey)) {
                event.getGeneration().func_242516_a(CONFIGURED_GRAVE_HOUSE);
            }
        }
    }

    public static void setupStructures() {
        int dis = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.StructureSettings.BucketHouseDistance.get();
        StructureRegister.addStructure((Structure)BUCKET_HOUSE.get(), new StructureSeparationSettings(dis, dis / 2, 998244353));
        BUCKET_HOUSE_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"bucket_house", BucketHouseComponents.BucketHouseComponent::new);
        CONFIGURED_BUCKET_HOUSE = ((Structure)BUCKET_HOUSE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)StringUtil.prefix("configured_bucket_house"), CONFIGURED_BUCKET_HOUSE);
        FlatGenerationSettings.field_202247_j.put(BUCKET_HOUSE.get(), CONFIGURED_BUCKET_HOUSE);
        dis = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.StructureSettings.DolphinHouseDistance.get();
        StructureRegister.addStructure((Structure)DOLPHIN_HOUSE.get(), new StructureSeparationSettings(dis, dis / 2, 165745799));
        DOLPHIN_HOUSE_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"dolphin_house", DolphinHouseComponents.DolphinHouseComponent::new);
        CONFIGURED_DOLPHIN_HOUSE = ((Structure)DOLPHIN_HOUSE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)StringUtil.prefix("configured_dolphin_house"), CONFIGURED_DOLPHIN_HOUSE);
        FlatGenerationSettings.field_202247_j.put(DOLPHIN_HOUSE.get(), CONFIGURED_DOLPHIN_HOUSE);
        dis = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.StructureSettings.GraveHouseDistance.get();
        StructureRegister.addStructure((Structure)GRAVE_HOUSE.get(), new StructureSeparationSettings(dis, dis / 2, 165745797));
        GRAVE_HOUSE_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"grave_house", GraveHouseComponents.GraveHouseComponent::new);
        CONFIGURED_GRAVE_HOUSE = ((Structure)GRAVE_HOUSE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)StringUtil.prefix("configured_grave_house"), CONFIGURED_GRAVE_HOUSE);
        FlatGenerationSettings.field_202247_j.put(GRAVE_HOUSE.get(), CONFIGURED_GRAVE_HOUSE);
        dis = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.StructureSettings.YetiHouseDistance.get();
        StructureRegister.addStructure((Structure)YETI_HOUSE.get(), new StructureSeparationSettings(dis, dis / 2, 165745797));
        YETI_HOUSE_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"yeti_house", YetiHouseComponents.YetiHouseComponent::new);
        CONFIGURED_YETI_HOUSE = ((Structure)YETI_HOUSE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)StringUtil.prefix("configured_yeti_house"), CONFIGURED_YETI_HOUSE);
        FlatGenerationSettings.field_202247_j.put(YETI_HOUSE.get(), CONFIGURED_YETI_HOUSE);
        dis = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.StructureSettings.DaveVillaDistance.get();
        StructureRegister.addStructure((Structure)DAVE_VILLA.get(), new StructureSeparationSettings(dis, dis / 2, 165745797));
        DAVE_VILLA_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"dave_villa", DaveVillaComponents.DaveVillaComponent::new);
        CONFIGURED_DAVE_VILLA = ((Structure)DAVE_VILLA.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)StringUtil.prefix("configured_dave_villa"), CONFIGURED_DAVE_VILLA);
        FlatGenerationSettings.field_202247_j.put(DAVE_VILLA.get(), CONFIGURED_DAVE_VILLA);
        dis = (Integer)PVZConfig.COMMON_CONFIG.WorldSettings.StructureSettings.SunTempleDistance.get();
        StructureRegister.addStructure((Structure)SUN_TEMPLE.get(), new StructureSeparationSettings(dis, dis / 2, 165745797));
        SUN_TEMPLE_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"sun_temple", SunTempleComponents.SunTempleComponent::new);
        CONFIGURED_SUN_TEMPLE = ((Structure)SUN_TEMPLE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)StringUtil.prefix("configured_sun_temple"), CONFIGURED_SUN_TEMPLE);
        FlatGenerationSettings.field_202247_j.put(SUN_TEMPLE.get(), CONFIGURED_SUN_TEMPLE);
    }

    public static void addStructuresToMap(ServerWorld server, Map<Structure<?>, StructureSeparationSettings> tempMap) {
        Arrays.asList(BUCKET_HOUSE, DOLPHIN_HOUSE, GRAVE_HOUSE, YETI_HOUSE, DAVE_VILLA, SUN_TEMPLE).forEach(l -> tempMap.putIfAbsent((Structure<?>)l.get(), (StructureSeparationSettings)DimensionStructuresSettings.field_236191_b_.get((Object)l.get())));
    }

    public static <F extends Structure<NoFeatureConfig>> void addStructure(F structure, StructureSeparationSettings settings) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)settings).build();
    }

    static {
        DOLPHIN_HOUSE = STRUCTURE_FEATURES.register("dolphin_house", () -> new DolphinHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        GRAVE_HOUSE = STRUCTURE_FEATURES.register("grave_house", () -> new GraveHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        YETI_HOUSE = STRUCTURE_FEATURES.register("yeti_house", () -> new YetiHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        DAVE_VILLA = STRUCTURE_FEATURES.register("dave_villa", () -> new DaveVillaStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SUN_TEMPLE = STRUCTURE_FEATURES.register("sun_temple", () -> new SunTempleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    }
}

