/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils;

import com.hungteen.pvz.register.BiomeRegister;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeUtil {
    public static final Set<Biome> OVERWORLD_LAND = new HashSet<Biome>();
    public static final Set<Biome> OVERWORLD_DESERT = new HashSet<Biome>();
    public static final Set<Biome> OVERWORLD_OCEAN = new HashSet<Biome>();
    public static final Set<Biome> OVERWORLD_PLAIN = new HashSet<Biome>();
    public static final Set<Biome> OVERWORLD_CONIFEROUS = new HashSet<Biome>();
    public static final Set<Biome> OVERWORLD_SNOW_LAND = new HashSet<Biome>();
    public static final Set<Biome> NETHER = new HashSet<Biome>();
    public static final Set<Biome> THE_END = new HashSet<Biome>();
    public static final Method GET_SKY_COLOR_WITH_TEMPERATURE_MODIFIER = ObfuscationReflectionHelper.findMethod(BiomeMaker.class, (String)"func_244206_a", (Class[])new Class[]{Float.TYPE});

    public static void initBiomeSet() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome == BiomeRegister.ZEN_GARDEN.get()) continue;
            RegistryKey<Biome> biomeKey = BiomeUtil.getKey(biome);
            if (BiomeUtil.isOverworld(biomeKey)) {
                if (BiomeUtil.isLand(biomeKey)) {
                    OVERWORLD_LAND.add(biome);
                    if (BiomeUtil.isSnowy(biomeKey)) {
                        OVERWORLD_SNOW_LAND.add(biome);
                    }
                }
                if (BiomeUtil.isDesert(biomeKey)) {
                    OVERWORLD_DESERT.add(biome);
                }
                if (BiomeUtil.isOcean(biomeKey)) {
                    OVERWORLD_OCEAN.add(biome);
                }
                if (BiomeUtil.isPlain(biomeKey)) {
                    OVERWORLD_PLAIN.add(biome);
                }
                if (BiomeUtil.isConiferous(biomeKey)) {
                    OVERWORLD_CONIFEROUS.add(biome);
                }
            }
            if (BiomeUtil.isNether(biomeKey)) {
                NETHER.add(biome);
            }
            if (!BiomeUtil.isTheEnd(biomeKey)) continue;
            THE_END.add(biome);
        }
    }

    public static boolean isLand(RegistryKey<Biome> biomeKey) {
        return !BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.WATER);
    }

    public static boolean isOcean(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
    }

    public static boolean isDesert(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
    }

    public static boolean isPlain(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
    }

    public static boolean isConiferous(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS);
    }

    public static boolean isSnowy(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
    }

    public static boolean isOverworld(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD);
    }

    public static boolean isNether(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    public static boolean isTheEnd(RegistryKey<Biome> biomeKey) {
        return BiomeDictionary.hasType(biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.END);
    }

    public static int getSkyColor(float temp) {
        int skyColour;
        try {
            skyColour = (Integer)GET_SKY_COLOR_WITH_TEMPERATURE_MODIFIER.invoke(null, Float.valueOf(temp));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error: Unable to get sky colour", e);
        }
        return skyColour;
    }

    public static RegistryKey<Biome> getKey(Biome biome) {
        return RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome), "Biome registry name was null"));
    }
}

