/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils;

import com.hungteen.pvz.api.enums.PVZGroupType;
import com.hungteen.pvz.api.interfaces.ICanBeCharmed;
import com.hungteen.pvz.api.interfaces.IGroupEntity;
import com.hungteen.pvz.api.interfaces.IHasOwner;
import com.hungteen.pvz.api.interfaces.IPVZPlant;
import com.hungteen.pvz.api.interfaces.IPVZZombie;
import com.hungteen.pvz.common.entity.PVZMultiPartEntity;
import com.hungteen.pvz.common.entity.plant.PVZPlantEntity;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.common.entity.zombie.poolnight.BalloonZombieEntity;
import com.hungteen.pvz.common.network.PVZPacketHandler;
import com.hungteen.pvz.common.network.SpawnParticlePacket;
import com.hungteen.pvz.register.EffectRegister;
import com.hungteen.pvz.utils.ConfigUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.PlayerUtil;
import com.hungteen.pvz.utils.WorldUtil;
import com.hungteen.pvz.utils.enums.Zombies;
import com.hungteen.pvz.utils.interfaces.IMultiPartEntity;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.Team;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityUtil {
    public static final Random RAND = new Random();
    public static final float LIMITED_DAMAGE = 100.0f;

    public static Vector3d getNormalisedVector2d(@Nonnull Entity a, @Nonnull Entity b) {
        double dx = b.func_226277_ct_() - a.func_226277_ct_();
        double dz = b.func_226281_cx_() - a.func_226281_cx_();
        double dis = Math.sqrt(dx * dx + dz * dz);
        return new Vector3d(dx / dis, 0.0, dz / dis);
    }

    public static boolean canEntityBeRemoved(Entity entity) {
        if (entity instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)entity).canZombieBeRemoved();
        }
        if (!entity.func_200600_R().getRegistryName().func_110624_b().equals("pvz") && entity instanceof LivingEntity) {
            return ((LivingEntity)entity).func_110138_aP() > 100.0f;
        }
        return true;
    }

    public static boolean canHelpAttackOthers(@Nonnull Entity entity) {
        if (entity instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)entity).canHelpAttack();
        }
        if (entity instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)entity).canHelpAttack();
        }
        return true;
    }

    public static void spawnParticle(Entity entity, int type) {
        PVZPacketHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 40.0, entity.field_70170_p.func_234923_W_())), (Object)new SpawnParticlePacket(type, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()));
    }

    public static void spawnStaticParticle(Entity entity, IParticleData type) {
        EntityUtil.spawnSpeedParticle(entity, type, 0.0f);
    }

    public static void spawnSpeedParticle(Entity entity, IParticleData type, float speed) {
        WorldUtil.spawnRandomSpeedParticle(entity.field_70170_p, type, entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_213302_cg(), 0.0), speed);
    }

    public static boolean canDestroyBlock(World world, BlockPos pos, Entity entity) {
        return EntityUtil.canDestroyBlock(world, pos, world.func_180495_p(pos), entity);
    }

    public static void playSound(Entity entity, SoundEvent ev) {
        if (ev != null) {
            entity.func_184185_a(ev, 1.0f, RAND.nextFloat() * 0.2f + 0.9f);
        }
    }

    public static boolean isEntityValid(Entity target) {
        return target != null && target.func_70089_S();
    }

    public static List<LivingEntity> getRandomLivingInRange(World world, LivingEntity attacker, AxisAlignedBB aabb, int cnt) {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (LivingEntity living : EntityUtil.getTargetableLivings((Entity)attacker, aabb)) {
            list.add(living);
            if (--cnt > 0) continue;
            break;
        }
        return list;
    }

    public static float getCurrentHealth(LivingEntity target) {
        if (target instanceof IPVZZombie) {
            return ((IPVZZombie)target).getCurrentHealth();
        }
        if (target instanceof IPVZPlant) {
            return ((IPVZPlant)target).getCurrentHealth();
        }
        return target.func_110143_aJ();
    }

    public static float getCurrentDefenceHealth(LivingEntity entity) {
        return EntityUtil.getCurrentHealth(entity) - entity.func_110143_aJ();
    }

    public static float getCurrentMaxHealth(LivingEntity target) {
        if (target instanceof IPVZZombie) {
            return ((IPVZZombie)target).getCurrentMaxHealth();
        }
        if (target instanceof IPVZPlant) {
            return ((IPVZPlant)target).getCurrentMaxHealth();
        }
        return target.func_110138_aP();
    }

    public static float getMaxHealthDamage(LivingEntity target) {
        return EntityUtil.getMaxHealthDamage(target, 1.0f);
    }

    public static float getMaxHealthDamage(LivingEntity target, float multiple) {
        return EntityUtil.getCurrentMaxHealth(target) * multiple;
    }

    public static boolean isEntityBoss(@Nonnull LivingEntity entity) {
        if (entity instanceof IPVZZombie) {
            Zombies zombie = ((IPVZZombie)entity).getZombieEnumName();
            return Zombies.BOSSES.contains((Object)zombie);
        }
        if (entity instanceof IPVZPlant) {
            return false;
        }
        return entity.func_110143_aJ() > 100.0f;
    }

    public static int getEntityLevel(LivingEntity entity) {
        if (entity instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)entity).getZombieLevel();
        }
        if (entity instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)entity).getPlantLvl();
        }
        return 0;
    }

    public static boolean canSeeEntity(Entity entity, Entity target) {
        Vector3d start = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        Vector3d lowerEnd = target.func_213303_ch();
        Vector3d upperEnd = lowerEnd.func_72441_c(0.0, (double)target.func_213302_cg(), 0.0);
        RayTraceContext ray1 = new RayTraceContext(start, lowerEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        RayTraceContext ray2 = new RayTraceContext(start, upperEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        return entity.field_70170_p.func_217299_a(ray1).func_216346_c() != RayTraceResult.Type.BLOCK || entity.field_70170_p.func_217299_a(ray2).func_216346_c() != RayTraceResult.Type.BLOCK;
    }

    public static boolean canEntityPass(Entity entity, Vector3d vec, float length) {
        Vector3d lowStart = entity.func_213303_ch();
        Vector3d upperStart = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_213302_cg(), 0.0);
        Vector3d lowerEnd = lowStart.func_178787_e(vec.func_186678_a((double)length));
        Vector3d upperEnd = upperStart.func_178787_e(vec.func_186678_a((double)length));
        RayTraceContext ray1 = new RayTraceContext(lowStart, lowerEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        RayTraceContext ray2 = new RayTraceContext(upperStart, upperEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity);
        return entity.field_70170_p.func_217299_a(ray1).func_216346_c() != RayTraceResult.Type.BLOCK && entity.field_70170_p.func_217299_a(ray2).func_216346_c() != RayTraceResult.Type.BLOCK;
    }

    public static boolean canDestroyBlock(World world, BlockPos pos, BlockState state, Entity entity) {
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.func_177230_c().isAir(state, (IBlockReader)world, pos) && state.func_177230_c().canEntityDestroy(state, (IBlockReader)world, pos, entity) && (!(entity instanceof LivingEntity) || ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)entity), (BlockPos)pos, (BlockState)state));
    }

    public static void createEntityAndSpawn(World world, EntityType<?> type, BlockPos pos) {
        Entity entity = type.func_200721_a(world);
        EntityUtil.onEntitySpawn((IWorld)world, entity, pos);
    }

    public static void onEntitySpawn(IWorld world, Entity entity, BlockPos pos) {
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_213386_a((IServerWorld)world, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
        }
        world.func_217376_c(entity);
    }

    public static void onMobEntityRandomPosSpawn(IWorld world, MobEntity entity, BlockPos pos, int dis) {
        pos = pos.func_177982_a(MathUtil.getRandomInRange(entity.func_70681_au(), dis), entity.func_70681_au().nextInt(dis) + 1, MathUtil.getRandomInRange(entity.func_70681_au(), dis));
        EntityUtil.onEntitySpawn(world, (Entity)entity, pos);
    }

    public static boolean isOnGround(Entity entity) {
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        return !entity.field_70170_p.func_175623_d(pos) && entity.func_226278_cu_() - (double)pos.func_177956_o() <= 1.00001;
    }

    public static boolean isOnSnow(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        return entity.field_70170_p.func_180495_p(pos).func_203425_a(Blocks.field_150433_aE) || entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196604_cC);
    }

    public static boolean isOnIce(Entity entity) {
        BlockPos pos = entity.func_233580_cy_();
        return entity.field_70170_p.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_205213_E) || entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_205213_E);
    }

    public static boolean isSuitableTargetInRange(MobEntity entity, @Nonnull LivingEntity target, double range) {
        return entity.func_70068_e((Entity)target) > EntityUtil.getAttackRange((Entity)entity, (Entity)target, range) && EntityUtil.canTargetEntity((Entity)entity, (Entity)target);
    }

    public static double getAttackRange(Entity a, Entity b, double r) {
        double two = Math.sqrt(2.0);
        double dis = (double)a.func_213311_cf() / two + (double)b.func_213311_cf() / two + r;
        return dis * dis;
    }

    public static double getNearestDistance(Entity a, Entity b) {
        double dx = a.func_226277_ct_() - b.func_226277_ct_();
        double dz = a.func_226281_cx_() - b.func_226281_cx_();
        double dy = 0.0;
        if (a.func_226278_cu_() > b.func_226278_cu_() + (double)b.func_213302_cg()) {
            dy = a.func_226278_cu_() - b.func_226278_cu_() - (double)b.func_213302_cg();
        } else if (b.func_226278_cu_() > a.func_226278_cu_() + (double)a.func_213302_cg()) {
            dy = b.func_226278_cu_() - a.func_226278_cu_() - (double)a.func_213302_cg();
        }
        return dx * dx + dy * dy + dz * dz;
    }

    @Nullable
    public static PlayerEntity getEntityOwner(World world, @Nullable Entity entity) {
        UUID uuid = null;
        if (entity instanceof IHasOwner) {
            uuid = ((IHasOwner)entity).getOwnerUUID().orElse(null);
        }
        return uuid == null ? null : world.func_217371_b(uuid);
    }

    public static boolean canTargetEntity(Entity attacker, Entity target) {
        if (attacker instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)attacker).checkCanZombieTarget(target);
        }
        if (attacker instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)attacker).checkCanPlantTarget(target);
        }
        return EntityUtil.checkCanEntityBeTarget(attacker, target);
    }

    public static boolean canAttackEntity(Entity attacker, Entity target) {
        if (attacker instanceof PVZZombieEntity) {
            return ((PVZZombieEntity)attacker).checkCanZombieAttack(target);
        }
        if (attacker instanceof PVZPlantEntity) {
            return ((PVZPlantEntity)attacker).checkCanPlantAttack(target);
        }
        return EntityUtil.checkCanEntityBeAttack(attacker, target);
    }

    public static boolean checkCanEntityBeTarget(Entity attacker, Entity target) {
        if (!EntityUtil.isEntityValid(attacker) || !EntityUtil.isEntityValid(target)) {
            return false;
        }
        if (target instanceof PVZMultiPartEntity) {
            return EntityUtil.checkCanEntityBeTarget(attacker, (Entity)((PVZMultiPartEntity)target).getOwner());
        }
        if (target instanceof PlayerEntity && !PlayerUtil.isPlayerSurvival((PlayerEntity)target)) {
            return false;
        }
        if (ConfigUtil.isTeamAttackEnable()) {
            Team team1 = EntityUtil.getEntityTeam(attacker.field_70170_p, attacker);
            Team team2 = EntityUtil.getEntityTeam(attacker.field_70170_p, target);
            if (team1 != null && team2 != null) {
                boolean change = EntityUtil.isEntityCharmed(attacker) ^ EntityUtil.isEntityCharmed(target);
                return change ? team1.func_142054_a(team2) : !team1.func_142054_a(team2);
            }
        }
        if (attacker instanceof LivingEntity && target.func_70028_i((Entity)((LivingEntity)attacker).func_110144_aD()) && EntityUtil.checkCanEntityBeAttack(attacker, target)) {
            return true;
        }
        return PVZGroupType.checkCanTarget(EntityUtil.getEntityGroup(attacker), EntityUtil.getEntityGroup(target));
    }

    public static boolean checkCanEntityBeAttack(Entity attacker, Entity target) {
        if (!EntityUtil.isEntityValid(attacker) || !EntityUtil.isEntityValid(target)) {
            return false;
        }
        if (target instanceof PVZMultiPartEntity) {
            return EntityUtil.checkCanEntityBeAttack(attacker, (Entity)((PVZMultiPartEntity)target).getOwner());
        }
        if (target instanceof PlayerEntity && !PlayerUtil.isPlayerSurvival((PlayerEntity)target)) {
            return false;
        }
        if (ConfigUtil.isTeamAttackEnable()) {
            Team team1 = EntityUtil.getEntityTeam(attacker.field_70170_p, attacker);
            Team team2 = EntityUtil.getEntityTeam(attacker.field_70170_p, target);
            if (team1 != null && team2 != null) {
                boolean change = EntityUtil.isEntityCharmed(attacker) ^ EntityUtil.isEntityCharmed(target);
                return change ? team1.func_142054_a(team2) : !team1.func_142054_a(team2);
            }
        }
        return PVZGroupType.checkCanAttack(EntityUtil.getEntityGroup(attacker), EntityUtil.getEntityGroup(target));
    }

    public static PVZGroupType getEntityGroup(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            return PlayerUtil.getPlayerGroupType((ServerPlayerEntity)entity);
        }
        if (entity instanceof PVZMultiPartEntity) {
            return EntityUtil.getEntityGroup((Entity)((PVZMultiPartEntity)entity).getOwner());
        }
        if (entity instanceof IGroupEntity) {
            return ((IGroupEntity)entity).getEntityGroupType();
        }
        if (PVZGroupType.isOtherMonsters(entity)) {
            return PVZGroupType.OTHER_MONSTERS;
        }
        if (PVZGroupType.isOtherGuards(entity)) {
            return PVZGroupType.OTHER_GURADS;
        }
        return PVZGroupType.CREATURES;
    }

    @Nullable
    public static Team getEntityTeam(World world, Entity entity) {
        if (entity instanceof PlayerEntity) {
            return entity.func_96124_cp();
        }
        if (entity instanceof IHasOwner && ((IHasOwner)entity).getOwnerUUID().isPresent()) {
            PlayerEntity player = world.func_217371_b(((IHasOwner)entity).getOwnerUUID().get());
            return player == null ? null : player.func_96124_cp();
        }
        return entity.func_96124_cp();
    }

    public static boolean isEntityCharmed(Entity entity) {
        if (entity instanceof ICanBeCharmed) {
            return ((ICanBeCharmed)entity).isCharmed();
        }
        return false;
    }

    public static List<LivingEntity> getTargetableLivings(@Nonnull Entity attacker, AxisAlignedBB aabb) {
        return EntityUtil.getPredicateEntities(attacker, aabb, LivingEntity.class, target -> EntityUtil.canTargetEntity(attacker, (Entity)target));
    }

    public static List<LivingEntity> getViewableTargetableEntity(@Nonnull Entity attacker, AxisAlignedBB aabb) {
        return EntityUtil.getTargetableLivings(attacker, aabb).stream().filter(target -> EntityUtil.canSeeEntity(attacker, (Entity)target)).collect(Collectors.toList());
    }

    public static List<Entity> getTargetableEntities(@Nonnull Entity attacker, AxisAlignedBB aabb) {
        return EntityUtil.getPredicateEntities(attacker, aabb, Entity.class, target -> EntityUtil.canTargetEntity(attacker, target));
    }

    public static List<LivingEntity> getFriendlyLivings(@Nonnull Entity attacker, AxisAlignedBB aabb) {
        return EntityUtil.getPredicateEntities(attacker, aabb, LivingEntity.class, target -> !EntityUtil.canAttackEntity(attacker, (Entity)target));
    }

    private static List<Entity> getTargetableEntitiesIngoreCheck(@Nonnull Entity attacker, AxisAlignedBB aabb) {
        return EntityUtil.getPredicateEntities(attacker, aabb, Entity.class, target -> EntityUtil.checkCanEntityBeTarget(attacker, target));
    }

    private static <T extends Entity> List<T> getPredicateEntities(@Nonnull Entity attacker, AxisAlignedBB aabb, Class<T> tClass, Predicate<T> predicate) {
        if (attacker == null) {
            return new ArrayList();
        }
        return attacker.field_70170_p.func_217357_a(tClass, aabb).stream().filter(target -> !attacker.equals(target) && predicate.test(target)).collect(Collectors.toList());
    }

    public static List<Entity> getWholeTargetableEntities(@Nonnull Entity attacker, AxisAlignedBB aabb) {
        IntOpenHashSet set = new IntOpenHashSet();
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (attacker == null) {
            return list;
        }
        List<Entity> targets = EntityUtil.getTargetableEntitiesIngoreCheck(attacker, aabb);
        targets.stream().filter(target -> !(target instanceof PVZMultiPartEntity) && !set.contains(target.func_145782_y())).forEach(target -> {
            set.addAll(EntityUtil.getOwnerAndPartsID(target));
            list.add((Entity)target);
        });
        targets.stream().filter(target -> target instanceof PVZMultiPartEntity && !set.contains(target.func_145782_y())).forEach(target -> {
            set.addAll(EntityUtil.getOwnerAndPartsID(target));
            list.add((Entity)target);
        });
        return list;
    }

    public static List<Integer> getOwnerAndPartsID(Entity entity) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (entity instanceof PVZMultiPartEntity) {
            LivingEntity owner = ((PVZMultiPartEntity)entity).getOwner();
            if (owner == null) {
                list.add(entity.func_145782_y());
            } else {
                IMultiPartEntity parent = ((PVZMultiPartEntity)entity).getParent();
                for (PVZMultiPartEntity target : parent.getMultiParts()) {
                    if (target == null) continue;
                    list.add(target.func_145782_y());
                }
                list.add(owner.func_145782_y());
            }
        } else if (entity instanceof IMultiPartEntity) {
            for (PVZMultiPartEntity target : ((IMultiPartEntity)entity).getMultiParts()) {
                if (target == null) continue;
                list.add(target.func_145782_y());
            }
            list.add(entity.func_145782_y());
        } else {
            list.add(entity.func_145782_y());
        }
        return list;
    }

    public static void addPotionEffect(Entity entity, EffectInstance effect) {
        if (entity instanceof PVZMultiPartEntity) {
            EntityUtil.addPotionEffect((Entity)((PVZMultiPartEntity)entity).getOwner(), effect);
        } else if (entity instanceof PVZZombieEntity) {
            ((PVZZombieEntity)entity).checkAndAddPotionEffect(effect);
        } else if (entity instanceof PVZPlantEntity) {
            ((PVZPlantEntity)entity).checkAndAddPotionEffect(effect);
        } else if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(effect);
        }
    }

    public static boolean isEntityCold(LivingEntity entity) {
        return entity.func_110148_a(Attributes.field_233821_d_).func_111127_a(EffectRegister.COLD_EFFECT_UUID) != null;
    }

    public static boolean isEntityFrozen(LivingEntity entity) {
        return entity.func_110148_a(Attributes.field_233821_d_).func_111127_a(EffectRegister.FROZEN_EFFECT_UUID) != null;
    }

    public static boolean isEntityButter(LivingEntity entity) {
        return entity.func_110148_a(Attributes.field_233821_d_).func_111127_a(EffectRegister.BUTTER_EFFECT_UUID) != null;
    }

    public static boolean isEntityInSky(Entity entity) {
        if (entity instanceof FlyingEntity || entity instanceof BatEntity) {
            return true;
        }
        if (entity instanceof BalloonZombieEntity && ((BalloonZombieEntity)entity).hasBalloon()) {
            return true;
        }
        return !entity.func_233570_aj_() && !entity.func_70090_H() && !entity.func_180799_ab();
    }

    public static void setLivingMaxHealthAndHeal(LivingEntity living, float maxHealth) {
        living.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)maxHealth);
        living.func_70691_i(maxHealth);
    }

    public static EntityRayTraceResult rayTraceEntities(World world, Entity entity, Vector3d startVec, Vector3d endVec, Predicate<Entity> predicate) {
        return ProjectileHelper.func_221269_a((World)world, (Entity)entity, (Vector3d)startVec, (Vector3d)endVec, (AxisAlignedBB)entity.func_174813_aQ().func_216361_a(entity.func_213322_ci()).func_186662_g(1.0), predicate);
    }

    public static AxisAlignedBB getEntityAABB(Entity entity, double w, double h) {
        return new AxisAlignedBB(entity.func_226277_ct_() - w, entity.func_226278_cu_() - h, entity.func_226281_cx_() - w, entity.func_226277_ct_() + w, entity.func_226278_cu_() + h, entity.func_226281_cx_() + w);
    }
}

