/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils;

import com.hungteen.pvz.utils.MathUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class WorldUtil {
    public static BlockPos getSuitableHeightRandomPos(World world, BlockPos pos, int minR, int maxR) {
        BlockPos offset = MathUtil.getRandomRangePos(world.field_73012_v, minR, maxR);
        return WorldUtil.getSuitableHeightPos(world, pos.func_177982_a(offset.func_177958_n(), 0, offset.func_177952_p()));
    }

    public static BlockPos getSuitableHeightRandomPos(World world, BlockPos pos, int maxR) {
        return WorldUtil.getSuitableHeightRandomPos(world, pos, 0, maxR);
    }

    public static BlockPos getSuitableHeightPos(World world, BlockPos pos) {
        int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos.func_177958_n(), pos.func_177952_p());
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    public static void spawnRandomSpeedParticle(World world, IParticleData type, Vector3d pos, float speed) {
        WorldUtil.spawnRandomSpeedParticle(world, type, pos, speed, speed);
    }

    public static void spawnRandomSpeedParticle(World world, IParticleData type, Vector3d pos, float horizontalSpeed, float verticalSpeed) {
        float speedX = (world.field_73012_v.nextFloat() - 0.5f) * horizontalSpeed * 2.0f;
        float speedY = (world.field_73012_v.nextFloat() - 0.5f) * verticalSpeed * 2.0f;
        float speedZ = (world.field_73012_v.nextFloat() - 0.5f) * horizontalSpeed * 2.0f;
        world.func_195594_a(type, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)speedX, (double)speedY, (double)speedZ);
    }

    public static int calculateGenHeight(IWorld worldIn, int x, int z) {
        int y = worldIn.func_217301_I();
        boolean foundGround = false;
        while (!foundGround && y-- >= worldIn.func_181545_F() - 1) {
            foundGround = worldIn.func_180495_p(new BlockPos(x, y, z)).func_200132_m();
        }
        return y;
    }
}

