/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils;

import com.hungteen.pvz.PVZConfig;
import com.hungteen.pvz.PVZMod;
import com.hungteen.pvz.common.cache.InvasionCache;
import com.hungteen.pvz.common.entity.zombie.PVZZombieEntity;
import com.hungteen.pvz.register.EntityRegister;
import com.hungteen.pvz.utils.EntityUtil;
import com.hungteen.pvz.utils.MathUtil;
import com.hungteen.pvz.utils.enums.Ranks;
import com.hungteen.pvz.utils.enums.Zombies;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class ZombieUtil {
    public static final float WALK_SUPER_SLOW = 0.15f;
    public static final float WALK_HUGE_SLOW = 0.16f;
    public static final float WALK_VERY_SLOW = 0.17f;
    public static final float WALK_SLOW = 0.18f;
    public static final float WALK_LITTLE_SLOW = 0.19f;
    public static final float WALK_NORMAL = 0.2f;
    public static final float WALK_LITTLE_FAST = 0.225f;
    public static final float WALK_FAST = 0.25f;
    public static final float WALK_VERY_FAST = 0.275f;
    public static final float WALK_HUGE_FAST = 0.3f;
    public static final float WALK_SUPER_FAST = 0.325f;
    public static final float WATER_FAST = 0.8f;
    public static final float FLY_FAST = 0.5f;
    public static final float VERY_LOW = 4.0f;
    public static final float LOW = 6.0f;
    public static final float LITTLE_LOW = 8.0f;
    public static final float NORMAL_DAMAGE = 10.0f;
    public static final float LITTLE_HIGH = 20.0f;
    public static final float HIGH = 30.0f;
    public static final float VERY_HIGH = 50.0f;
    public static final float HUGE_HIGH = 100.0f;
    public static final float SUPER_HIGH = 200.0f;
    public static final float GIANT_HIT = 1000.0f;
    public static final float BOSS_HIT = 2000.0f;
    public static final float NORMAL_FOLLOW_RANGE = 50.0f;
    public static final float CLOSE_TARGET_RANGE = 40.0f;
    public static final float LITTLE_CLOSE_TARGET_RANGE = 50.0f;
    public static final float NORMAL_TARGET_RANGE = 60.0f;
    public static final float LITTLE_FAR_TARGET_RANGE = 70.0f;
    public static final float LOW_TARGET_HEIGHT = 20.0f;
    public static final float NORMAL_TARGET_HEIGHT = 30.0f;
    public static final float LITTLE_HIGH_TARGET_HEIGHT = 40.0f;
    public static final float HIGH_TARGET_HEIGHT = 50.0f;
    public static final HashMap<Zombies, Ranks> ZOMBIE_RANK = new HashMap();
    public static final HashMap<EntityType<? extends PVZZombieEntity>, Zombies> ENTITY_TYPE_ZOMBIE = new HashMap();
    public static final HashMap<Zombies, RegistryObject<? extends EntityType<? extends PVZZombieEntity>>> ZOMBIE_ENTITY = new HashMap();
    public static final int MAX_ZOMBIE_LEVEL = 20;
    public static int ZOMBIE_NUM = 0;

    public static void initZombieMap() {
        for (Zombies zombie : Zombies.values()) {
            EntityType<? extends PVZZombieEntity> type = ZombieUtil.getZombieEntityType(zombie);
            ENTITY_TYPE_ZOMBIE.put(type, zombie);
        }
    }

    public static void putZombieInfoToMap(Zombies zombie, Ranks rank, RegistryObject<? extends EntityType<? extends PVZZombieEntity>> type) {
        ZOMBIE_RANK.put(zombie, rank);
        ZOMBIE_ENTITY.put(zombie, type);
        ++ZOMBIE_NUM;
    }

    public static PVZZombieEntity getZombieEntity(World world, Zombies zombie) {
        if (ZOMBIE_ENTITY.containsKey((Object)zombie)) {
            return (PVZZombieEntity)((EntityType)ZOMBIE_ENTITY.get((Object)zombie).get()).func_200721_a(world);
        }
        PVZMod.LOGGER.debug("Zombie get entity error");
        return null;
    }

    public static EntityType<? extends PVZZombieEntity> getZombieEntityType(Zombies zombie) {
        if (ZOMBIE_ENTITY.containsKey((Object)zombie)) {
            return (EntityType)ZOMBIE_ENTITY.get((Object)zombie).get();
        }
        System.out.println("Zombie get entity error");
        return null;
    }

    public static Ranks getZombieRank(Zombies zombie) {
        if (ZOMBIE_RANK.containsKey((Object)zombie)) {
            return ZOMBIE_RANK.get((Object)zombie);
        }
        PVZMod.LOGGER.debug("Zombie get rank error");
        return null;
    }

    public static int getZombieXp(Zombies zombie) {
        Ranks rank = ZombieUtil.getZombieRank(zombie);
        switch (rank) {
            case GRAY: {
                return 1;
            }
            case WHITE: {
                return 2;
            }
            case GREEN: {
                return 3;
            }
            case BLUE: {
                return 5;
            }
            case PURPLE: {
                return 8;
            }
            case GOLD: {
                return 15;
            }
            case MEGA: {
                return 50;
            }
        }
        return 0;
    }

    public static void copySummonZombieData(PVZZombieEntity old, PVZZombieEntity now) {
        now.setCharmed(old.isCharmed());
        now.setMiniZombie(old.isMiniZombie());
    }

    public static void onZombieSpawn(PVZZombieEntity old, PVZZombieEntity now, BlockPos pos) {
        ZombieUtil.copySummonZombieData(old, now);
        EntityUtil.onEntitySpawn((IWorld)old.field_70170_p, (Entity)now, pos);
    }

    public static Optional<Zombies> getZombieNameByType(EntityType<? extends PVZZombieEntity> zombieType) {
        return Optional.ofNullable(ENTITY_TYPE_ZOMBIE.get(zombieType));
    }

    public static int caculateZombieLevel(PVZZombieEntity zombie) {
        int difficulty = InvasionCache.getInvasionDifficulty() - 100;
        int maxLevel = (Integer)PVZConfig.COMMON_CONFIG.EntitySettings.ZombieSetting.ZombieMaxLevel.get();
        int minLvl = MathHelper.func_76125_a((int)(difficulty / 50 + 1), (int)1, (int)maxLevel);
        int maxLvl = MathHelper.func_76125_a((int)(difficulty / 30 + 2), (int)1, (int)maxLevel);
        return MathUtil.getRandomMinMax(zombie.func_70681_au(), minLvl, maxLvl);
    }

    public static int caculateZombieXp(PVZZombieEntity zombie) {
        int lvlBonus = zombie.getZombieLevel() / 2;
        int rankBonus = zombie.getZombieRank().ordinal() / 2;
        return rankBonus + lvlBonus + 3;
    }

    static {
        ZombieUtil.putZombieInfoToMap(Zombies.NORMAL_ZOMBIE, Ranks.WHITE, EntityRegister.NORMAL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.FLAG_ZOMBIE, Ranks.WHITE, EntityRegister.FLAG_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.CONEHEAD_ZOMBIE, Ranks.GREEN, EntityRegister.CONEHEAD_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.POLE_ZOMBIE, Ranks.GREEN, EntityRegister.POLE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BUCKETHEAD_ZOMBIE, Ranks.BLUE, EntityRegister.BUCKETHEAD_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.NEWSPAPER_ZOMBIE, Ranks.WHITE, EntityRegister.NEWSPAPER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.TOMB_STONE, Ranks.GRAY, EntityRegister.TOMB_STONE);
        ZombieUtil.putZombieInfoToMap(Zombies.SCREENDOOR_ZOMBIE, Ranks.WHITE, EntityRegister.SCREENDOOR_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.FOOTBALL_ZOMBIE, Ranks.BLUE, EntityRegister.FOOTBALL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.DANCING_ZOMBIE, Ranks.GREEN, EntityRegister.DANCING_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BACKUP_DANCER, Ranks.WHITE, EntityRegister.BACKUP_DANCER);
        ZombieUtil.putZombieInfoToMap(Zombies.GIGA_FOOTBALL_ZOMBIE, Ranks.GOLD, EntityRegister.GIGA_FOOTBALL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.OLD_ZOMBIE, Ranks.BLUE, EntityRegister.OLD_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.SUNDAY_EDITION_ZOMBIE, Ranks.GOLD, EntityRegister.SUNDAY_EDITION_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.COFFIN, Ranks.GOLD, EntityRegister.COFFIN);
        ZombieUtil.putZombieInfoToMap(Zombies.MOURNER_ZOMBIE, Ranks.GREEN, EntityRegister.MOURNER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.NOBLE_ZOMBIE, Ranks.MEGA, EntityRegister.NOBLE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.SNORKEL_ZOMBIE, Ranks.WHITE, EntityRegister.SNORKEL_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.ZOMBONI, Ranks.BLUE, EntityRegister.ZOMBONI);
        ZombieUtil.putZombieInfoToMap(Zombies.BOBSLE_TEAM, Ranks.GREEN, EntityRegister.BOBSLE_TEAM);
        ZombieUtil.putZombieInfoToMap(Zombies.BOBSLE_ZOMBIE, Ranks.WHITE, EntityRegister.BOBSLE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.DOLPHIN_RIDER, Ranks.GREEN, EntityRegister.DOLPHIN_RIDER);
        ZombieUtil.putZombieInfoToMap(Zombies.DOLPHIN_RIDER_ZOMBIE, Ranks.WHITE, EntityRegister.DOLPHIN_RIDER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.ZOMBIE_DOLPHIN, Ranks.GRAY, EntityRegister.ZOMBIE_DOLPHIN);
        ZombieUtil.putZombieInfoToMap(Zombies.LAVA_ZOMBIE, Ranks.PURPLE, EntityRegister.LAVA_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.JACK_IN_BOX_ZOMBIE, Ranks.GREEN, EntityRegister.JACK_IN_BOX_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BALLOON_ZOMBIE, Ranks.WHITE, EntityRegister.BALLOON_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.DIGGER_ZOMBIE, Ranks.GREEN, EntityRegister.DIGGER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.POGO_ZOMBIE, Ranks.GREEN, EntityRegister.POGO_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.YETI_ZOMBIE, Ranks.BLUE, EntityRegister.YETI_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.BUNGEE_ZOMBIE, Ranks.GREEN, EntityRegister.BUNGEE_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.LADDER_ZOMBIE, Ranks.GREEN, EntityRegister.LADDER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.CATAPULT_ZOMBIE, Ranks.BLUE, EntityRegister.CATAPULT_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.GARGANTUAR, Ranks.PURPLE, EntityRegister.GARGANTUAR);
        ZombieUtil.putZombieInfoToMap(Zombies.IMP, Ranks.GRAY, EntityRegister.IMP);
        ZombieUtil.putZombieInfoToMap(Zombies.SAD_GARGANTUAR, Ranks.GOLD, EntityRegister.SAD_GARGANTUAR);
        ZombieUtil.putZombieInfoToMap(Zombies.ZOMBOSS, Ranks.MEGA, EntityRegister.ZOMBOSS);
        ZombieUtil.putZombieInfoToMap(Zombies.PEASHOOTER_ZOMBIE, Ranks.WHITE, EntityRegister.PEASHOOTER_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.WALLNUT_ZOMBIE, Ranks.BLUE, EntityRegister.WALLNUT_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.GATLINGPEA_ZOMBIE, Ranks.WHITE, EntityRegister.GATLINGPEA_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.TALLNUT_ZOMBIE, Ranks.PURPLE, EntityRegister.TALLNUT_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.SQUASH_ZOMBIE, Ranks.WHITE, EntityRegister.SQUASH_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.JALAPENO_ZOMBIE, Ranks.GREEN, EntityRegister.JALAPENO_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.PUMPKIN_ZOMBIE, Ranks.PURPLE, EntityRegister.PUMPKIN_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.TRICK_ZOMBIE, Ranks.GRAY, EntityRegister.TRICK_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.RA_ZOMBIE, Ranks.WHITE, EntityRegister.RA_ZOMBIE);
        ZombieUtil.putZombieInfoToMap(Zombies.GIGA_TOMB_STONE, Ranks.GRAY, EntityRegister.GIGA_TOMB_STONE);
    }
}

