/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils.enums;

import com.hungteen.pvz.utils.others.WeightList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.text.TranslationTextComponent;

public enum Zombies {
    NORMAL_ZOMBIE(0, 10, 5),
    FLAG_ZOMBIE(0, 0, 0),
    CONEHEAD_ZOMBIE(2, 5, 5),
    POLE_ZOMBIE(5, 4, 4),
    BUCKETHEAD_ZOMBIE(8, 3, 3),
    TOMB_STONE(0, 0, 0),
    NEWSPAPER_ZOMBIE(2, 7, 5),
    OLD_ZOMBIE(5, 5, 4),
    SUNDAY_EDITION_ZOMBIE(24, 2, 1),
    SCREENDOOR_ZOMBIE(3, 5, 4),
    FOOTBALL_ZOMBIE(9, 3, 2),
    GIGA_FOOTBALL_ZOMBIE(20, 2, 2),
    DANCING_ZOMBIE(12, 1, 2),
    BACKUP_DANCER(0, 0, 0),
    SNORKEL_ZOMBIE(1, 4, 4),
    ZOMBONI(6, 4, 3),
    BOBSLE_TEAM(7, 0, 1),
    BOBSLE_ZOMBIE(0, 0, 0),
    ZOMBIE_DOLPHIN(0, 0, 0),
    DOLPHIN_RIDER(10, 0, 0),
    DOLPHIN_RIDER_ZOMBIE(0, 0, 0),
    LAVA_ZOMBIE(16, 2, 2),
    JACK_IN_BOX_ZOMBIE(6, 4, 3),
    BALLOON_ZOMBIE(10, 4, 3),
    DIGGER_ZOMBIE(15, 3, 3),
    POGO_ZOMBIE(3, 3, 3),
    YETI_ZOMBIE(0, 0, 0),
    BUNGEE_ZOMBIE(6, 3, 2),
    LADDER_ZOMBIE(3, 4, 3),
    CATAPULT_ZOMBIE(12, 4, 3),
    GARGANTUAR(20, 2, 2),
    IMP(0, 5, 2),
    SAD_GARGANTUAR(30, 1, 1),
    ZOMBOSS(0, 0, 0),
    PEASHOOTER_ZOMBIE(0, 4, 2),
    WALLNUT_ZOMBIE(0, 3, 2),
    GATLINGPEA_ZOMBIE(0, 2, 2),
    TALLNUT_ZOMBIE(0, 2, 2),
    SQUASH_ZOMBIE(0, 2, 2),
    JALAPENO_ZOMBIE(0, 2, 2),
    PUMPKIN_ZOMBIE(6, 4, 1),
    TRICK_ZOMBIE(1, 6, 1),
    COFFIN(0, 0, 0),
    MOURNER_ZOMBIE(0, 0, 0),
    NOBLE_ZOMBIE(0, 0, 0),
    RA_ZOMBIE(0, 5, 0),
    GIGA_TOMB_STONE(0, 0, 0);

    public static final WeightList<Zombies> ZOMBIE_SPAWN_LIST;
    public static final List<Zombies> DEFAULT_ZOMBIES;
    public static final Set<Zombies> BOSSES;
    public final int difficulty;
    public final int spawnWeight;
    public final int chooseWeight;

    private Zombies(int day, int weight, int choose) {
        this.difficulty = 2 * day;
        this.spawnWeight = weight;
        this.chooseWeight = choose;
    }

    public static Zombies getZombieByName(String name) {
        for (Zombies zombie : Zombies.values()) {
            if (!name.equals(zombie.toString().toLowerCase())) continue;
            return zombie;
        }
        return null;
    }

    public TranslationTextComponent getText() {
        return new TranslationTextComponent("entity.pvz." + this.toString().toLowerCase());
    }

    static {
        ZOMBIE_SPAWN_LIST = new WeightList();
        DEFAULT_ZOMBIES = Arrays.asList(NORMAL_ZOMBIE, CONEHEAD_ZOMBIE, BUCKETHEAD_ZOMBIE, SCREENDOOR_ZOMBIE, NEWSPAPER_ZOMBIE);
        BOSSES = new HashSet<Zombies>(Arrays.asList(ZOMBOSS, COFFIN, NOBLE_ZOMBIE));
        int sum = 0;
        for (Zombies zombie : Zombies.values()) {
            if (zombie.chooseWeight <= 0) continue;
            ZOMBIE_SPAWN_LIST.addItem(zombie, zombie.chooseWeight);
            sum += zombie.chooseWeight;
        }
        ZOMBIE_SPAWN_LIST.setTotal(sum);
    }
}

