/*
 * Decompiled with CFR 0.152.
 */
package com.hungteen.pvz.utils.others;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class WeightList<T> {
    private final List<T> itemList = new ArrayList<T>();
    private final List<Integer> weightList = new ArrayList<Integer>();
    private Optional<T> leftItem = Optional.empty();
    private int tot;
    private int sum = 0;

    public WeightList() {
    }

    public WeightList(int tot) {
        this.tot = tot;
    }

    public WeightList<T> addItem(T item, int w) {
        this.itemList.add(item);
        this.weightList.add(w);
        this.sum += w;
        return this;
    }

    public WeightList<T> setLeftItem(T item) {
        this.leftItem = Optional.ofNullable(item);
        return this;
    }

    public WeightList<T> setTotal(int tot) {
        this.tot = tot;
        return this;
    }

    public int getTotal() {
        return this.tot;
    }

    public Optional<T> getRandomItem(Random rand) {
        int now = 0;
        int pos = rand.nextInt(this.tot);
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (pos >= (now += this.weightList.get(i).intValue())) continue;
            return Optional.of(this.itemList.get(i));
        }
        return this.leftItem;
    }

    @SafeVarargs
    public static <W> WeightList<W> of(int tot, Pair<W, Integer> ... pairs) {
        WeightList<Object> list = new WeightList<Object>(tot);
        for (Pair<W, Integer> p : pairs) {
            list.addItem(p.getFirst(), (Integer)p.getSecond());
        }
        return list;
    }

    @SafeVarargs
    public static <W> WeightList<W> of(Pair<W, Integer> ... pairs) {
        WeightList<Object> list = new WeightList<Object>();
        int sum = 0;
        for (Pair<W, Integer> p : pairs) {
            list.addItem(p.getFirst(), (Integer)p.getSecond());
            sum += ((Integer)p.getSecond()).intValue();
        }
        return list.setTotal(sum);
    }
}

