/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.realisticbees.events;

import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.SpawnEntityFunctions;
import com.natamus.collective.functions.StringFunctions;
import com.natamus.realisticbees.config.ConfigHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BeeEvent {
    private static HashMap<Player, Integer> stung_players = new HashMap();
    private static HashMap<Player, Date> last_sting_player = new HashMap();
    private static HashMap<LivingEntity, Vec3> stingerless_bees = new HashMap();

    @SubscribeEvent
    public static void onBeeSpawn(EntityJoinWorldEvent e) {
        Level world = e.getWorld();
        if (world.f_46443_) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Bee)) {
            return;
        }
        Set tags = entity.m_19880_();
        if (tags.contains("realisticbees.ignorebee")) {
            return;
        }
        entity.m_20049_("realisticbees.ignorebee");
        BlockPos entitypos = entity.m_142538_();
        if (!world.m_7232_(Mth.m_14143_((float)entitypos.m_123341_()) >> 4, Mth.m_14143_((float)entitypos.m_123343_()) >> 4)) {
            return;
        }
        int extrabees = (Integer)ConfigHandler.GENERAL.extraBeeSpawnsPerBee.get();
        if (extrabees == 0) {
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        Vec3 beevec = entity.m_20182_();
        List playersaround = world.m_45976_(Player.class, new AABB(beevec.f_82479_ - 5.0, beevec.f_82480_ - 5.0, beevec.f_82481_ - 5.0, beevec.f_82479_ + 5.0, beevec.f_82480_ + 5.0, beevec.f_82481_ + 5.0));
        if (playersaround.size() > 0) {
            return;
        }
        ServerLevel serverworld = (ServerLevel)world;
        for (int i = 0; i < extrabees; ++i) {
            Bee newbee = (Bee)EntityType.f_20550_.m_20615_(world);
            newbee.f_19853_ = world;
            newbee.m_6034_(beevec.f_82479_, beevec.f_82480_, beevec.f_82481_);
            newbee.m_20049_("realisticbees.ignorebee");
            SpawnEntityFunctions.spawnEntityOnNextTick((ServerLevel)serverworld, (Entity)newbee);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent e) {
        Entity entity = e.getEntity();
        Level world = entity.f_19853_;
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (stung_players.containsKey(player)) {
            stung_players.remove(player);
        }
    }

    @SubscribeEvent
    public static void onEntityDamageTaken(LivingHurtEvent e) {
        Entity target = e.getEntity();
        Level world = target.m_20193_();
        if (world.f_46443_) {
            return;
        }
        Entity truesource = e.getSource().m_7639_();
        if (!(truesource instanceof Bee)) {
            return;
        }
        boolean targetisplayer = false;
        if (target instanceof Player) {
            targetisplayer = true;
        }
        if (!((Boolean)ConfigHandler.GENERAL.beesDieFromStingingPlayer.get()).booleanValue() && targetisplayer) {
            return;
        }
        if (!((Boolean)ConfigHandler.GENERAL.beesDieFromStingingMob.get()).booleanValue() && !targetisplayer) {
            return;
        }
        Double chance = GlobalVariables.random.nextDouble();
        if (chance > (Double)ConfigHandler.GENERAL.chanceBeeLeavesItsStinger.get()) {
            return;
        }
        EntityFunctions.addPotionEffect((Entity)truesource, (MobEffect)MobEffects.f_19590_, (Integer)((Integer)ConfigHandler.GENERAL.timeInSecondsBeeWithoutStingerDies.get() * 1000));
        if (targetisplayer) {
            Player player = (Player)target;
            int timesstung = 1;
            if (stung_players.containsKey(player)) {
                timesstung = stung_players.get(player) + 1;
            }
            Object times = "";
            if (timesstung > 1) {
                times = " " + timesstung + " times";
            }
            Date now = new Date();
            last_sting_player.put(player, now);
            stung_players.put(player, timesstung);
            if (((Boolean)ConfigHandler.GENERAL.sendStungPlayerWithStingerAMessage.get()).booleanValue()) {
                StringFunctions.sendMessage((Player)player, (String)("You have been stung" + (String)times + " with the stinger left behind! You can try and get it out by using some shears as pliers."), (ChatFormatting)ChatFormatting.YELLOW);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        Entity entity = e.getEntity();
        Level world = entity.m_20193_();
        if (world.f_46443_) {
            return;
        }
        if (entity instanceof Bee) {
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity le = (LivingEntity)entity;
            MobEffectInstance badluck = le.m_21124_(MobEffects.f_19590_);
            if (badluck == null) {
                return;
            }
            int ticksleft = badluck.m_19557_();
            if (ticksleft < 5) {
                stingerless_bees.remove(le);
                le.m_6469_(DamageSource.f_19313_, Float.MAX_VALUE);
                return;
            }
            Vec3 beevec = le.m_20182_();
            if (!stingerless_bees.containsKey(le)) {
                stingerless_bees.put(le, beevec);
                return;
            }
            Vec3 lastvec = stingerless_bees.get(le);
            le.m_6021_(lastvec.f_82479_, beevec.f_82480_, lastvec.f_82481_);
        } else if (entity instanceof Player) {
            LivingEntity le;
            MobEffectInstance poison;
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            Player player = (Player)entity;
            if (stung_players.containsKey(player) && (poison = (le = (LivingEntity)entity).m_21124_(MobEffects.f_19614_)) == null) {
                Date now = new Date();
                Date last_sting = last_sting_player.get(player);
                long ms = now.getTime() - last_sting.getTime();
                if (ms >= (long)((Integer)ConfigHandler.GENERAL.timeInSecondsStingerPumpsPoison.get() * 1000)) {
                    StringFunctions.sendMessage((Player)player, (String)"All stingers have stopped pumping poison.", (ChatFormatting)ChatFormatting.DARK_GREEN);
                    stung_players.remove(player);
                    return;
                }
                EntityFunctions.addPotionEffect((Entity)le, (MobEffect)MobEffects.f_19614_, (Integer)5000);
            }
        }
    }

    @SubscribeEvent
    public static void onStingerPull(PlayerInteractEvent.RightClickItem e) {
        Level world = e.getWorld();
        if (world.f_46443_) {
            return;
        }
        Player player = e.getPlayer();
        if (stung_players.containsKey(player)) {
            ItemStack hand = e.getItemStack();
            if (!(hand.m_41720_() instanceof ShearsItem)) {
                return;
            }
            Double chance = GlobalVariables.random.nextDouble();
            if (chance > (Double)ConfigHandler.GENERAL.chanceBeeStingerIsPulledOut.get()) {
                StringFunctions.sendMessage((Player)player, (String)"You failed to get the stinger out!", (ChatFormatting)ChatFormatting.YELLOW);
                return;
            }
            int timesstung = stung_players.get(player);
            int newamount = timesstung - 1;
            if (newamount == 0) {
                StringFunctions.sendMessage((Player)player, (String)"You successfully took all the stingers out.", (ChatFormatting)ChatFormatting.DARK_GREEN);
                stung_players.remove(player);
                return;
            }
            Object are = "is 1";
            if (newamount > 1) {
                are = "are " + newamount;
            }
            StringFunctions.sendMessage((Player)player, (String)("You took out a stinger! There " + (String)are + " left."), (ChatFormatting)ChatFormatting.YELLOW);
            stung_players.put(player, newamount);
        }
    }
}

