/*
 * Decompiled with CFR 0.152.
 */
package com.seriouscreeper.recall.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.seriouscreeper.recall.items.ItemRecall;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.BooleanValue PlaySounds;
    public static ForgeConfigSpec.BooleanValue EmitParticles;
    public static ForgeConfigSpec.BooleanValue AllowCrossDimension;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        COMMON_BUILDER.comment("General settings").push("general");
        PlaySounds = COMMON_BUILDER.comment("Play sounds when using item").define("soundsEnabled", true);
        EmitParticles = COMMON_BUILDER.comment("Emit particles when using item").define("particlesEnabled", true);
        AllowCrossDimension = COMMON_BUILDER.comment("Allow to teleport across dimensions").define("allowCrossDimension", true);
        ItemRecall.MaxDamage = COMMON_BUILDER.comment("Set max durability of item").defineInRange("durability", 50, 1, Integer.MAX_VALUE);
        ItemRecall.MaxDuration = COMMON_BUILDER.comment("How long it should take to use the item").defineInRange("casttime", 100, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

