/*
 * Decompiled with CFR 0.152.
 */
package com.seriouscreeper.recall.items;

import com.seriouscreeper.recall.config.Config;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.LogicalSidedProvider;

public class ItemRecall
extends Item {
    public static ForgeConfigSpec.IntValue MaxDamage;
    public static ForgeConfigSpec.IntValue MaxDuration;

    public ItemRecall() {
        super(new Item.Properties().m_41503_(((Integer)MaxDamage.get()).intValue()).m_41491_(CreativeModeTab.f_40756_));
        this.setRegistryName("item_recall");
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == Items.f_42415_ || super.m_6832_(toRepair, repair);
    }

    public int m_6473_() {
        return 10;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entity) {
        if (!worldIn.f_46443_) {
            ServerPlayer player = (ServerPlayer)entity;
            BlockPos bedLocation = player.m_8961_();
            if (bedLocation == null) {
                player.m_6352_((Component)new TranslatableComponent("chat.recall.nobed"), player.m_142081_());
                return stack;
            }
            if (!((Boolean)Config.AllowCrossDimension.get()).booleanValue() && player.f_19853_.m_46472_() != Level.f_46428_) {
                player.m_6352_((Component)new TranslatableComponent("chat.recall.dimension"), player.m_142081_());
                return stack;
            }
            double distance = entity.m_20275_((double)bedLocation.m_123341_(), (double)bedLocation.m_123342_(), (double)bedLocation.m_123343_());
            if (((Boolean)Config.PlaySounds.get()).booleanValue() && distance > 24.0) {
                worldIn.m_6263_(null, (double)player.m_142538_().m_123341_(), (double)player.m_142538_().m_123342_(), (double)player.m_142538_().m_123343_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 0.75f, 0.75f);
            }
            entity.m_8127_();
            if (player.f_19853_.m_46472_() != player.m_8963_()) {
                MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
                ServerLevel transferWorld = server.m_129880_(player.m_8963_());
                player.m_8999_(transferWorld, (double)bedLocation.m_123341_() + 0.5, (double)bedLocation.m_123342_() + 0.6, (double)bedLocation.m_123343_() + 0.5, player.m_20155_().f_82470_, player.m_20155_().f_82471_);
            } else {
                entity.m_6027_((double)bedLocation.m_123341_() + 0.5, (double)bedLocation.m_123342_() + 0.6, (double)bedLocation.m_123343_() + 0.5);
            }
            entity.f_19789_ = 0.0f;
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (((Boolean)Config.PlaySounds.get()).booleanValue()) {
                worldIn.m_6263_(null, (double)player.m_142538_().m_123341_(), (double)player.m_142538_().m_123342_(), (double)player.m_142538_().m_123343_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 0.75f, 0.75f);
            }
        }
        return stack;
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.m_41776_();
        if (damage >= maxDamage) {
            stack.m_41774_(1);
        }
        super.setDamage(stack, damage);
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        block4: {
            block3: {
                if (entity.f_19853_.f_46443_) break block3;
                if (!((Boolean)Config.PlaySounds.get()).booleanValue()) break block4;
                if (entity.f_20916_ > 0) {
                    entity.m_5810_();
                    entity.f_19853_.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (count >= (Integer)MaxDuration.get() - 10 || count % 20 != 0) break block4;
                entity.f_19853_.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, SoundEvents.f_11887_, SoundSource.PLAYERS, 0.05f + 0.4f * ItemRecall.clamp(80 - count, 1.0f, 80.0f) / 80.0f, 0.5f + (float)(1 - count / (Integer)MaxDuration.get()));
                break block4;
            }
            if (((Boolean)Config.EmitParticles.get()).booleanValue()) {
                Random rand = entity.f_19853_.f_46441_;
                for (int i = 0; i < 60; ++i) {
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)entity.m_142538_().m_123341_() + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 3.0, (double)((float)entity.m_142538_().m_123342_() + rand.nextFloat() * 4.0f - 2.0f), (double)entity.m_142538_().m_123343_() + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 3.0, 0.0, 0.2, 0.0);
                }
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return (Integer)MaxDuration.get();
    }
}

