/*
 * Decompiled with CFR 0.152.
 */
package com.seriouscreeper.recall.items;

import com.seriouscreeper.recall.config.Config;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class ItemRecall
extends Item {
    public static ForgeConfigSpec.IntValue MaxDamage;
    public static ForgeConfigSpec.IntValue MaxDuration;

    public ItemRecall() {
        super(new Item.Properties().func_200918_c(((Integer)MaxDamage.get()).intValue()).func_200916_a(ItemGroup.field_78040_i));
        this.setRegistryName("item_recall");
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77952_i() < stack.func_77958_k()) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entity) {
        if (!worldIn.field_72995_K && stack.func_77952_i() < stack.func_77958_k()) {
            BlockPos bedLocation;
            PlayerEntity player = (PlayerEntity)entity;
            BlockPos returnPos = bedLocation = player.getBedLocation(player.field_71093_bK);
            if (bedLocation == null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.recall.nobed", new Object[0]), true);
                return stack;
            }
            double distance = entity.func_70092_e((double)returnPos.func_177958_n(), (double)returnPos.func_177956_o(), (double)returnPos.func_177952_p());
            if (((Boolean)Config.PlaySounds.get()).booleanValue() && distance > 24.0) {
                worldIn.func_184148_a(null, (double)returnPos.func_177958_n(), (double)returnPos.func_177956_o(), (double)returnPos.func_177952_p(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.75f, 0.75f);
            }
            if (entity.func_184187_bx() != null) {
                entity.func_184210_p();
            }
            entity.func_70634_a((double)returnPos.func_177958_n(), (double)returnPos.func_177956_o(), (double)returnPos.func_177952_p());
            entity.field_70143_R = 0.0f;
            stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(p.func_184600_cs()));
            if (((Boolean)Config.PlaySounds.get()).booleanValue()) {
                worldIn.func_184148_a(null, (double)returnPos.func_177958_n(), (double)returnPos.func_177956_o(), (double)returnPos.func_177952_p(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.75f, 0.75f);
            }
        }
        return stack;
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage >= maxDamage) {
            stack.func_190918_g(1);
        }
        super.setDamage(stack, damage);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        block4: {
            block3: {
                if (entity.field_70170_p.field_72995_K) break block3;
                if (!((Boolean)Config.PlaySounds.get()).booleanValue()) break block4;
                if (entity.field_70737_aN > 0) {
                    entity.func_184597_cx();
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                if (count >= (Integer)MaxDuration.get() - 10 || count % 20 != 0) break block4;
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.05f + 0.4f * (float)MathHelper.func_76125_a((int)(80 - count), (int)1, (int)80) / 80.0f, 0.5f + (float)(1 - count / (Integer)MaxDuration.get()));
                break block4;
            }
            if (((Boolean)Config.EmitParticles.get()).booleanValue()) {
                Random rand = entity.field_70170_p.field_73012_v;
                for (int i = 0; i < 60; ++i) {
                    entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, entity.field_70165_t + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 3.0, entity.field_70163_u + (double)(rand.nextFloat() * 4.0f) - 2.0, entity.field_70161_v + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 3.0, 0.0, 0.2, 0.0);
                }
            }
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return (Integer)MaxDuration.get();
    }
}

