
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;

    float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
	float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

    float time = float(worldTime);

    float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a,1.0) * fading ;
	float sunvisibility2 = min(texture2D(gaux2,vec2(0.0)).a,1.0);
	float centerVisibility = 1.0 - clamp(distance(lightPos.xy, vec2(0.5, 0.5)) * 2.0, 0.0, 1.0);
		  centerVisibility *= sunvisibility;
	
	float lensBrightness = 1.2;
	
	
	// Fix, that the particles are visible on the moon position at daytime
	float truepos = sign(sunPosition.z);		//1 -> sun / -1 -> moon
	vec3 rainc = mix(vec3(1.),vec3(0.2,0.25,0.3),rainStrength);
	vec3 lightColor = mix(sunlight*sunVisibility*rainc,0.0*moonlight*moonVisibility*rainc,truepos*0.5+0.5);
	
	
	// Dirty Lens

                #ifdef DIRTY_LENS

		// Set up domain
		vec2 q = texcoord.xy + texcoord.x * 0.4;
		vec2 p = -1.0 + 3.0 * q;
		vec2 p2 = -1.0 + 3.0 * q + vec2(10.0, 10.0);
		vec2 p3 = -1.0 + 3.0 * q + vec2(1.0, 1.0);
		vec2 p4 = -1.0 + 3.0 * q + vec2(2.0, 2.0);
		
		// Create noise using fBm
		float f = fbm(3.0 * p);
		float f2 = fbm(37.0 * p2);
		float f3 = fbm(1.0 * p3);
		float f4 = fbm(3.0 * p4);
 	 
		float cover = 0.34f;
		float sharpness = 0.99 * sunvisibility2;	// Brightness
		
		float c = f - (1.0 - cover);
		if ( c < 0.0 )
			 c = 0.0;
		
		f = 1.0 - (pow(1.0 - sharpness, c));
				
				
		float c2 = f2 - (1.0 - cover);
		if ( c2 < 0.0 )
			 c2 = 0.0;
		
		f2 = 1.0 - (pow(1.0 - sharpness, c2));
				
				
		float c3 = f3 - (1.0 - cover);
		if ( c3 < 0.0 )
			 c3 = 0.0;
		
		f3 = 1.0 - (pow(1.0 - sharpness, c3));
				
							
		float c4 = f4 - (1.0 - cover);
		if ( c4 < 0.0 )
			 c4 = 0.0;
		
		f4 = 1.0 - (pow(1.0 - sharpness, c3));
				
		float dirtylens = (f * 2.0) + (f2 / 1) + (f3 * 4.0) + (f4 / 2);

	
		float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/0.8,0.1),2.0)-0.1,0.0);
		vec3 lenscolor = vec3(0.0);
		if (length(lightColor) > 0.001)	lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor);
		
		float lens_strength = 1.3 * lensBrightness;
		lenscolor *= lens_strength;
				
		color += (dirtylens*visibility)*lenscolor*(1.0-rainStrength*1.0)*2.;

#endif

	// End of Dirty Lens
		
	// Anamorphic Lens

	if (sunvisibility > 0.01) {

                #ifdef ANAMORPHIC_LENS
		
		float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/1.5,0.1),1.0)-0.1,0.0);
		
			
		vec3 lenscolor = length(lightColor)*vec3(1.0, 1.0, 1.0);

		float lens_strength = 0.00125 * lensBrightness;
		lenscolor *= lens_strength;
			
		float anamorphic_lens = max(pow(max(1.0 - yDistAxis(0.0)/1.4,0.1),10.0)-0.5,0.0);
		color += anamorphic_lens * lenscolor * visibility  * sunvisibility * (1.0-rainStrength*1.0);
	
	

	
		float dist = distance(texcoord.st, vec2(0.5, 0.5));
		

		
			visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/1.0,0.1),5.0)-0.1,0.0);
		lenscolor = vec3(0.0);	
			if (length(lightColor) > 0.001)	
		lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor);

			
			lens_strength = 0.7 * lensBrightness;
			lenscolor *= lens_strength;
			
			float sunray1 = max(pow(max(1.0 - yDistAxis(1.5)/0.7,0.1),10.0)-0.6,0.0);
			float sunray2 = max(pow(max(1.0 - yDistAxis(-1.3)/0.7,0.1),10.0)-0.6,0.0);
			float sunray3 = max(pow(max(1.0 - yDistAxis(5.0)/1.5,0.1),10.0)-0.6,0.0);
			float sunray4 = max(pow(max(1.0 - yDistAxis(-4.8)/1.5,0.1),10.0)-0.6,0.0);
			
			float sunrays = sunray1 + sunray2 + sunray3 + sunray4;
			
			color += lenscolor * sunrays * visibility * sunvisibility * (1.0-rainStrength*1.0)*2.;

#endif

		// Sun Glow
					
		if (length(lightColor) > 0.001)
		lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor)*vec3(0.7,0.75,1.);
			
		lens_strength = 0.0 * lensBrightness;
		lenscolor *= lens_strength;
			
		float lensFlare = max(pow(max(1.0 - smoothCircleDist(1.0)/2.4,0.1),5.0)-0.1,0.0);
			
		color += lensFlare * lenscolor * sunvisibility2 * (1.0-rainStrength*1.0);
		
				// Circle Lens 1
		
		
			lenscolor =  vec3(2.52, 1.2, 0.4) * lightColor;
			
			lens_strength = 0.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			float lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.15, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			float lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.2, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			float lensFlare3 = max(pow(max(1.0 - cirlceDist(-0.25, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*0.7;
		
		

#if LENS_FLARES == 1
		
		
		
		// Small point 1
                

		
			lenscolor = vec3(2.55, 0.5, 0.0) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.27)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.3)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.33)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);

		
		// Small point 2


		
			lenscolor = vec3(2.0, 2.0, 0.0) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.82)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.85)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.88)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);

		
		// Small point 3


		
			lenscolor = vec3(0.0, 1.0, 0.0) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-1.02)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-1.05)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-1.08)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);


		// Small point 4


		
			lenscolor = vec3(8.0, 1.0, 0.0) * lightColor;
			
			lens_strength = 100.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-2.00)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-1.99)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-1.96)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);

		// Big Point 0


		
			lenscolor = vec3(2.7, 1.0, 0.0) * lightColor;
			
			lens_strength = 70.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-2.1)/1.7,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-2.09)/1.7,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-2.06)/1.7,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);

		
		// Big Point urmom


		
			lenscolor = vec3(0.0, 0.9, 1.0) * lightColor;
			
			lens_strength = 60.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-2.2)/1.7,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-2.19)/1.7,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-2.16)/1.7,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);

		
		// Big Point 1


		
			lenscolor = vec3(0.0, 1.0, 0.0) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.92)/4.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.95)/4.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.98)/4.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);


		// Big Point 2


		
			lenscolor = vec3(1.0, 2.0, 0.0) * lightColor;
			
			lens_strength = 90.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.83)/4.6,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.86)/4.6,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.89)/4.6,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);

				
		

		// Big Point 3


		
			lenscolor = vec3(6.0, 2.0, 0.0) * lightColor;
			
			lens_strength = 75.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.53)/3.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.56)/3.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.59)/30.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);

				
		
				
		
		// Ring Lens 1


		
			lenscolor = vec3(0.8, 0.8, 0.0) * length(lightColor);
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.7, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.9, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;



		// Ring Lens 4


		
			lenscolor = vec3(0.0, 0.0, 0.9) * length(lightColor);
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.9, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-1.07, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;



		// Ring Lens 2


		
			lenscolor = vec3(0.0, 0.9, 0.0) * length(lightColor);
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.8, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-1.0, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;

		
		
		// Ring Lens 3


		
			lenscolor = vec3(0.85, 0.0, 0.0) * length(lightColor);
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.6, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.8, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;
		
		
				
		
		// Ring Lens 1


		
			lenscolor = vec3(0.8, 0.8, 0.0) * length(lightColor);
			
			lens_strength = 0.08 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.6, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.8, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;



		// Ring Lens 4


		
			lenscolor = vec3(0.0, 0.0, 0.9) * length(lightColor);
			
			lens_strength = 0.08 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.8, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.97, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;



		// Ring Lens 2


		
			lenscolor = vec3(0.0, 0.9, 0.0) * length(lightColor);
			
			lens_strength = 0.08 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.7, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.9, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;

		
		
		// Ring Lens 3


		
			lenscolor = vec3(0.85, 0.0, 0.0) * length(lightColor);
			
			lens_strength = 0.08 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.5, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.7, 0.3)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;
			
				
		
		// Ring Lens 69


		
			lenscolor = vec3(0.8, 0.8, 0.0) * length(lightColor);
			
			lens_strength = 0.07 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-2.3, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-2.5, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;


		// Ring Lens 420


		
			lenscolor = vec3(0.0, 0.0, 0.9) * length(lightColor);
			
			lens_strength = 0.07 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-2.5, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-2.67, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;



		// Ring Lens 1337


		
			lenscolor = vec3(0.0, 0.9, 0.0) * length(lightColor);
			
			lens_strength = 0.07 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-2.4, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-2.6, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;
		
		
		// Ring Lens 42069


		
			lenscolor = vec3(0.85, 0.0, 0.0) * length(lightColor);
			
			lens_strength = 0.07 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-2.2, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-2.4, 0.2)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;

#endif
		
#if LENS_FLARES == 2
#include "/lib/effect/visual/lens/types/chocapic.glsl"
#endif

#if LENS_FLARES == 3
#include "/lib/effect/visual/lens/types/simple.glsl"
#endif

#if LENS_FLARES == 4
#include "/lib/effect/visual/lens/types/seus.glsl"
#endif

#if LENS_FLARES == 5
#include "/lib/effect/visual/lens/types/oldredhat.glsl"
#endif

#ifdef EYE_BLINDNESS
#include "/lib/effect/visual/lens/types/eyeblindness.glsl"
#endif

#if LENS_FLARES == 6
#include "/lib/effect/visual/lens/types/tme.glsl"
#endif

#if LENS_FLARES == 7
#include "/lib/effect/visual/lens/types/chocastalgia.glsl"
#endif

#if LENS_FLARES == 8
#include "/lib/effect/visual/lens/types/gwz.glsl"
#endif

#if LENS_FLARES == 9
#include "/lib/effect/visual/lens/types/chocimproved.glsl"
#endif
		
		
#ifdef GLOWING_SUN
		
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos2 = tpos.xy/tpos.z;
	vec2 lightPos = pos2*0.5+0.5;
	vec2 lPos = lightPos;
	float truepos = sunPosition.z/abs(sunPosition.z);		//1 -> sun / -1 -> moon

	float xdist = abs(lightPos.x-newTC.x);
	float ydist = abs(lightPos.y-newTC.y);

	float sunvisibility = texture2D(gaux2,vec2(pw,ph)).a*(1-rainStrength*1.9);
	
	float centerdist = clamp(1.0 - pow(cdist(lightPos), 0.01), 0.0, 1.0);

	vec3 light_color = mix(sunlight*sunVisibility,3*moonlight*moonVisibility,(truepos+1.0)/2.0);
	
		if (sunvisibility > 0.05) {

			vec3 lensColor = exp(-ydist*ydist/0.002/(1.5-centerdist))*exp(-xdist*xdist/0.2/(1.5-centerdist))* vec3(0.0,0.0,0.0);

			vec2 LC = vec2(0.5)-lightPos;
					

			//lensColor += gen_circular_lens(vec2(lightPos),0.04*(0.1-centerdist))*pow(sunvisibility,-0.1)*0.2/(centerdist*0.99+0.01);		//sun glare (replace bloom)
			
			lensColor = lensColor*pow(sunvisibility,0.0)*light_color*0.1*centerdist;
			color += lensColor + gen_circular_lens(vec2(lightPos),0.10
			*(1.2-centerdist))*pow(sunvisibility,-0.1)*0.3*pow(sunvisibility,2.0)*light_color*SUN_POWER*(1-centerdist*0.1);
	
		}
		#endif
			
	
	}



			

	