vec3 waterCaustic(vec3 fposition,vec3 color) {
vec3 underwaterpos = vec3(texcoord.st, texture2D(depthtex1, texcoord.st).r);
underwaterpos = nvec3(gbufferProjectionInverse * nvec4(underwaterpos * 2.0 - 1.0));
vec4 worldpositionuw = gbufferModelViewInverse * vec4(underwaterpos,1.0);
vec3 wpos = (worldpositionuw.xyz+cameraPosition.xyz);
#if CAUSTIC_STYLE == 0
#include "/lib/effect/water/causticnoise/noise1.glsl"
#elif CAUSTIC_STYLE == 1
#include "/lib/effect/water/causticnoise/noise2.glsl"
#elif CAUSTIC_STYLE == 2
#include "/lib/effect/water/causticnoise/noise3.glsl"
#endif
float causticstrength = max((noise-1.2),0.0);
float wca = (0.1/CAUSTIC_STRENGTH);
float caustic = (1.0 - (pow(wca,causticstrength)));
vec3 causticColorSunrise = vec3(30,20,10)/255.0;
vec3 causticColorNoon = vec3(20,20,20)/255.0;
vec3 causticColorSunset = vec3(30,20,10)/255.0;
vec3 causticColorNight = vec3(0,0,0)/255.0;
vec3 caustic_color = vec3((causticColorSunrise+TimeSunrise)+(causticColorNoon+TimeNoon)+(causticColorSunset+TimeSunset)+(causticColorNight/50.0+TimeMidnight))/255.0;
vec3 wc = mix(color,caustic_color,caustic);
return wc;
}
