
///// FRAGMENT SHADER //////////////////////////////////////////////////////////////////////////////////////////////
#ifdef FSH
varying vec2 coord;

uniform sampler2D colortex0; // Color
uniform sampler2D colortex1; // Linear Depth
uniform sampler2D colortex4; // Type (Blue = Water; White = sky)
//uniform sampler2D colortex5; // View Direction

uniform float viewHeight;
uniform float viewWidth;

uniform int frameCounter;

ivec2 convertIntCoords(vec2 coord, float x, float y) {
    return ivec2(coord.x * x, coord.y * y);
}
vec2 blurOffset(vec2 coord, float lod) {
    return coord + (vec2(1 / viewWidth, 1 / viewHeight) * 0.5 * (lod + 1));
}

vec3 getAlbedo(in vec2 coord) {
    return texelFetch(colortex0, convertIntCoords(coord, viewWidth, viewHeight), 0).rgb;
}
vec3 getAlbedo_int(in vec2 coord) {
    return texture(colortex0, coord).rgb;
}

/*
vec3 getViewPosition(in vec2 coord) {
    return texture(colortex5, coord).xyz;
} */

/*

*/

const float chromatic_aberration_amount = float(CHROM_ABERRATION) / 500 * CHROM_STRENGTH;

/* DRAWBUFFERS:0 */

vec2 scaleCoord(vec2 coord, float scale) { //Scales Coordinates from Screen Center
    coord.st -= 0.5f; //Make 0/0 center of screen

    coord.st *= scale; //Scaling, divide to make larger number scale in

    //Fix Borders (mirror)
    //If the coordinates exeed maximum (x-Axis):
    if (coord.s > 0.5) {coord.s = 1 - coord.s;}
    if (coord.s < -0.5) {coord.s = -1 - coord.s;}
    //If the coordinates exeed maximum (y-Axis):
    if (coord.t > 0.5) {coord.t = 1 - coord.t;}
    if (coord.t < -0.5) {coord.t = -1 - coord.t;}


    coord.st += 0.5f; //Reverse translation
    return coord;
}

vec3 ChromaticAbberation(vec2 coord, float amount) {
    vec3 col;

    amount = distance(coord, vec2(0.5)) * amount;

    #if CA_COLOR == 0

    // Blue - Red

    //Red Channel
    col.r     = texture(colortex0, scaleCoord(coord, 1.0 - amount)).r;
    //Green Channel
    col.g     = texture(colortex0, coord).g;
    //Blue Channel
    col.b     = texture(colortex0, scaleCoord(coord, 1.0 + amount)).b;

    #elif CA_COLOR == 1

    // Pink - Green

    //Red Channel
    col.r     = texture(colortex0, coord).r;
    //Green Channel
    col.g     = texture(colortex0, scaleCoord(coord, 1.0 - amount)).g;
    //Blue Channel
    col.b     = texture(colortex0, scaleCoord(coord, 1.0 + amount)).b;

    #elif CA_COLOR == 2

    // Green - Red

    //Red Channel
    col.r     = texture(colortex0, scaleCoord(coord, 1.0 - amount)).r;
    //Green Channel
    col.g     = texture(colortex0, scaleCoord(coord, 1.0 + amount)).g;
    //Blue Channel
    col.b     = texture(colortex0, coord).b;


    #elif CA_COLOR == 3

    // Red - Green - Blue

    //Red Channel
    col.r     = texture(colortex0, scaleCoord(coord, 1.0 - amount)).r;
    //Green Channel
    col.g     = texture(colortex0, scaleCoord(coord, 1.0 + amount)).g;
    //Blue Channel
    col.b     = texture(colortex0, scaleCoord(coord, 1.0 + amount)).b;

    #endif

    return col;
}

vec3 saturation(vec3 col, float saturation) {
    float brightness = dot(col, vec3(0.299, 0.587, 0.112));
    return mix(col, vec3(brightness), -saturation);
}

void main() {
    #if CHROM_ABERRATION == 0
        vec3 color = getAlbedo(coord);
    #else
        vec3 color = ChromaticAbberation(coord, chromatic_aberration_amount);
    #endif

    //color = vec3(float(getType(coord) == 3));

    //color = mix(color, color * color * 2, 0.5);
    color = saturation(color, SATURATION);

    gl_FragColor = vec4(color, 1.0);
}
#endif

///// FRAGMENT SHADER //////////////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH
uniform float viewWidth;
uniform float viewHeight;

varying vec2 coord;


void main() {
    gl_Position = ftransform();

    coord = gl_MultiTexCoord0.st;

    
    float pixelWidth = 1.0 / viewWidth;
    float pixelHeight = 1.0 / viewHeight;
}
#endif