/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.frame;

import cd4017be.api.rs_ctr.frame.IFrame;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public interface IFrameOperator {
    public static final EnumFacing[] XYZ_DIRS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH};

    public void onFrameBreak(BlockPos var1);

    public static void scanArea(World world, BlockPos origin, int[] areaOut, int range, EnumFacing front) {
        int l;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int found = 0;
        for (int j = 0; j < 6; ++j) {
            EnumFacing s = XYZ_DIRS[j];
            if (s == front || (l = IFrameOperator.scan(world, p.func_189533_g((Vec3i)origin), s, range)) > range) {
                areaOut[j] = 0;
                continue;
            }
            areaOut[j] = l;
            found |= 1 << j;
        }
        l = 0;
        switch (found) {
            case 36: {
                ++l;
            }
            case 18: {
                ++l;
            }
            case 9: {
                EnumFacing d = XYZ_DIRS[l];
                int n = areaOut[l];
                int m = -areaOut[l + 3];
                for (int j = 0; j < 6; ++j) {
                    EnumFacing s;
                    if ((found >> j & 1) != 0 || (s = XYZ_DIRS[j]) == front || (l = Math.min(IFrameOperator.scan(world, p.func_189533_g((Vec3i)origin).func_189534_c(d, n), s, range), IFrameOperator.scan(world, p.func_189533_g((Vec3i)origin).func_189534_c(d, m), s, range))) > range) continue;
                    areaOut[j] = l;
                }
                break;
            }
        }
        areaOut[3] = areaOut[3] + (areaOut[0] - 1);
        areaOut[4] = areaOut[4] + (areaOut[1] + 1);
        areaOut[5] = areaOut[5] + (areaOut[2] - 1);
        areaOut[0] = origin.func_177958_n() - areaOut[0] + 1;
        areaOut[1] = origin.func_177956_o() - areaOut[1];
        areaOut[2] = origin.func_177952_p() - areaOut[2] + 1;
    }

    public static int scan(World world, BlockPos.MutableBlockPos p, EnumFacing s, int range) {
        int dx = s.func_82601_c();
        int dy = s.func_96559_d();
        int dz = s.func_82599_e();
        int x = p.func_177958_n();
        int y = p.func_177956_o();
        int z = p.func_177952_p();
        for (int i = 1; i <= range; ++i) {
            if (!(world.func_175625_s((BlockPos)p.func_181079_c(x += dx, y += dy, z += dz)) instanceof IFrame)) continue;
            return i;
        }
        return range + 1;
    }

    public static BlockPos getCorner(int[] area, int i) {
        return new BlockPos(area[0] + ((i & 1) != 0 ? area[3] : -1), area[1] + ((i & 2) != 0 ? area[4] - 1 : 0), area[2] + ((i & 4) != 0 ? area[5] : -1));
    }

    public static int checkCorners(World world, BlockPos origin, int[] area) {
        int status = 0;
        for (int i = 0; i < 8; ++i) {
            BlockPos p = IFrameOperator.getCorner(area, i);
            if (p.equals((Object)origin)) continue;
            TileEntity te = world.func_175625_s(p);
            if (te instanceof IFrame) {
                ((IFrame)te).link(origin);
                continue;
            }
            status |= 1 << i;
        }
        return status;
    }

    public static void unlinkCorners(World world, BlockPos origin, int[] area, int corners) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            TileEntity te;
            BlockPos pos;
            if ((corners >> i & 1) == 0 || (pos = IFrameOperator.getCorner(area, i)).equals((Object)origin) || !((te = world.func_175625_s(pos)) instanceof IFrame)) continue;
            ((IFrame)te).unlink(origin);
        }
    }

    public static void readArea(int[] area, NBTTagCompound nbt, BlockPos pos) {
        if (nbt.func_150297_b("area", 11)) {
            int[] arr = nbt.func_74759_k("area");
            System.arraycopy(arr, 0, area, 0, Math.min(arr.length, 6));
            return;
        }
        int[] arr = nbt.func_74759_k("region");
        System.arraycopy(arr, 0, area, 0, Math.min(arr.length, 6));
        area[0] = area[0] + pos.func_177958_n();
        area[1] = area[1] + pos.func_177956_o();
        area[2] = area[2] + pos.func_177952_p();
    }

    public static void writeArea(int[] area, NBTTagCompound nbt, BlockPos pos) {
        int[] arr = (int[])area.clone();
        arr[0] = arr[0] - pos.func_177958_n();
        arr[1] = arr[1] - pos.func_177956_o();
        arr[2] = arr[2] - pos.func_177952_p();
        nbt.func_74783_a("region", arr);
    }
}

