/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr;

import cd4017be.api.recipes.ItemOperand;
import cd4017be.api.recipes.RecipeAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.sensor.IBlockSensor;
import cd4017be.api.rs_ctr.sensor.SensorRegistry;
import cd4017be.api.rs_ctr.wire.RelayPort;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.util.ItemKey;
import cd4017be.lib.util.OreDictStack;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.circuit.data.ArrayEditor;
import cd4017be.rs_ctr.circuit.data.FloatValue;
import cd4017be.rs_ctr.circuit.data.GateConfiguration;
import cd4017be.rs_ctr.circuit.data.IntegerValue;
import cd4017be.rs_ctr.circuit.data.ToggleFlag;
import cd4017be.rs_ctr.circuit.data.VariantEnum;
import cd4017be.rs_ctr.circuit.editor.CircuitInstructionSet;
import cd4017be.rs_ctr.circuit.editor.IGateProvider;
import cd4017be.rs_ctr.circuit.gates.Array;
import cd4017be.rs_ctr.circuit.gates.ConstNum;
import cd4017be.rs_ctr.circuit.gates.End;
import cd4017be.rs_ctr.circuit.gates.Input;
import cd4017be.rs_ctr.circuit.gates.Output;
import cd4017be.rs_ctr.circuit.gates.ReadVar;
import cd4017be.rs_ctr.circuit.gates.ReadWriteVar;
import cd4017be.rs_ctr.circuit.gates.WriteVar;
import cd4017be.rs_ctr.item.ItemBlockProbe;
import cd4017be.rs_ctr.item.ItemWireCon;
import cd4017be.rs_ctr.port.BlockProbe;
import cd4017be.rs_ctr.port.Constant;
import cd4017be.rs_ctr.port.EdgeTrigger;
import cd4017be.rs_ctr.port.PulseGen;
import cd4017be.rs_ctr.port.RemoteReceiver;
import cd4017be.rs_ctr.port.SplitPlug;
import cd4017be.rs_ctr.port.StatusLamp;
import cd4017be.rs_ctr.port.WireAnchor;
import cd4017be.rs_ctr.port.WireType;
import cd4017be.rs_ctr.sensor.BlockHardnessSensor;
import cd4017be.rs_ctr.sensor.DraconicFusionSensor;
import cd4017be.rs_ctr.sensor.FluidSensor;
import cd4017be.rs_ctr.sensor.ForgeEnergySensor;
import cd4017be.rs_ctr.sensor.GrowthSensor;
import cd4017be.rs_ctr.sensor.IC2EnergySensor;
import cd4017be.rs_ctr.sensor.ItemSensor;
import cd4017be.rs_ctr.sensor.LightSensor;
import cd4017be.rs_ctr.tileentity.BlockBreaker;
import cd4017be.rs_ctr.tileentity.BlockSelector;
import cd4017be.rs_ctr.tileentity.ChunkLoader;
import cd4017be.rs_ctr.tileentity.FluidTranslocator;
import cd4017be.rs_ctr.tileentity.ItemPlacer;
import cd4017be.rs_ctr.tileentity.ItemTranslocator;
import cd4017be.rs_ctr.tileentity.OC_Adapter;
import cd4017be.rs_ctr.tileentity.Panel;
import cd4017be.rs_ctr.tileentity.PowerHub;
import cd4017be.rs_ctr.tileentity.SolarCell;
import cd4017be.rs_ctr.tileentity.StructTeleporter;
import cd4017be.rs_ctr.tileentity.Teleporter;
import cd4017be.rs_ctr.tileentity.part.BlockSocket;
import cd4017be.rs_ctr.tileentity.part.Clock;
import cd4017be.rs_ctr.tileentity.part.Lamp;
import cd4017be.rs_ctr.tileentity.part.Lever;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.Offset;
import cd4017be.rs_ctr.tileentity.part.Oscilloscope;
import cd4017be.rs_ctr.tileentity.part.PointerDisplay;
import cd4017be.rs_ctr.tileentity.part.Scale;
import cd4017be.rs_ctr.tileentity.part.SignalSocket;
import cd4017be.rs_ctr.tileentity.part.Slider;
import cd4017be.rs_ctr.tileentity.part.Text;
import cd4017be.rs_ctr.tileentity.part.Trigger;
import cd4017be.rs_ctr.tileentity.part._7Segment;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class CommonProxy
implements RecipeAPI.IRecipeHandler {
    public static final boolean HAS_IC2_API = org.apache.logging.log4j.core.util.Loader.isClassAvailable((String)"ic2.api.tile.IEnergyStorage");
    public static final String CIRCUIT_MAT = "circuitMat";
    public static final String BATTERY = "battery";
    public static final int[] NULL = new int[6];
    public static final HashMap<ItemKey, int[]> MATERIALS = new HashMap();
    public static final HashMap<ItemKey, Long> BATTERIES = new HashMap();

    public static int[] getStats(ItemStack stack) {
        int[] e = MATERIALS.get(new ItemKey(new ItemStack[]{stack}));
        return e == null ? NULL : e;
    }

    public static long getCap(ItemStack stack) {
        Long c = BATTERIES.get(new ItemKey(new ItemStack[]{stack}));
        return c == null ? 0L : c * (long)stack.func_190916_E();
    }

    public void addRecipe(Parameters param) {
        block9: {
            String key;
            block7: {
                IOperand op;
                int[] stats;
                block8: {
                    key = param.getString(0);
                    if (!key.equals(CIRCUIT_MAT)) break block7;
                    double[] arr = param.getVectorOrAll(2);
                    stats = new int[NULL.length];
                    int n = Math.min(arr.length, stats.length);
                    for (int i = 0; i < n; ++i) {
                        stats[i] = (int)arr[i];
                    }
                    op = param.param[1];
                    if (!(op instanceof ItemOperand)) break block8;
                    MATERIALS.put(new ItemKey(new ItemStack[]{((ItemOperand)op).stack}), stats);
                    break block9;
                }
                if (!(op instanceof OreDictStack)) break block9;
                for (ItemStack stack : ((OreDictStack)op).getItems()) {
                    MATERIALS.put(new ItemKey(new ItemStack[]{stack}), stats);
                }
                break block9;
            }
            if (key.equals(BATTERY)) {
                Long cap = (long)param.getNumber(2);
                IOperand op = param.param[1];
                if (op instanceof ItemOperand) {
                    BATTERIES.put(new ItemKey(new ItemStack[]{((ItemOperand)op).stack}), cap);
                } else if (op instanceof OreDictStack) {
                    for (ItemStack stack : ((OreDictStack)op).getItems()) {
                        BATTERIES.put(new ItemKey(new ItemStack[]{stack}), cap);
                    }
                }
            }
        }
    }

    public void preInit() {
        RelayPort.IMPLEMENTATION = WireAnchor::new;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerGates();
        ((cd4017be.lib.script.Module)RecipeScriptContext.instance.modules.get("redstoneControl")).assign("gate_cost", (IOperand)CircuitInstructionSet.INS_SET);
        RecipeAPI.Handlers.put(CIRCUIT_MAT, this);
        RecipeAPI.Handlers.put(BATTERY, this);
    }

    public void init(RecipeScriptContext.ConfigConstants c) {
        ItemWireCon.MAX_LENGTH = (int)c.getNumber("max_wire_length", (double)ItemWireCon.MAX_LENGTH);
        ItemBlockProbe.MAX_LENGTH = (int)c.getNumber("block_plug_range", (double)ItemBlockProbe.MAX_LENGTH);
        SplitPlug.MAX_LINK_COUNT = (int)c.getNumber("max_split_links", (double)SplitPlug.MAX_LINK_COUNT);
        BlockReference.INIT_LIFESPAN = (int)c.getNumber("blockref_livespan", (double)BlockReference.INIT_LIFESPAN);
        double d = c.getNumber("panel_sync_dst_min", Math.sqrt(Panel.UPDATE_RANGE0));
        Panel.UPDATE_RANGE0 = d * d;
        d = c.getNumber("panel_sync_dst_max", Math.sqrt(Panel.UPDATE_RANGE1));
        Panel.UPDATE_RANGE1 = d * d;
        d = c.getNumber("panel_text_render_dst", Math.sqrt(Panel.TEXT_RANGE));
        Panel.TEXT_RANGE = d * d;
        PowerHub.FE_UNIT = (long)c.getNumber("energy_unit_FE", (double)PowerHub.FE_UNIT);
        OC_Adapter.OC_UNIT = c.getNumber("energy_unit_OC", OC_Adapter.OC_UNIT);
        ItemTranslocator.BASE_COST = -((int)c.getNumber("energy_item_translocator_op", (double)(-ItemTranslocator.BASE_COST)));
        ItemTranslocator.TRANSFER_COST = -((int)c.getNumber("energy_item_translocator_ps", (double)(-ItemTranslocator.TRANSFER_COST)));
        FluidTranslocator.BASE_COST = -((int)c.getNumber("energy_fluid_translocator_op", (double)(-FluidTranslocator.BASE_COST)));
        FluidTranslocator.TRANSFER_COST = -((int)c.getNumber("energy_fluid_translocator_pb", (double)(-FluidTranslocator.TRANSFER_COST)));
        FluidTranslocator.BLOCK_COST = -((int)c.getNumber("energy_fluid_translocator_world", (double)(-FluidTranslocator.BLOCK_COST)));
        SolarCell.POWER = (int)c.getNumber("energy_solar", (double)SolarCell.POWER);
        BlockSelector.RANGE = (int)c.getNumber("block_select_range", (double)BlockSelector.RANGE);
        BlockBreaker.BASE_ENERGY = (float)c.getNumber("energy_breaker_op", (double)BlockBreaker.BASE_ENERGY);
        BlockBreaker.ENERGY_MULT = (float)c.getNumber("energy_breaker_hard", (double)BlockBreaker.ENERGY_MULT);
        BlockBreaker.SPEED_MOD = (float)c.getNumber("energy_breaker_speed", (double)BlockBreaker.SPEED_MOD);
        BlockBreaker.NO_TOOL_MULT = (float)c.getNumber("energy_breaker_byhand", (double)BlockBreaker.NO_TOOL_MULT);
        ItemPlacer.BASE_ENERGY = (float)c.getNumber("energy_placer_op", (double)ItemPlacer.BASE_ENERGY);
        ItemPlacer.SPEED_MOD = (float)c.getNumber("energy_placer_speed", (double)ItemPlacer.SPEED_MOD);
        ChunkLoader.RANGE = (int)c.getNumber("chunk_loader_range", (double)ChunkLoader.RANGE);
        ChunkLoader.MAX_MINUTES = (int)(c.getNumber("chunkload_time_cap", (double)ChunkLoader.MAX_MINUTES / 60.0) * 60.0);
        Objects.cl_fuel.func_77656_e((int)(c.getNumber("chunkload_item_time", (double)Objects.cl_fuel.func_77612_l() / 60.0) * 60.0));
        StructTeleporter.RANGE = (int)c.getNumber("teleporter_range", (double)StructTeleporter.RANGE);
        Teleporter.ENERGY_PER_BLOCK = c.getNumber("energy_teleport_pb", StructTeleporter.ENERGY_PER_BLOCK);
        Teleporter.MAX_DISTANCE = c.getNumber("teleport_dist_cap", StructTeleporter.MAX_DISTANCE);
        for (Object o : (Object[])c.get("teleport_whitelist", Object[].class, (Object)new Object[0])) {
            if (!(o instanceof String)) continue;
            Teleporter.addEntry((String)o, false);
        }
        for (Object o : (Object[])c.get("teleport_blacklist", Object[].class, (Object)new Object[0])) {
            if (!(o instanceof String)) continue;
            Teleporter.addEntry((String)o, true);
        }
        this.registerSensor(new ItemSensor(), (Object[])c.get("sensors_item", Object[].class, null));
        this.registerSensor(new FluidSensor(), (Object[])c.get("sensors_fluid", Object[].class, null));
        this.registerSensor(new ForgeEnergySensor(), (Object[])c.get("sensors_FE", Object[].class, null));
        this.registerSensor(new BlockHardnessSensor(), (Object[])c.get("sensors_hard", Object[].class, null));
        this.registerSensor(new LightSensor(), (Object[])c.get("sensors_light", Object[].class, null));
        this.registerSensor(new GrowthSensor(), (Object[])c.get("sensors_grow", Object[].class, null));
        if (HAS_IC2_API) {
            this.registerSensor(new IC2EnergySensor(), (Object[])c.get("sensors_EU", Object[].class, null));
        }
        if (Loader.isModLoaded((String)"draconicevolution")) {
            this.registerSensor((ItemStack stack) -> new DraconicFusionSensor(), (Object[])c.get("sensors_draconic", Object[].class, null));
        }
        WireType.registerAll();
        Connector.REGISTRY.put("const", Constant::new);
        Connector.REGISTRY.put("lamp", StatusLamp::new);
        Connector.REGISTRY.put("blockProbe", BlockProbe::new);
        Connector.REGISTRY.put("clock", cd4017be.rs_ctr.port.Clock::new);
        Connector.REGISTRY.put("edge_trigger", EdgeTrigger::new);
        Connector.REGISTRY.put("pulse_gen", PulseGen::new);
        Connector.REGISTRY.put("remote", RemoteReceiver::new);
        Module.REGISTRY.put("7seg", _7Segment::new);
        Module.REGISTRY.put("pointer", PointerDisplay::new);
        Module.REGISTRY.put("slider", Slider::new);
        Module.REGISTRY.put("text", Text::new);
        Module.REGISTRY.put("lever", Lever::new);
        Module.REGISTRY.put("lamp", Lamp::new);
        Module.REGISTRY.put("clock", Clock::new);
        Module.REGISTRY.put("trigger", Trigger::new);
        Module.REGISTRY.put("scale", Scale::new);
        Module.REGISTRY.put("offset", Offset::new);
        Module.REGISTRY.put("oscilloscope", Oscilloscope::new);
        Module.REGISTRY.put("socket_s", SignalSocket::new);
        Module.REGISTRY.put("socket_b", BlockSocket::new);
        CircuitInstructionSet.INS_SET.loadTabs();
    }

    private void registerGates() {
        IGateProvider.REGISTRY.put("in", Input::new);
        IGateProvider.REGISTRY.put("out", Output::new);
        IGateProvider.REGISTRY.put("read", ReadVar::new);
        IGateProvider.REGISTRY.put("write", WriteVar::new);
        IGateProvider.REGISTRY.put("readwrite", ReadWriteVar::new);
        IGateProvider.REGISTRY.put("const", ConstNum::new);
        IGateProvider.REGISTRY.put("end", End::new);
        IGateProvider.REGISTRY.put("array", Array::new);
        GateConfiguration.REGISTRY.put("value", IntegerValue.VALUE);
        GateConfiguration.REGISTRY.put("value_f", FloatValue.VALUE);
        GateConfiguration.REGISTRY.put("interrupt", ToggleFlag.INTERRUPT);
        GateConfiguration.REGISTRY.put("sign", ToggleFlag.SIGNED);
        GateConfiguration.REGISTRY.put("arrayB", ArrayEditor.BYTE_ARRAY);
        GateConfiguration.REGISTRY.put("arrayS", ArrayEditor.SHORT_ARRAY);
        GateConfiguration.REGISTRY.put("arrayI", ArrayEditor.INT_ARRAY);
        GateConfiguration.REGISTRY.put("arrayF", ArrayEditor.FLOAT_ARRAY);
        GateConfiguration.REGISTRY.put("enum2", new VariantEnum(2));
        GateConfiguration.REGISTRY.put("enum3", new VariantEnum(3));
        GateConfiguration.REGISTRY.put("enum4", new VariantEnum(4));
        CircuitInstructionSet.registerTab("rs_ctr:io");
        CircuitInstructionSet.registerTab("rs_ctr:logic");
        CircuitInstructionSet.registerTab("rs_ctr:bin");
        CircuitInstructionSet.registerTab("rs_ctr:comp");
        CircuitInstructionSet.registerTab("rs_ctr:num");
        CircuitInstructionSet.registerTab("rs_ctr:float");
    }

    private void registerSensor(IBlockSensor sensor, Object[] items) {
        this.registerSensor((ItemStack stack) -> sensor, items);
    }

    private void registerSensor(Function<ItemStack, IBlockSensor> loader, Object[] items) {
        if (items == null) {
            return;
        }
        for (Object o : items) {
            if (o instanceof ItemStack) {
                SensorRegistry.register(loader, (ItemStack[])new ItemStack[]{(ItemStack)o});
                continue;
            }
            if (!(o instanceof String)) continue;
            SensorRegistry.register(loader, (ItemStack[])((ItemStack[])OreDictionary.getOres((String)((String)o)).toArray((Object[])new ItemStack[0])));
        }
    }
}

