/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.api.rs_ctr.port.Link;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.ScriptFiles;
import cd4017be.rs_ctr.CommonProxy;
import cd4017be.rs_ctr.IChunkLoader;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.OC_Adapter;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="rs_ctr", useMetadata=true, acceptedMinecraftVersions="[1.12.2]")
public class Main
implements ForgeChunkManager.PlayerOrderedLoadingCallback {
    public static final String ID = "rs_ctr";
    @Mod.Instance(value="rs_ctr")
    public static Main instance;
    public static Logger LOG;
    @SidedProxy(clientSide="cd4017be.rs_ctr.ClientProxy", serverSide="cd4017be.rs_ctr.CommonProxy")
    public static CommonProxy proxy;

    public Main() {
        RecipeScriptContext.scriptRegistry.add(new ScriptFiles.Version("redstoneControl", "/assets/rs_ctr/config/recipes.rcp"));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG = event.getModLog();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)this);
        proxy.preInit();
        RecipeScriptContext.instance.run("redstoneControl.PRE_INIT");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Objects.init();
        proxy.init(new RecipeScriptContext.ConfigConstants((Module)RecipeScriptContext.instance.modules.get("redstoneControl")));
        if (Loader.isModLoaded((String)"opencomputers")) {
            OC_Adapter.registerAPI();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent event) {
        Link.loadData((File)new File(FMLCommonHandler.instance().getSavesDirectory(), event.getServer().func_71270_I()));
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        Link.saveData();
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket t : tickets) {
            BlockPos pos;
            TileEntity te;
            NBTTagCompound nbt = t.getModData();
            if (t.getType() == ForgeChunkManager.Type.NORMAL && (te = world.func_175625_s(pos = BlockPos.func_177969_a((long)nbt.func_74763_f("pos")))) instanceof IChunkLoader && ((IChunkLoader)te).setTicket(t)) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)t);
        }
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }
}

