/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit;

import cd4017be.rs_ctr.circuit.Circuit;
import cd4017be.rs_ctr.circuit.CompiledCircuit;
import cd4017be.rs_ctr.circuit.UnloadedCircuit;
import cd4017be.rs_ctr.circuit.editor.GetFieldNode;
import cd4017be.rs_ctr.circuit.gates.Input;
import cd4017be.rs_ctr.circuit.gates.Output;
import cd4017be.rscpl.compile.Compiler;
import cd4017be.rscpl.compile.Context;
import cd4017be.rscpl.compile.Dep;
import cd4017be.rscpl.compile.Node;
import cd4017be.rscpl.compile.NodeCompiler;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.InvalidSchematicException;
import cd4017be.rscpl.editor.Pin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CircuitCompiler
extends Compiler<CompiledCircuit> {
    public static final CircuitCompiler INSTANCE = new CircuitCompiler();
    public static final NodeCompiler getIOArr = new GetFieldNode(Type.getType((String)"[I"));
    private static final Comparator<Gate> BY_VERT_POS = (g1, g2) -> g1.rasterY - g2.rasterY;

    private CircuitCompiler() {
        super(Circuit.class, new Class[0]);
        this.setName(UnloadedCircuit.name(new UUID(0L, 0L)));
    }

    @Override
    protected CompiledCircuit newProgram(Collection<Gate> gatesIn) throws InvalidSchematicException {
        int i;
        CompiledCircuit cc = new CompiledCircuit();
        ArrayList<Input> inputs = new ArrayList<Input>();
        ArrayList<Output> outputs = new ArrayList<Output>();
        Node in = new Node(getIOArr, "inputs", new Node[0]);
        Node out = new Node(getIOArr, "outputs", new Node[0]);
        block0: for (Gate g : gatesIn) {
            if (g == null) continue;
            if (g instanceof Input) {
                Input i2 = (Input)g;
                i2.setLink(in, 0);
                inputs.add(i2);
            } else if (g instanceof Output) {
                Output o = (Output)g;
                o.setLink(out, 0);
                outputs.add(o);
            }
            if (cc.compileWarning != null || g.outputs.length == 0) continue;
            for (Pin p : g.outputs) {
                if (!p.receivers.isEmpty()) continue block0;
            }
            cc.compileWarning = new InvalidSchematicException(65, g, g.inputCount());
        }
        Collections.sort(inputs, BY_VERT_POS);
        for (i = 0; i < inputs.size(); ++i) {
            ((Input)inputs.get((int)i)).portID = i;
        }
        Collections.sort(outputs, BY_VERT_POS);
        for (i = 0; i < outputs.size(); ++i) {
            ((Output)outputs.get((int)i)).portID = i;
        }
        cc.setIOPins(inputs, outputs);
        return cc;
    }

    @Override
    public void compile(Dep retVal, ClassWriter cw) {
        Context c = new Context(this, 2);
        MethodVisitor mv = cw.visitMethod(1, "tick", "()I", null, null);
        mv.visitCode();
        mv.visitInsn(3);
        mv.visitVarInsn(54, 1);
        retVal.compile(mv, c);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(0, 2);
        mv.visitEnd();
    }
}

