/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit;

import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.circuit.Circuit;
import cd4017be.rs_ctr.circuit.CircuitLoader;
import cd4017be.rs_ctr.circuit.UnloadedCircuit;
import cd4017be.rs_ctr.circuit.gates.Input;
import cd4017be.rs_ctr.circuit.gates.Output;
import cd4017be.rscpl.compile.CompiledProgram;
import cd4017be.rscpl.editor.InvalidSchematicException;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CompiledCircuit
extends UnloadedCircuit
implements CompiledProgram {
    public InvalidSchematicException compileWarning;
    public String[] ioLabels;
    byte[] classCode;
    private static final HashFunction hashfunc = Hashing.murmur3_128();

    @Override
    public void setCode(byte[] code) {
        this.ID = CompiledCircuit.hash(code);
        int i = 13;
        for (char c : CompiledCircuit.name(this.ID).toCharArray()) {
            code[i++] = (byte)c;
        }
        this.classCode = code;
    }

    public void setIOPins(List<Input> inputs, List<Output> outputs) {
        this.inputs = new int[inputs.size()];
        this.outputs = new int[outputs.size()];
        this.ioLabels = new String[this.inputs.length + this.outputs.length];
        int n = 0;
        for (Input i : inputs) {
            if (Boolean.TRUE.equals(i.getParam(0))) {
                this.interruptPins |= 1 << n;
            }
            this.ioLabels[n++] = i.label;
            if (!i.label.isEmpty()) continue;
            this.compileWarning = new InvalidSchematicException(64, i, 0);
        }
        for (Output o : outputs) {
            this.ioLabels[n++] = o.label;
            if (!o.label.isEmpty()) continue;
            this.compileWarning = new InvalidSchematicException(64, o, 0);
        }
    }

    @Override
    public Circuit load() {
        if (this.ID == null) {
            return this;
        }
        String name = CompiledCircuit.name(this.ID);
        CircuitLoader.INSTANCE.register(name, this.classCode);
        Circuit c = CircuitLoader.INSTANCE.newCircuit(name);
        if (c == null) {
            return this;
        }
        c.deserializeNBT(this.serializeNBT());
        return c;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74782_a("labels", (NBTBase)Utils.writeStringArray((String[])this.ioLabels));
        if (this.classCode != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
                GZIPOutputStream os = new GZIPOutputStream(bos);
                os.write(this.classCode);
                os.close();
                nbt.func_74773_a("class", bos.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.ioLabels = Utils.readStringArray((NBTTagList)nbt.func_150295_c("labels", 8), (String[])new String[this.inputs.length + this.outputs.length]);
        if (nbt.func_150297_b("class", 7)) {
            try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(nbt.func_74770_j("class")));){
                ByteBuf buf = Unpooled.buffer((int)4096);
                while (buf.writeBytes((InputStream)is, 4096) > 0) {
                }
                is.close();
                this.classCode = new byte[buf.readableBytes()];
                buf.readBytes(this.classCode);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.classCode = null;
            }
        }
    }

    public static UUID hash(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(hashfunc.hashBytes(data).asBytes());
        return new UUID(buf.getLong(), buf.getLong());
    }
}

