/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit.data;

import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Spinner;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.rs_ctr.circuit.data.GateConfiguration;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.objectweb.asm.Type;

public class ArrayEditor
implements GateConfiguration<Object> {
    public static final int MAX_ARRAY_LENGTH = 256;
    public static final ArrayEditor BYTE_ARRAY = new ArrayEditor(new byte[0]);
    public static final ArrayEditor SHORT_ARRAY = new ArrayEditor(new short[0]);
    public static final ArrayEditor INT_ARRAY = new ArrayEditor(new int[0]);
    public static final ArrayEditor FLOAT_ARRAY = new ArrayEditor(new float[0]);
    final Object emptyArray;
    public final Type type;

    public ArrayEditor(Object array) {
        this.type = Type.getType(array.getClass().getComponentType());
        this.emptyArray = array;
    }

    @Override
    public Object init() {
        return this.emptyArray;
    }

    @Override
    public void write(ByteBuf data, Object cfg) {
        data.writeShort(Array.getLength(cfg));
        switch (this.type.getSort()) {
            case 3: {
                data.writeBytes((byte[])cfg);
                return;
            }
            case 4: {
                for (short s : (short[])cfg) {
                    data.writeShort((int)s);
                }
                return;
            }
            case 5: {
                for (int s : (int[])cfg) {
                    data.writeInt(s);
                }
                return;
            }
            case 6: {
                for (float s : (float[])cfg) {
                    data.writeFloat(s);
                }
                return;
            }
            case 7: {
                for (long s : (long[])cfg) {
                    data.writeLong(s);
                }
                return;
            }
            case 8: {
                for (double s : (double[])cfg) {
                    data.writeDouble(s);
                }
                return;
            }
        }
    }

    @Override
    public Object read(ByteBuf data) {
        int l = data.readUnsignedShort();
        if (l > 256) {
            return this.emptyArray;
        }
        switch (this.type.getSort()) {
            case 3: {
                byte[] arr = new byte[l];
                data.readBytes(arr);
                return arr;
            }
            case 4: {
                short[] arr = new short[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readShort();
                }
                return arr;
            }
            case 5: {
                int[] arr = new int[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readInt();
                }
                return arr;
            }
            case 6: {
                float[] arr = new float[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readFloat();
                }
                return arr;
            }
            case 7: {
                long[] arr = new long[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readLong();
                }
                return arr;
            }
            case 8: {
                double[] arr = new double[l];
                for (int i = 0; i < l; ++i) {
                    arr[i] = data.readDouble();
                }
                return arr;
            }
        }
        return null;
    }

    @Override
    public int setupCfgGUI(GuiFrame gui, int y, Supplier<Object> get, Consumer<Object> set, String id) {
        Edit ed = new Edit(get, set);
        new TextField((GuiCompGroup)gui, 26, 7, 1, y + 1, Integer.toString(256).length(), () -> Integer.toString(ed.getLength()), t -> {
            try {
                ed.setLenght(Integer.parseInt(t));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.array_len");
        Spinner s = new Spinner((GuiCompGroup)gui, 30, 8, 28, y + 1, true, "\\%.0f", (DoubleSupplier)ed, (DoubleConsumer)ed, 0.0, 256.0, new double[]{1.0}).tooltip("gui.rs_ctr.array_idx");
        ((Button)s.get(0)).texture(168, 80);
        ((Button)s.get(1)).texture(173, 80);
        new Button((GuiCompGroup)gui, 18, 9, 58, y, 2, (IntSupplier)ed, (IntConsumer)ed).texture(168, 166).tooltip("gui.rs_ctr.hex#");
        new TextField((GuiCompGroup)gui, 74, 7, 1, y + 10, 20, (Supplier)ed, (Consumer)ed).tooltip("gui.rs_ctr.value");
        return y + 18;
    }

    public static Number parse(String s, boolean hex) throws NumberFormatException {
        if (s.indexOf(46) >= 0) {
            return Double.valueOf(s);
        }
        return Long.parseLong(s, hex ? 16 : 10);
    }

    public static String format(Number x, boolean hex) {
        if (hex) {
            return String.format(x instanceof Double || x instanceof Float ? "%a" : "%x", x);
        }
        return x.toString();
    }

    class Edit
    implements DoubleSupplier,
    DoubleConsumer,
    IntSupplier,
    IntConsumer,
    Supplier<String>,
    Consumer<String> {
        final Supplier<Object> get;
        final Consumer<Object> set;
        public int index;
        public boolean hex;

        public Edit(Supplier<Object> get, Consumer<Object> set) {
            this.get = get;
            this.set = set;
        }

        public int getLength() {
            return Array.getLength(this.get.get());
        }

        public void setLenght(int l) {
            if (l < 0 || l > 256) {
                return;
            }
            Object old = this.get.get();
            Object arr = Array.newInstance(old.getClass().getComponentType(), l);
            System.arraycopy(old, 0, arr, 0, Math.min(l, Array.getLength(old)));
            this.set.accept(arr);
        }

        @Override
        public void accept(String t) {
            Number n;
            Object arr = this.get.get();
            if (this.index >= Array.getLength(arr)) {
                return;
            }
            try {
                n = ArrayEditor.parse(t, this.hex);
            }
            catch (NumberFormatException e) {
                return;
            }
            switch (ArrayEditor.this.type.getSort()) {
                case 3: {
                    Array.setByte(arr, this.index, n.byteValue());
                    break;
                }
                case 4: {
                    Array.setShort(arr, this.index, n.shortValue());
                    break;
                }
                case 5: {
                    Array.setInt(arr, this.index, n.intValue());
                    break;
                }
                case 6: {
                    Array.setFloat(arr, this.index, n.floatValue());
                    break;
                }
                case 7: {
                    Array.setLong(arr, this.index, n.longValue());
                    break;
                }
                case 8: {
                    Array.setDouble(arr, this.index, n.doubleValue());
                }
            }
            this.set.accept(arr);
        }

        @Override
        public String get() {
            Object arr = this.get.get();
            if (this.index >= Array.getLength(arr)) {
                return "";
            }
            return ArrayEditor.format((Number)Array.get(arr, this.index), this.hex);
        }

        @Override
        public void accept(int value) {
            this.hex = value != 0;
        }

        @Override
        public int getAsInt() {
            return this.hex ? 1 : 0;
        }

        @Override
        public void accept(double value) {
            this.index = (int)value;
            int l = this.getLength();
            if (this.index >= l) {
                this.index = l - 1;
            }
            if (this.index < 0) {
                this.index = 0;
            }
        }

        @Override
        public double getAsDouble() {
            return this.index;
        }
    }
}

